/*
 * Decompiled with CFR 0.152.
 */
package net.dyrohc.cravings;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(modid="cravings", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ConfigFileServer {
    public static final ForgeConfigSpec SERVER_CONFIG;
    public static final Server SERVER;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading event) {
        if (event.getConfig().getType() == ModConfig.Type.SERVER) {
            ConfigFileServer.apply();
        }
    }

    @SubscribeEvent
    public static void onReloading(ModConfigEvent.Reloading event) {
        if (event.getConfig().getType() == ModConfig.Type.SERVER) {
            ConfigFileServer.apply();
        }
    }

    public static void apply() {
    }

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        SERVER = new Server(builder);
        SERVER_CONFIG = builder.build();
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)SERVER_CONFIG, "Cravings/cravings-main.toml");
    }

    public static class Server {
        public final ForgeConfigSpec.BooleanValue CFG_sweet_craving_toggle;
        public final ForgeConfigSpec.BooleanValue CFG_healthy_craving_toggle;
        public final ForgeConfigSpec.BooleanValue CFG_meaty_craving_toggle;
        public final ForgeConfigSpec.BooleanValue CFG_fishy_craving_toggle;
        public final ForgeConfigSpec.BooleanValue CFG_gross_craving_toggle;
        public final ForgeConfigSpec.BooleanValue CFG_fancy_craving_toggle;
        public final ForgeConfigSpec.BooleanValue CFG_hearty_craving_toggle;
        public final ForgeConfigSpec.BooleanValue CFG_raw_craving_toggle;
        public final ForgeConfigSpec.IntValue CFG_craving_set_interval;
        public final ForgeConfigSpec.BooleanValue CFG_particles_toggle;
        public final ForgeConfigSpec.BooleanValue CFG_craving_timers;
        public final ForgeConfigSpec.IntValue CFG_sweet_craving_weight;
        public final ForgeConfigSpec.IntValue CFG_healthy_craving_weight;
        public final ForgeConfigSpec.IntValue CFG_meaty_craving_weight;
        public final ForgeConfigSpec.IntValue CFG_fishy_craving_weight;
        public final ForgeConfigSpec.IntValue CFG_gross_craving_weight;
        public final ForgeConfigSpec.IntValue CFG_fancy_craving_weight;
        public final ForgeConfigSpec.IntValue CFG_hearty_craving_weight;
        public final ForgeConfigSpec.IntValue CFG_raw_craving_weight;
        public final ForgeConfigSpec.IntValue CFG_streak_amount;
        public final ForgeConfigSpec.IntValue CFG_bonus_xp;
        public final ForgeConfigSpec.DoubleValue CFG_bonus_saturation;
        public final ForgeConfigSpec.IntValue CFG_bonus_level;
        public final ForgeConfigSpec.IntValue CFG_bonus_duration;
        public final ForgeConfigSpec.BooleanValue CFG_upset_stomach_toggle;
        public final ForgeConfigSpec.IntValue CFG_upset_stomach_duration;

        Server(ForgeConfigSpec.Builder builder) {
            builder.push("Craving toggles");
            this.CFG_sweet_craving_toggle = builder.comment("Toggle the chance to crave something sweet. (Default: true)").define("Sweet Craving Toggle", true);
            this.CFG_healthy_craving_toggle = builder.comment("Toggle the chance to crave something healthy. (Default: true)").define("Healthy Craving Toggle", true);
            this.CFG_meaty_craving_toggle = builder.comment("Toggle the chance to crave something meaty. (Default: true)").define("Meaty Craving Toggle", true);
            this.CFG_fishy_craving_toggle = builder.comment("Toggle the chance to crave something fishy. (Default: true)").define("Fishy Craving Toggle", true);
            this.CFG_gross_craving_toggle = builder.comment("Toggle the chance to crave something gross. (Default: true)").define("Gross Craving Toggle", true);
            this.CFG_fancy_craving_toggle = builder.comment("Toggle the chance to crave something fancy. (Default: true)").define("Fancy Craving Toggle", true);
            this.CFG_hearty_craving_toggle = builder.comment("Toggle the chance to crave something hearty. (Default: true)").define("Hearty Craving Toggle", true);
            this.CFG_raw_craving_toggle = builder.comment("Toggle the chance to crave something raw. (Default: true)").define("Raw Craving Toggle", true);
            builder.pop();
            builder.push("Miscellaneous Settings");
            this.CFG_craving_set_interval = builder.comment("How long will it take to crave something different. (Default: 12000)").comment("If you change this, make sure to tweak the effect's durations below to keep it balanced.").comment("Changing the effects to last half of this is a good starting point.").defineInRange("Time Between Cravings", 12000, 1, Integer.MAX_VALUE);
            this.CFG_particles_toggle = builder.comment("Enable potion effect particles for benefits gained by satisfying cravings. (default: false)").comment("If true, ambient particles will be used, which are less intrusive and less visible.").define("Toggle Effect Particles", false);
            this.CFG_craving_timers = builder.comment("Toggles whether craving reminder effects display a countdown timer").comment("When disabled, all cravings will show as \u201cInfinite,\u201d hiding the time left until the next craving. (default: true)").define("Craving Timer Display", true);
            builder.pop();
            builder.comment("Craving Weights. These determine the chances of each craving triggering compared to each other.").comment("Weights are used instead of straight up chances. The higher the weight in comparison with the others, the higher the chance.").comment("Example: If Sweet = 40 and Healthy = 20, then Sweet has double the chance of being picked than healthy.").push("Craving Weights");
            this.CFG_sweet_craving_weight = builder.comment("Chance to crave something sweet. (Default: 20)").defineInRange("Sweet Craving Chance", 20, 1, 1000);
            this.CFG_healthy_craving_weight = builder.comment("Chance to crave something healthy. (Default: 20)").defineInRange("Healthy Craving Chance", 20, 1, 1000);
            this.CFG_meaty_craving_weight = builder.comment("Chance to crave something meaty. (Default: 20)").defineInRange("Meaty Craving Chance", 20, 1, 1000);
            this.CFG_fishy_craving_weight = builder.comment("Chance to crave something fishy. (Default: 17)").defineInRange("Fishy Craving Chance", 17, 1, 1000);
            this.CFG_gross_craving_weight = builder.comment("Chance to crave something gross. (Default: 17)").defineInRange("Gross Craving Chance", 17, 1, 1000);
            this.CFG_fancy_craving_weight = builder.comment("Chance to crave something fancy. (Default: 14)").defineInRange("Fancy Craving Chance", 14, 1, 1000);
            this.CFG_hearty_craving_weight = builder.comment("Chance to crave something hearty. (Default: 14)").defineInRange("Hearty Craving Chance", 14, 1, 1000);
            this.CFG_raw_craving_weight = builder.comment("Chance to crave something raw. (Default: 5)").defineInRange("Raw Craving Chance", 5, 1, 1000);
            builder.pop();
            builder.push("Streak Settings");
            this.CFG_streak_amount = builder.comment("Number of consecutive cravings that must be satisfied to trigger a streak bonus. (default = 5)").defineInRange("Streak Amount", 5, 1, Integer.MAX_VALUE);
            this.CFG_bonus_xp = builder.comment("Extra experience points granted on top of the base reward when a streak bonus is triggered. (default = 5)").defineInRange("Bonus XP", 5, 0, Integer.MAX_VALUE);
            this.CFG_bonus_saturation = builder.comment("Extra saturation granted on top of the base reward when a streak bonus is triggered. (default = 3)").defineInRange("Bonus Saturation", 3.0, 0.0, 20.0);
            this.CFG_bonus_level = builder.comment("Additional effect amplifier levels added to the reward effect during a streak bonus. (default = 0)").defineInRange("Bonus Level", 0, 0, 255);
            this.CFG_bonus_duration = builder.comment("Extra duration (in ticks) added to the reward effect during a streak bonus. (default = 2400)").defineInRange("Bonus Duration", 2400, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.push("Palate Cleanser Settings");
            this.CFG_upset_stomach_toggle = builder.comment("Toggles whether drinking a Palate Cleanser applies the Upset Stomach effect as a cooldown.").comment("Disable to allow continuous use of the potion without any delay. (Default: true)").define("Upset Stomach Effect Toggle", true);
            this.CFG_upset_stomach_duration = builder.comment("Sets the duration (in ticks) of the Upset Stomach cooldown applied after drinking a Palate Cleanser. (default = 3000)").defineInRange("Upset Stomach Duration", 3000, 0, Integer.MAX_VALUE);
            builder.pop();
        }
    }
}

