/*
 * Decompiled with CFR 0.152.
 */
package net.dyrohc.cravings;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(modid="cravings", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ConfigFileVisuals {
    public static final ForgeConfigSpec SERVER_CONFIG;
    public static final Server SERVER;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading event) {
        if (event.getConfig().getType() == ModConfig.Type.SERVER) {
            ConfigFileVisuals.apply();
        }
    }

    @SubscribeEvent
    public static void onReloading(ModConfigEvent.Reloading event) {
        if (event.getConfig().getType() == ModConfig.Type.SERVER) {
            ConfigFileVisuals.apply();
        }
    }

    public static void apply() {
    }

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        SERVER = new Server(builder);
        SERVER_CONFIG = builder.build();
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)SERVER_CONFIG, "Cravings/cravings-visuals.toml");
    }

    public static class Server {
        public final ForgeConfigSpec.BooleanValue CFG_chat_reminder_toggle;
        public final ForgeConfigSpec.BooleanValue CFG_effect_reminder_toggle;
        public final ForgeConfigSpec.ConfigValue<String> CFG_satisfy_animation_toggle;

        Server(ForgeConfigSpec.Builder builder) {
            builder.push("Visual toggles");
            this.CFG_chat_reminder_toggle = builder.comment("Toggle a small custom icon that appears at the top center of the screen when the chat is open.").comment("Meant to remind you of your current craving. (Default: true)").define("Chat Craving Reminder", true);
            this.CFG_effect_reminder_toggle = builder.comment("Toggle a visual potion effect icon that appears as a reminder of your current craving.").comment("This effect has no gameplay impact and disappears once the craving is satisfied or changed. (Default: true)").define("Effect Craving Reminder", true);
            this.CFG_satisfy_animation_toggle = builder.comment("Choose the totem-like animation shown when you satisfy a craving.").comment("Full: Displays the entire craving sprite, which looks great but may feel large.").comment("Minimal: Shows only the effect icon for a more subtle animation.").comment("Allowed Values: Full, Minimal, Disabled. If the value is invalid, no animation will show, careful with that.").define("Satisfy Craving Animation", (Object)"Full");
            builder.pop();
        }
    }
}

