/*
 * Decompiled with CFR 0.152.
 */
package net.dyrohc.cravings;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ConfigFileServer {
    public static final ForgeConfigSpec SERVER_CONFIG;
    public static ForgeConfigSpec.BooleanValue CFG_sweet_craving_toggle;
    public static ForgeConfigSpec.BooleanValue CFG_healthy_craving_toggle;
    public static ForgeConfigSpec.BooleanValue CFG_meaty_craving_toggle;
    public static ForgeConfigSpec.BooleanValue CFG_fishy_craving_toggle;
    public static ForgeConfigSpec.BooleanValue CFG_gross_craving_toggle;
    public static ForgeConfigSpec.BooleanValue CFG_fancy_craving_toggle;
    public static ForgeConfigSpec.BooleanValue CFG_hearty_craving_toggle;
    public static ForgeConfigSpec.BooleanValue CFG_raw_craving_toggle;
    public static ForgeConfigSpec.IntValue CFG_craving_set_interval;
    public static ForgeConfigSpec.BooleanValue CFG_particles_toggle;
    public static ForgeConfigSpec.BooleanValue CFG_craving_timers;
    public static ForgeConfigSpec.IntValue CFG_sweet_craving_weight;
    public static ForgeConfigSpec.IntValue CFG_healthy_craving_weight;
    public static ForgeConfigSpec.IntValue CFG_meaty_craving_weight;
    public static ForgeConfigSpec.IntValue CFG_fishy_craving_weight;
    public static ForgeConfigSpec.IntValue CFG_gross_craving_weight;
    public static ForgeConfigSpec.IntValue CFG_fancy_craving_weight;
    public static ForgeConfigSpec.IntValue CFG_hearty_craving_weight;
    public static ForgeConfigSpec.IntValue CFG_raw_craving_weight;
    public static ForgeConfigSpec.IntValue CFG_streak_amount;
    public static ForgeConfigSpec.IntValue CFG_bonus_xp;
    public static ForgeConfigSpec.DoubleValue CFG_bonus_saturation;
    public static ForgeConfigSpec.IntValue CFG_bonus_level;
    public static ForgeConfigSpec.IntValue CFG_bonus_duration;
    public static ForgeConfigSpec.BooleanValue CFG_upset_stomach_toggle;
    public static ForgeConfigSpec.IntValue CFG_upset_stomach_duration;

    static {
        ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
        BUILDER.comment("I recommend an app to make TOML files prettier, this looks messy when using notepad.").comment("Disable or enable the different cravings.").push("Craving Toggles");
        CFG_sweet_craving_toggle = BUILDER.comment("Toggle the chance to crave something sweet. (Default: true)").define("Sweet Craving Toggle", true);
        CFG_healthy_craving_toggle = BUILDER.comment("Toggle the chance to crave something healthy. (Default: true)").define("Healthy Craving Toggle", true);
        CFG_meaty_craving_toggle = BUILDER.comment("Toggle the chance to crave something meaty. (Default: true)").define("Meaty Craving Toggle", true);
        CFG_fishy_craving_toggle = BUILDER.comment("Toggle the chance to crave something fishy. (Default: true)").define("Fishy Craving Toggle", true);
        CFG_gross_craving_toggle = BUILDER.comment("Toggle the chance to crave something gross. (Default: true)").define("Gross Craving Toggle", true);
        CFG_fancy_craving_toggle = BUILDER.comment("Toggle the chance to crave something fancy. (Default: true)").define("Fancy Craving Toggle", true);
        CFG_hearty_craving_toggle = BUILDER.comment("Toggle the chance to crave something hearty. (Default: true)").define("Hearty Craving Toggle", true);
        CFG_raw_craving_toggle = BUILDER.comment("Toggle the chance to crave something raw. (Default: true)").define("Raw Craving Toggle", true);
        BUILDER.pop();
        BUILDER.comment("Miscellaneous settings about different aspects of the mod.").push("Miscellaneous Settings");
        CFG_craving_set_interval = BUILDER.comment("How long will it take to crave something different. (Default: 12000)").comment("If you change this, make sure to tweak the effect's durations below to keep it balanced.").comment("Changing the effects to last half of this is a good starting point.").defineInRange("Time Between Cravings", 12000, 1, Integer.MAX_VALUE);
        CFG_particles_toggle = BUILDER.comment("Enable potion effect particles for benefits gained by satisfying cravings. (default: false)").comment("If true, ambient particles will be used, which are less intrusive and less visible.").define("Toggle Effect Particles", false);
        CFG_craving_timers = BUILDER.comment("Toggles whether craving reminder effects display a countdown timer").comment("When disabled, all cravings will show as \u201cInfinite,\u201d hiding the time left until the next craving. (default: true)").define("Craving Timer Display", true);
        BUILDER.pop();
        BUILDER.comment("Craving Weights. These determine the chances of each craving triggering compared to each other.").comment("Weights are used instead of straight up chances. The higher the weight in comparison with the others, the higher the chance.").comment("Example: If Sweet = 40 and Healthy = 20, then Sweet has double the chance of being picked than healthy.").push("Craving Weights");
        CFG_sweet_craving_weight = BUILDER.comment("Chance to crave something sweet. (Default: 20)").defineInRange("Sweet Craving Chance", 20, 1, 1000);
        CFG_healthy_craving_weight = BUILDER.comment("Chance to crave something healthy. (Default: 20)").defineInRange("Healthy Craving Chance", 20, 1, 1000);
        CFG_meaty_craving_weight = BUILDER.comment("Chance to crave something meaty. (Default: 20)").defineInRange("Meaty Craving Chance", 20, 1, 1000);
        CFG_fishy_craving_weight = BUILDER.comment("Chance to crave something fishy. (Default: 17)").defineInRange("Fishy Craving Chance", 17, 1, 1000);
        CFG_gross_craving_weight = BUILDER.comment("Chance to crave something gross. (Default: 17)").defineInRange("Gross Craving Chance", 17, 1, 1000);
        CFG_fancy_craving_weight = BUILDER.comment("Chance to crave something fancy. (Default: 14)").defineInRange("Fancy Craving Chance", 14, 1, 1000);
        CFG_hearty_craving_weight = BUILDER.comment("Chance to crave something hearty. (Default: 14)").defineInRange("Hearty Craving Chance", 14, 1, 1000);
        CFG_raw_craving_weight = BUILDER.comment("Chance to crave something raw. (Default: 5)").defineInRange("Raw Craving Chance", 5, 1, 1000);
        BUILDER.pop();
        BUILDER.comment("Settings related to the craving streaks gamerule.").push("Streak settings");
        CFG_streak_amount = BUILDER.comment("Number of consecutive cravings that must be satisfied to trigger a streak bonus. (default = 5)").defineInRange("Streak Amount", 5, 1, Integer.MAX_VALUE);
        CFG_bonus_xp = BUILDER.comment("Extra experience points granted on top of the base reward when a streak bonus is triggered. (default = 5)").defineInRange("Bonus XP", 5, 0, Integer.MAX_VALUE);
        CFG_bonus_saturation = BUILDER.comment("Extra saturation granted on top of the base reward when a streak bonus is triggered. (default = 3)").defineInRange("Bonus Saturation", 3.0, 0.0, 20.0);
        CFG_bonus_level = BUILDER.comment("Additional effect amplifier levels added to the reward effect during a streak bonus. (default = 0)").defineInRange("Bonus Level", 0, 0, 255);
        CFG_bonus_duration = BUILDER.comment("Extra duration (in ticks) added to the reward effect during a streak bonus. (default = 2400)").defineInRange("Bonus Duration", 2400, 0, Integer.MAX_VALUE);
        BUILDER.pop();
        BUILDER.comment("Settings related to the Palate Cleanser option, mostly it's Upset Stomach cooldown.").push("Palate Cleanser settings");
        CFG_upset_stomach_toggle = BUILDER.comment("Toggles whether drinking a Palate Cleanser applies the Upset Stomach effect as a cooldown.").comment("Disable to allow continuous use of the potion without any delay. (Default: true)").define("Upset Stomach Effect Toggle", true);
        CFG_upset_stomach_duration = BUILDER.comment("Sets the duration (in ticks) of the Upset Stomach cooldown applied after drinking a Palate Cleanser. (default = 3000)").defineInRange("Upset Stomach Duration", 3000, 0, Integer.MAX_VALUE);
        SERVER_CONFIG = BUILDER.build();
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)SERVER_CONFIG, "Cravings/cravings-main.toml");
    }
}

