/*
 * Decompiled with CFR 0.152.
 */
package net.dyrohc.cravings.network;

import java.util.function.Supplier;
import net.dyrohc.cravings.CravingsMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class CravingsModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        CravingsMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        CravingsMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class SavedDataSyncMessage {
        private final int type;
        private SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag nbt = buffer.m_130260_();
            if (nbt != null) {
                this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
                SavedData savedData = this.data;
                if (savedData instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)savedData;
                    mapVariables.read(nbt);
                } else {
                    savedData = this.data;
                    if (savedData instanceof WorldVariables) {
                        WorldVariables worldVariables = (WorldVariables)savedData;
                        worldVariables.read(nbt);
                    }
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            if (message.data != null) {
                buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
            }
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElseGet(PlayerVariables::new);
                    variables.chat_reminder_toggle = message.data.chat_reminder_toggle;
                    variables.craving_decider_random = message.data.craving_decider_random;
                    variables.craving_elapsed_ticks = message.data.craving_elapsed_ticks;
                    variables.cravings_done = message.data.cravings_done;
                    variables.cravings_in_a_row = message.data.cravings_in_a_row;
                    variables.current_craving = message.data.current_craving;
                    variables.current_craving_weight = message.data.current_craving_weight;
                    variables.deciding_craving = message.data.deciding_craving;
                    variables.effect_reminder_toggle = message.data.effect_reminder_toggle;
                    variables.fancy_done = message.data.fancy_done;
                    variables.Fancy_inarow = message.data.Fancy_inarow;
                    variables.fishy_adv = message.data.fishy_adv;
                    variables.fishy_done = message.data.fishy_done;
                    variables.gross_done = message.data.gross_done;
                    variables.healthy_done = message.data.healthy_done;
                    variables.hearty_done = message.data.hearty_done;
                    variables.meaty_done = message.data.meaty_done;
                    variables.NoSelfControl_unlockable = message.data.NoSelfControl_unlockable;
                    variables.previous_craving = message.data.previous_craving;
                    variables.raw_done = message.data.raw_done;
                    variables.Raw_satisifes = message.data.Raw_satisifes;
                    variables.reapply_timer = message.data.reapply_timer;
                    variables.satisfy_animation_toggle = message.data.satisfy_animation_toggle;
                    variables.sweet_done = message.data.sweet_done;
                    variables.usedItemID = message.data.usedItemID;
                    variables.variable_satisfied = message.data.variable_satisfied;
                    variables.palate_cleansing = message.data.palate_cleansing;
                    variables.upset_stomach_active = message.data.upset_stomach_active;
                    variables.upset_stomach_current = message.data.upset_stomach_current;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public boolean chat_reminder_toggle = false;
        public double craving_decider_random = 0.0;
        public double craving_elapsed_ticks = 0.0;
        public double cravings_done = 0.0;
        public double cravings_in_a_row = 0.0;
        public String current_craving = "None";
        public double current_craving_weight = 0.0;
        public boolean deciding_craving = false;
        public boolean effect_reminder_toggle = false;
        public boolean fancy_done = false;
        public double Fancy_inarow = 0.0;
        public boolean fishy_adv = false;
        public boolean fishy_done = false;
        public boolean gross_done = false;
        public boolean healthy_done = false;
        public boolean hearty_done = false;
        public boolean meaty_done = false;
        public boolean NoSelfControl_unlockable = false;
        public String previous_craving = "\"\"";
        public boolean raw_done = false;
        public double Raw_satisifes = 0.0;
        public double reapply_timer = 0.0;
        public String satisfy_animation_toggle = "\"Minimal\"";
        public boolean sweet_done = false;
        public String usedItemID = "\"None\"";
        public boolean variable_satisfied = false;
        public boolean palate_cleansing = false;
        public boolean upset_stomach_active = false;
        public double upset_stomach_current = 0.0;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                CravingsMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128379_("chat_reminder_toggle", this.chat_reminder_toggle);
            nbt.m_128347_("craving_decider_random", this.craving_decider_random);
            nbt.m_128347_("craving_elapsed_ticks", this.craving_elapsed_ticks);
            nbt.m_128347_("cravings_done", this.cravings_done);
            nbt.m_128347_("cravings_in_a_row", this.cravings_in_a_row);
            nbt.m_128359_("current_craving", this.current_craving);
            nbt.m_128347_("current_craving_weight", this.current_craving_weight);
            nbt.m_128379_("deciding_craving", this.deciding_craving);
            nbt.m_128379_("effect_reminder_toggle", this.effect_reminder_toggle);
            nbt.m_128379_("fancy_done", this.fancy_done);
            nbt.m_128347_("Fancy_inarow", this.Fancy_inarow);
            nbt.m_128379_("fishy_adv", this.fishy_adv);
            nbt.m_128379_("fishy_done", this.fishy_done);
            nbt.m_128379_("gross_done", this.gross_done);
            nbt.m_128379_("healthy_done", this.healthy_done);
            nbt.m_128379_("hearty_done", this.hearty_done);
            nbt.m_128379_("meaty_done", this.meaty_done);
            nbt.m_128379_("NoSelfControl_unlockable", this.NoSelfControl_unlockable);
            nbt.m_128359_("previous_craving", this.previous_craving);
            nbt.m_128379_("raw_done", this.raw_done);
            nbt.m_128347_("Raw_satisifes", this.Raw_satisifes);
            nbt.m_128347_("reapply_timer", this.reapply_timer);
            nbt.m_128359_("satisfy_animation_toggle", this.satisfy_animation_toggle);
            nbt.m_128379_("sweet_done", this.sweet_done);
            nbt.m_128359_("usedItemID", this.usedItemID);
            nbt.m_128379_("variable_satisfied", this.variable_satisfied);
            nbt.m_128379_("palate_cleansing", this.palate_cleansing);
            nbt.m_128379_("upset_stomach_active", this.upset_stomach_active);
            nbt.m_128347_("upset_stomach_current", this.upset_stomach_current);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.chat_reminder_toggle = nbt.m_128471_("chat_reminder_toggle");
            this.craving_decider_random = nbt.m_128459_("craving_decider_random");
            this.craving_elapsed_ticks = nbt.m_128459_("craving_elapsed_ticks");
            this.cravings_done = nbt.m_128459_("cravings_done");
            this.cravings_in_a_row = nbt.m_128459_("cravings_in_a_row");
            this.current_craving = nbt.m_128461_("current_craving");
            this.current_craving_weight = nbt.m_128459_("current_craving_weight");
            this.deciding_craving = nbt.m_128471_("deciding_craving");
            this.effect_reminder_toggle = nbt.m_128471_("effect_reminder_toggle");
            this.fancy_done = nbt.m_128471_("fancy_done");
            this.Fancy_inarow = nbt.m_128459_("Fancy_inarow");
            this.fishy_adv = nbt.m_128471_("fishy_adv");
            this.fishy_done = nbt.m_128471_("fishy_done");
            this.gross_done = nbt.m_128471_("gross_done");
            this.healthy_done = nbt.m_128471_("healthy_done");
            this.hearty_done = nbt.m_128471_("hearty_done");
            this.meaty_done = nbt.m_128471_("meaty_done");
            this.NoSelfControl_unlockable = nbt.m_128471_("NoSelfControl_unlockable");
            this.previous_craving = nbt.m_128461_("previous_craving");
            this.raw_done = nbt.m_128471_("raw_done");
            this.Raw_satisifes = nbt.m_128459_("Raw_satisifes");
            this.reapply_timer = nbt.m_128459_("reapply_timer");
            this.satisfy_animation_toggle = nbt.m_128461_("satisfy_animation_toggle");
            this.sweet_done = nbt.m_128471_("sweet_done");
            this.usedItemID = nbt.m_128461_("usedItemID");
            this.variable_satisfied = nbt.m_128471_("variable_satisfied");
            this.palate_cleansing = nbt.m_128471_("palate_cleansing");
            this.upset_stomach_active = nbt.m_128471_("upset_stomach_active");
            this.upset_stomach_current = nbt.m_128459_("upset_stomach_current");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(ResourceLocation.fromNamespaceAndPath((String)"cravings", (String)"player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "cravings_mapvars";
        public double blindness_duration = 0.0;
        public double craving_set_interval = 12000.0;
        public double enabled_cravings_total_weight = 0.0;
        public boolean fancy_craving_toggle = true;
        public double fancy_craving_weight = 0.0;
        public double fancy_nvision_duration = 0.0;
        public double fancy_saturation_amount = 0.0;
        public double fancy_xp_amount = 0.0;
        public boolean FD_toggle = false;
        public boolean fishy_craving_toggle = true;
        public double fishy_craving_weight = 0.0;
        public double fishy_saturation_amount = 0.0;
        public double fishy_wbreathing_duration = 0.0;
        public double fishy_xp_amount = 0.0;
        public boolean gross_craving_toggle = true;
        public double gross_craving_weight = 0.0;
        public double gross_resistance_duration = 0.0;
        public double gross_resistance_level = 0.0;
        public double gross_saturation_amount = 0.0;
        public double gross_xp_amount = 0.0;
        public boolean healthy_craving_toggle = true;
        public double healthy_craving_weight = 0.0;
        public double healthy_haste_duration = 0.0;
        public double healthy_haste_level = 0.0;
        public double healthy_saturation_amount = 0.0;
        public double healthy_xp_amount = 0.0;
        public boolean hearty_craving_toggle = true;
        public double hearty_craving_weight = 0.0;
        public double hearty_hboost_duration = 0.0;
        public double hearty_hboost_level = 0.0;
        public double hearty_saturation_amount = 0.0;
        public double hearty_xp_amount = 0.0;
        public double hunger_duration = 0.0;
        public double hunger_hearty_duration = 0.0;
        public double hunger_hearty_level = 0.0;
        public double hunger_level = 0.0;
        public double luck_duration = 0.0;
        public double luck_level = 0.0;
        public boolean meaty_craving_toggle = true;
        public double meaty_craving_weight = 0.0;
        public double meaty_saturation_amount = 0.0;
        public double meaty_strength_duration = 0.0;
        public double meaty_strength_level = 0.0;
        public double meaty_xp_amount = 0.0;
        public double mining_fatigue_duration = 0.0;
        public double mining_fatigue_level = 0.0;
        public double nausea_duration = 0.0;
        public boolean particles_toggle = true;
        public boolean raw_craving_toggle = true;
        public double raw_craving_weight = 0.0;
        public double raw_nausea_duration = 0.0;
        public double raw_saturation_amount = 0.0;
        public double raw_xp_amount = 0.0;
        public double saturation_loss = 0.0;
        public double slowness_duration = 0.0;
        public double slowness_level = 0.0;
        public boolean sweet_craving_toggle = true;
        public double sweet_craving_weight = 0.0;
        public double sweet_saturation_amount = 0.0;
        public double sweet_speed_duration = 0.0;
        public double sweet_speed_level = 0.0;
        public double sweet_xp_amount = 0.0;
        public double weakness_duration = 0.0;
        public double weakness_level = 0.0;
        public double streak_amount = 0.0;
        public double bonus_xp = 0.0;
        public double bonus_saturation = 0.0;
        public double bonus_level = 0.0;
        public double bonus_duration = 0.0;
        public boolean upset_stomach_toggle = true;
        public double upset_stomach_duration = 3000.0;
        public boolean craving_timers = true;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.blindness_duration = nbt.m_128459_("blindness_duration");
            this.craving_set_interval = nbt.m_128459_("craving_set_interval");
            this.enabled_cravings_total_weight = nbt.m_128459_("enabled_cravings_total_weight");
            this.fancy_craving_toggle = nbt.m_128471_("fancy_craving_toggle");
            this.fancy_craving_weight = nbt.m_128459_("fancy_craving_weight");
            this.fancy_nvision_duration = nbt.m_128459_("fancy_nvision_duration");
            this.fancy_saturation_amount = nbt.m_128459_("fancy_saturation_amount");
            this.fancy_xp_amount = nbt.m_128459_("fancy_xp_amount");
            this.FD_toggle = nbt.m_128471_("FD_toggle");
            this.fishy_craving_toggle = nbt.m_128471_("fishy_craving_toggle");
            this.fishy_craving_weight = nbt.m_128459_("fishy_craving_weight");
            this.fishy_saturation_amount = nbt.m_128459_("fishy_saturation_amount");
            this.fishy_wbreathing_duration = nbt.m_128459_("fishy_wbreathing_duration");
            this.fishy_xp_amount = nbt.m_128459_("fishy_xp_amount");
            this.gross_craving_toggle = nbt.m_128471_("gross_craving_toggle");
            this.gross_craving_weight = nbt.m_128459_("gross_craving_weight");
            this.gross_resistance_duration = nbt.m_128459_("gross_resistance_duration");
            this.gross_resistance_level = nbt.m_128459_("gross_resistance_level");
            this.gross_saturation_amount = nbt.m_128459_("gross_saturation_amount");
            this.gross_xp_amount = nbt.m_128459_("gross_xp_amount");
            this.healthy_craving_toggle = nbt.m_128471_("healthy_craving_toggle");
            this.healthy_craving_weight = nbt.m_128459_("healthy_craving_weight");
            this.healthy_haste_duration = nbt.m_128459_("healthy_haste_duration");
            this.healthy_haste_level = nbt.m_128459_("healthy_haste_level");
            this.healthy_saturation_amount = nbt.m_128459_("healthy_saturation_amount");
            this.healthy_xp_amount = nbt.m_128459_("healthy_xp_amount");
            this.hearty_craving_toggle = nbt.m_128471_("hearty_craving_toggle");
            this.hearty_craving_weight = nbt.m_128459_("hearty_craving_weight");
            this.hearty_hboost_duration = nbt.m_128459_("hearty_hboost_duration");
            this.hearty_hboost_level = nbt.m_128459_("hearty_hboost_level");
            this.hearty_saturation_amount = nbt.m_128459_("hearty_saturation_amount");
            this.hearty_xp_amount = nbt.m_128459_("hearty_xp_amount");
            this.hunger_duration = nbt.m_128459_("hunger_duration");
            this.hunger_hearty_duration = nbt.m_128459_("hunger_hearty_duration");
            this.hunger_hearty_level = nbt.m_128459_("hunger_hearty_level");
            this.hunger_level = nbt.m_128459_("hunger_level");
            this.luck_duration = nbt.m_128459_("luck_duration");
            this.luck_level = nbt.m_128459_("luck_level");
            this.meaty_craving_toggle = nbt.m_128471_("meaty_craving_toggle");
            this.meaty_craving_weight = nbt.m_128459_("meaty_craving_weight");
            this.meaty_saturation_amount = nbt.m_128459_("meaty_saturation_amount");
            this.meaty_strength_duration = nbt.m_128459_("meaty_strength_duration");
            this.meaty_strength_level = nbt.m_128459_("meaty_strength_level");
            this.meaty_xp_amount = nbt.m_128459_("meaty_xp_amount");
            this.mining_fatigue_duration = nbt.m_128459_("mining_fatigue_duration");
            this.mining_fatigue_level = nbt.m_128459_("mining_fatigue_level");
            this.nausea_duration = nbt.m_128459_("nausea_duration");
            this.particles_toggle = nbt.m_128471_("particles_toggle");
            this.raw_craving_toggle = nbt.m_128471_("raw_craving_toggle");
            this.raw_craving_weight = nbt.m_128459_("raw_craving_weight");
            this.raw_nausea_duration = nbt.m_128459_("raw_nausea_duration");
            this.raw_saturation_amount = nbt.m_128459_("raw_saturation_amount");
            this.raw_xp_amount = nbt.m_128459_("raw_xp_amount");
            this.saturation_loss = nbt.m_128459_("saturation_loss");
            this.slowness_duration = nbt.m_128459_("slowness_duration");
            this.slowness_level = nbt.m_128459_("slowness_level");
            this.sweet_craving_toggle = nbt.m_128471_("sweet_craving_toggle");
            this.sweet_craving_weight = nbt.m_128459_("sweet_craving_weight");
            this.sweet_saturation_amount = nbt.m_128459_("sweet_saturation_amount");
            this.sweet_speed_duration = nbt.m_128459_("sweet_speed_duration");
            this.sweet_speed_level = nbt.m_128459_("sweet_speed_level");
            this.sweet_xp_amount = nbt.m_128459_("sweet_xp_amount");
            this.weakness_duration = nbt.m_128459_("weakness_duration");
            this.weakness_level = nbt.m_128459_("weakness_level");
            this.streak_amount = nbt.m_128459_("streak_amount");
            this.bonus_xp = nbt.m_128459_("bonus_xp");
            this.bonus_saturation = nbt.m_128459_("bonus_saturation");
            this.bonus_level = nbt.m_128459_("bonus_level");
            this.bonus_duration = nbt.m_128459_("bonus_duration");
            this.upset_stomach_toggle = nbt.m_128471_("upset_stomach_toggle");
            this.upset_stomach_duration = nbt.m_128459_("upset_stomach_duration");
            this.craving_timers = nbt.m_128471_("craving_timers");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128347_("blindness_duration", this.blindness_duration);
            nbt.m_128347_("craving_set_interval", this.craving_set_interval);
            nbt.m_128347_("enabled_cravings_total_weight", this.enabled_cravings_total_weight);
            nbt.m_128379_("fancy_craving_toggle", this.fancy_craving_toggle);
            nbt.m_128347_("fancy_craving_weight", this.fancy_craving_weight);
            nbt.m_128347_("fancy_nvision_duration", this.fancy_nvision_duration);
            nbt.m_128347_("fancy_saturation_amount", this.fancy_saturation_amount);
            nbt.m_128347_("fancy_xp_amount", this.fancy_xp_amount);
            nbt.m_128379_("FD_toggle", this.FD_toggle);
            nbt.m_128379_("fishy_craving_toggle", this.fishy_craving_toggle);
            nbt.m_128347_("fishy_craving_weight", this.fishy_craving_weight);
            nbt.m_128347_("fishy_saturation_amount", this.fishy_saturation_amount);
            nbt.m_128347_("fishy_wbreathing_duration", this.fishy_wbreathing_duration);
            nbt.m_128347_("fishy_xp_amount", this.fishy_xp_amount);
            nbt.m_128379_("gross_craving_toggle", this.gross_craving_toggle);
            nbt.m_128347_("gross_craving_weight", this.gross_craving_weight);
            nbt.m_128347_("gross_resistance_duration", this.gross_resistance_duration);
            nbt.m_128347_("gross_resistance_level", this.gross_resistance_level);
            nbt.m_128347_("gross_saturation_amount", this.gross_saturation_amount);
            nbt.m_128347_("gross_xp_amount", this.gross_xp_amount);
            nbt.m_128379_("healthy_craving_toggle", this.healthy_craving_toggle);
            nbt.m_128347_("healthy_craving_weight", this.healthy_craving_weight);
            nbt.m_128347_("healthy_haste_duration", this.healthy_haste_duration);
            nbt.m_128347_("healthy_haste_level", this.healthy_haste_level);
            nbt.m_128347_("healthy_saturation_amount", this.healthy_saturation_amount);
            nbt.m_128347_("healthy_xp_amount", this.healthy_xp_amount);
            nbt.m_128379_("hearty_craving_toggle", this.hearty_craving_toggle);
            nbt.m_128347_("hearty_craving_weight", this.hearty_craving_weight);
            nbt.m_128347_("hearty_hboost_duration", this.hearty_hboost_duration);
            nbt.m_128347_("hearty_hboost_level", this.hearty_hboost_level);
            nbt.m_128347_("hearty_saturation_amount", this.hearty_saturation_amount);
            nbt.m_128347_("hearty_xp_amount", this.hearty_xp_amount);
            nbt.m_128347_("hunger_duration", this.hunger_duration);
            nbt.m_128347_("hunger_hearty_duration", this.hunger_hearty_duration);
            nbt.m_128347_("hunger_hearty_level", this.hunger_hearty_level);
            nbt.m_128347_("hunger_level", this.hunger_level);
            nbt.m_128347_("luck_duration", this.luck_duration);
            nbt.m_128347_("luck_level", this.luck_level);
            nbt.m_128379_("meaty_craving_toggle", this.meaty_craving_toggle);
            nbt.m_128347_("meaty_craving_weight", this.meaty_craving_weight);
            nbt.m_128347_("meaty_saturation_amount", this.meaty_saturation_amount);
            nbt.m_128347_("meaty_strength_duration", this.meaty_strength_duration);
            nbt.m_128347_("meaty_strength_level", this.meaty_strength_level);
            nbt.m_128347_("meaty_xp_amount", this.meaty_xp_amount);
            nbt.m_128347_("mining_fatigue_duration", this.mining_fatigue_duration);
            nbt.m_128347_("mining_fatigue_level", this.mining_fatigue_level);
            nbt.m_128347_("nausea_duration", this.nausea_duration);
            nbt.m_128379_("particles_toggle", this.particles_toggle);
            nbt.m_128379_("raw_craving_toggle", this.raw_craving_toggle);
            nbt.m_128347_("raw_craving_weight", this.raw_craving_weight);
            nbt.m_128347_("raw_nausea_duration", this.raw_nausea_duration);
            nbt.m_128347_("raw_saturation_amount", this.raw_saturation_amount);
            nbt.m_128347_("raw_xp_amount", this.raw_xp_amount);
            nbt.m_128347_("saturation_loss", this.saturation_loss);
            nbt.m_128347_("slowness_duration", this.slowness_duration);
            nbt.m_128347_("slowness_level", this.slowness_level);
            nbt.m_128379_("sweet_craving_toggle", this.sweet_craving_toggle);
            nbt.m_128347_("sweet_craving_weight", this.sweet_craving_weight);
            nbt.m_128347_("sweet_saturation_amount", this.sweet_saturation_amount);
            nbt.m_128347_("sweet_speed_duration", this.sweet_speed_duration);
            nbt.m_128347_("sweet_speed_level", this.sweet_speed_level);
            nbt.m_128347_("sweet_xp_amount", this.sweet_xp_amount);
            nbt.m_128347_("weakness_duration", this.weakness_duration);
            nbt.m_128347_("weakness_level", this.weakness_level);
            nbt.m_128347_("streak_amount", this.streak_amount);
            nbt.m_128347_("bonus_xp", this.bonus_xp);
            nbt.m_128347_("bonus_saturation", this.bonus_saturation);
            nbt.m_128347_("bonus_level", this.bonus_level);
            nbt.m_128347_("bonus_duration", this.bonus_duration);
            nbt.m_128379_("upset_stomach_toggle", this.upset_stomach_toggle);
            nbt.m_128347_("upset_stomach_duration", this.upset_stomach_duration);
            nbt.m_128379_("craving_timers", this.craving_timers);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                CravingsMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "cravings_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                CravingsMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElseGet(PlayerVariables::new)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElseGet(PlayerVariables::new)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElseGet(PlayerVariables::new)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElseGet(PlayerVariables::new);
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElseGet(PlayerVariables::new);
            clone.chat_reminder_toggle = original.chat_reminder_toggle;
            clone.craving_decider_random = original.craving_decider_random;
            clone.craving_elapsed_ticks = original.craving_elapsed_ticks;
            clone.cravings_done = original.cravings_done;
            clone.cravings_in_a_row = original.cravings_in_a_row;
            clone.current_craving = original.current_craving;
            clone.current_craving_weight = original.current_craving_weight;
            clone.deciding_craving = original.deciding_craving;
            clone.effect_reminder_toggle = original.effect_reminder_toggle;
            clone.fancy_done = original.fancy_done;
            clone.Fancy_inarow = original.Fancy_inarow;
            clone.fishy_adv = original.fishy_adv;
            clone.fishy_done = original.fishy_done;
            clone.gross_done = original.gross_done;
            clone.healthy_done = original.healthy_done;
            clone.hearty_done = original.hearty_done;
            clone.meaty_done = original.meaty_done;
            clone.NoSelfControl_unlockable = original.NoSelfControl_unlockable;
            clone.previous_craving = original.previous_craving;
            clone.raw_done = original.raw_done;
            clone.Raw_satisifes = original.Raw_satisifes;
            clone.reapply_timer = original.reapply_timer;
            clone.satisfy_animation_toggle = original.satisfy_animation_toggle;
            clone.sweet_done = original.sweet_done;
            clone.usedItemID = original.usedItemID;
            clone.variable_satisfied = original.variable_satisfied;
            clone.palate_cleansing = original.palate_cleansing;
            clone.upset_stomach_active = original.upset_stomach_active;
            clone.upset_stomach_current = original.upset_stomach_current;
            if (!event.isWasDeath()) {
                // empty if block
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().m_9236_());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_());
                if (mapdata != null) {
                    CravingsMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    CravingsMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().m_9236_().m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_())) != null) {
                CravingsMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

