/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.executableevents.events.world.custom;

import com.ssomar.executableevents.events.EventsManager;
import com.ssomar.executableevents.events.world.custom.FakeDayEvent;
import com.ssomar.executableevents.events.world.custom.FakeNightEvent;
import com.ssomar.executableevents.executableevents.activators.Option;
import com.ssomar.score.SCore;
import com.ssomar.score.sobject.sactivator.EventInfo;
import com.ssomar.score.sobject.sactivator.SOption;
import com.ssomar.score.utils.scheduler.ScheduledTask;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;

public class WorldCycleListener
implements Listener {
    public static List<ScheduledTask> run = new ArrayList<ScheduledTask>();

    public WorldCycleListener() {
        Iterator<ScheduledTask> iterator = run.iterator();
        while (iterator.hasNext()) {
            ScheduledTask task = iterator.next();
            task.cancel();
            iterator.remove();
        }
        for (World w : Bukkit.getWorlds()) {
            if (w == null || w.getEnvironment() == World.Environment.NETHER || w.getEnvironment() == World.Environment.THE_END) continue;
            boolean[] isDay = new boolean[]{w.getTime() < 12000L};
            Runnable r = () -> {
                long time = w.getTime();
                if (time >= 0L && time < 12000L && !isDay[0]) {
                    isDay[0] = true;
                    this.onDayStart(w);
                }
                if (time >= 12000L && time < 24000L && isDay[0]) {
                    isDay[0] = false;
                    this.onNightStart(w);
                }
            };
            ScheduledTask hook = SCore.schedulerHook.runRepeatingTask(r, 0L, 20L);
            run.add(hook);
        }
    }

    protected void onDayStart(World world) {
        EventInfo eInfo = new EventInfo((Event)new FakeDayEvent());
        eInfo.setWorld(Optional.of(world));
        eInfo.getPlaceholders().put("%world%", world.getName());
        eInfo.setOption((SOption)Option.WORLD_DAY);
        EventsManager.getInstance().activeOption(eInfo);
    }

    protected void onNightStart(World world) {
        EventInfo eInfo = new EventInfo((Event)new FakeNightEvent());
        eInfo.setWorld(Optional.of(world));
        eInfo.getPlaceholders().put("%world%", world.getName());
        eInfo.setOption((SOption)Option.WORLD_NIGHT);
        EventsManager.getInstance().activeOption(eInfo);
    }
}

