/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.executableevents.executableevents;

import com.ssomar.executableevents.ExecutableEvents;
import com.ssomar.executableevents.configs.GeneralConfig;
import com.ssomar.executableevents.configs.api.PlaceholderAPI;
import com.ssomar.executableevents.executableevents.ConfigConverter;
import com.ssomar.executableevents.executableevents.ExecutableEvent;
import com.ssomar.executableevents.executableevents.manager.ExecutableEventsManager;
import com.ssomar.executableevents.utils.ZipUtility;
import com.ssomar.score.events.loop.LoopManager;
import com.ssomar.score.sobject.SObjectWithFileLoader;
import com.ssomar.score.sobject.SObjectWithFileManager;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.logging.Utils;
import com.ssomar.score.utils.strings.StringConverter;
import java.io.File;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Optional;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;

public class ExecutableEventLoader
extends SObjectWithFileLoader<ExecutableEvent> {
    private static ExecutableEventLoader instance;
    private boolean createBackup = false;

    public ExecutableEventLoader() {
        super((SPlugin)ExecutableEvents.plugin, "/com/ssomar/executableevents/configs/events/", (SObjectWithFileManager)ExecutableEventsManager.getInstance(), ExecutableEvents.plugin.getMaxSObjectsLimit());
    }

    public static ExecutableEventLoader getInstance() {
        if (instance == null) {
            instance = new ExecutableEventLoader();
        }
        return instance;
    }

    public void load() {
        LoopManager.getInstance((Plugin)ExecutableEvents.plugin.getPlugin()).resetLoopActivators((SPlugin)ExecutableEvents.plugin);
        ExecutableEventsManager.getInstance().setDefaultObjects(new ArrayList());
        if (PlaceholderAPI.isLotOfWork()) {
            this.loadDefaultPremiumObjects();
        }
        ExecutableEventsManager.getInstance().setLoadedObjects(new ArrayList());
        this.resetCpt();
        File itemsDirectory = new File(ExecutableEvents.plugin.getPlugin().getDataFolder() + "/events");
        if (itemsDirectory.exists()) {
            if (this.createBackup && !GeneralConfig.getInstance().getBooleanSetting(GeneralConfig.Setting.disableBackup.name())) {
                ZipUtility zipUtility = new ZipUtility();
                try {
                    DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy_MM_dd-HH_mm_ss");
                    LocalDateTime now = LocalDateTime.now();
                    new File(ExecutableEvents.plugin.getPlugin().getDataFolder() + "/backups/" + dtf.format(now)).mkdirs();
                    zipUtility.zip(new String[]{itemsDirectory.getPath()}, ExecutableEvents.plugin.getPlugin().getDataFolder() + "/backups/" + dtf.format(now) + "/backup.zip");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.createBackup = false;
            }
            this.loadObjectsInFolder(itemsDirectory, !PlaceholderAPI.isLotOfWork());
            Utils.sendConsoleMsg((String)("&dExecutableEvents &7Amount of Executable Events configurations loaded: &e" + this.getCpt()));
        } else {
            itemsDirectory.mkdirs();
            this.createDefaultObjectsFile(!PlaceholderAPI.isLotOfWork());
            this.load();
        }
    }

    public void configVersionsConverter(File file) {
        ConfigConverter.updateTo(file);
    }

    public Optional<ExecutableEvent> getObject(FileConfiguration itemConfig, String id, boolean showError, boolean isPremiumLoading, String path) {
        ArrayList<String> errors = new ArrayList<String>();
        ExecutableEvent item = new ExecutableEvent(id, path);
        errors.addAll(item.load(ExecutableEvents.plugin, (ConfigurationSection)itemConfig, isPremiumLoading));
        if (showError) {
            for (String s : errors) {
                Utils.sendConsoleMsg((String)("&dExecutableEvents " + StringConverter.coloredString((String)s)));
            }
        }
        return Optional.ofNullable(item);
    }

    public boolean isCreateBackup() {
        return this.createBackup;
    }

    public void setCreateBackup(boolean createBackup) {
        this.createBackup = createBackup;
    }
}

