/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.executableevents.executableevents.manager;

import com.ssomar.executableevents.ExecutableEvents;
import com.ssomar.executableevents.events.optimize.OptimizedEventsHandler;
import com.ssomar.executableevents.executableevents.ExecutableEvent;
import com.ssomar.executableevents.executableevents.ExecutableEventLoader;
import com.ssomar.executableevents.executableevents.activators.ActivatorEEFeature;
import com.ssomar.score.features.custom.activators.activator.SActivator;
import com.ssomar.score.sobject.SObjectWithFileManager;
import com.ssomar.score.sobject.sactivator.SOption;
import com.ssomar.score.splugin.SPlugin;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class ExecutableEventsManager
extends SObjectWithFileManager<ExecutableEvent> {
    private static ExecutableEventsManager instance;

    public ExecutableEventsManager() {
        super((SPlugin)ExecutableEvents.plugin);
    }

    public static ExecutableEventsManager getInstance() {
        if (instance == null) {
            instance = new ExecutableEventsManager();
        }
        return instance;
    }

    public void actionOnObjectWhenLoading(ExecutableEvent newExecutableItem) {
        for (SActivator activator : newExecutableItem.getActivators().getActivators().values()) {
            SOption option = activator.getOption();
            if (!(activator instanceof ActivatorEEFeature)) continue;
            ActivatorEEFeature activatorEE = (ActivatorEEFeature)activator;
            OptimizedEventsHandler.getInstance().read(option);
        }
    }

    public void actionOnObjectWhenReloading(ExecutableEvent newExecutableItem) {
    }

    public Optional<ExecutableEvent> methodObjectLoading(String id) {
        return ExecutableEventLoader.getInstance().getObjectById(id, false);
    }

    public boolean isValidID(String id) {
        for (ExecutableEvent item : this.getLoadedObjects()) {
            if (!item.getId().equals(id)) continue;
            return true;
        }
        return false;
    }

    public Optional<ExecutableEvent> getExecutableEvent(String id) {
        for (ExecutableEvent item : this.getLoadedObjects()) {
            if (!item.getId().equals(id)) continue;
            return Optional.of(item);
        }
        return Optional.empty();
    }

    public List<String> getFoldersNames() {
        ArrayList<String> folders = new ArrayList<String>();
        for (ExecutableEvent item : this.getLoadedObjects()) {
            String path = item.getPath();
            path = path.replace("\\", "/");
            if (!(path = path.replace("plugins/ExecutableEvents/events/", "")).contains("/")) continue;
            String ymlPart = "";
            String[] parts = path.split("/");
            ymlPart = parts[parts.length - 1];
            if (folders.contains(path = path.replace("/" + ymlPart, ""))) continue;
            folders.add(path);
        }
        return folders;
    }

    public List<ExecutableEvent> getExecutableEventsOfFolder(String folder) {
        ArrayList<ExecutableEvent> executableItems = new ArrayList<ExecutableEvent>();
        for (ExecutableEvent item : this.getLoadedObjects()) {
            String path = item.getPath();
            path = path.replace("\\", "/");
            if (!(path = path.replace("plugins/ExecutableEvents/events/", "")).contains("/")) continue;
            String ymlPart = "";
            String[] parts = path.split("/");
            ymlPart = parts[parts.length - 1];
            if (!(path = path.replace("/" + ymlPart, "")).equalsIgnoreCase(folder)) continue;
            executableItems.add(item);
        }
        return executableItems;
    }

    public List<String> getExecutableEventIdsList() {
        ArrayList<String> list = new ArrayList<String>();
        for (ExecutableEvent item : this.getLoadedObjects()) {
            list.add(item.getId());
        }
        return list;
    }
}

