/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.executableevents.commands;

import com.ssomar.executableevents.ExecutableEvents;
import com.ssomar.executableevents.SExecutableEvents;
import com.ssomar.executableevents.commands.DebugMode;
import com.ssomar.executableevents.configs.api.PlaceholderAPI;
import com.ssomar.executableevents.editor.ExecutableEventsEditor;
import com.ssomar.executableevents.events.EventsManager;
import com.ssomar.executableevents.events.optimize.OptimizedEventsHandler;
import com.ssomar.executableevents.executableevents.ExecutableEvent;
import com.ssomar.executableevents.executableevents.ExecutableEventLoader;
import com.ssomar.executableevents.executableevents.manager.ExecutableEventsManager;
import com.ssomar.score.actionbar.ActionbarCommands;
import com.ssomar.score.commands.score.CommandsClassAbstract;
import com.ssomar.score.commands.score.PathCommand;
import com.ssomar.score.commands.score.clear.ClearCommand;
import com.ssomar.score.commands.score.clear.ClearType;
import com.ssomar.score.sobject.SObject;
import com.ssomar.score.sobject.SObjectManager;
import com.ssomar.score.sobject.menu.NewSObjectsManagerEditor;
import com.ssomar.score.sobject.menu.SObjectsEditorAbstract;
import com.ssomar.score.sobject.sactivator.EventInfo;
import com.ssomar.score.sobject.sactivator.OptionGlobal;
import com.ssomar.score.sobject.sactivator.SOption;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.logging.Utils;
import com.ssomar.score.utils.strings.StringConverter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class CommandsClass
extends CommandsClassAbstract<SExecutableEvents> {
    private PathCommand<SExecutableEvents, ExecutableEventsManager, ExecutableEvent> pathCommand;

    public CommandsClass(SExecutableEvents main) {
        super((SPlugin)main);
        this.addCommand("reload");
        this.addCommand("enable");
        this.addCommand("disable");
        this.addCommand("debug");
        this.addCommand("checkevents");
        this.addCommand("default_events");
        this.addCommand("create");
        this.addCommand("show");
        this.addCommand("editor");
        this.addCommand("edit");
        this.addCommand("clear");
        this.addCommand("actionbar");
        this.addCommand("delete");
        this.addCommand("run-custom-trigger");
        this.pathCommand = new PathCommand((SPlugin)((SExecutableEvents)this.getSPlugin()), (SObjectManager)ExecutableEventsManager.getInstance());
        this.addCommands(this.pathCommand.getCommands());
    }

    public void runCommand(CommandSender sender, @Nullable Player player, String command, String[] args, String typedCommand) {
        switch (command) {
            case "reload": {
                if (args.length < 1) {
                    ((SExecutableEvents)this.getSPlugin()).getPlugin().onReload(true);
                    this.getSm().sendMessage(sender, ((SExecutableEvents)this.getSPlugin()).getNameDesign() + " &7has been reloaded !");
                    Utils.sendConsoleMsg((String)(((SExecutableEvents)this.getSPlugin()).getNameDesign() + " &7Successfully reloaded !"));
                    break;
                }
                String idToReload = args[0];
                if (idToReload.contains("folder:")) {
                    String folderName = idToReload.replace("folder:", "");
                    if (ExecutableEventLoader.getInstance().reloadFolder(folderName)) {
                        this.getSm().sendMessage(sender, ((SExecutableEvents)this.getSPlugin()).getNameDesign() + " &7The folder &e" + folderName + " &7has been reloaded !");
                    } else {
                        this.getSm().sendMessage(sender, "&c" + ((SExecutableEvents)this.getSPlugin()).getNameWithBrackets() + " &cThe folder &6" + folderName + " &cdoes not exist !");
                    }
                } else {
                    if (ExecutableEventsManager.getInstance().isValidID(idToReload)) {
                        ExecutableEventsManager.getInstance().reloadObject(idToReload);
                        this.getSm().sendMessage(sender, ((SExecutableEvents)this.getSPlugin()).getNameDesign() + " &e" + idToReload + " &7has been reloaded !");
                        break;
                    }
                    this.getSm().sendMessage(sender, StringConverter.coloredString((String)("&c" + ((SExecutableEvents)this.getSPlugin()).getNameWithBrackets() + " &cThe ID &6" + idToReload + " &cspecified is not valid !")));
                    break;
                }
            }
            case "enable": 
            case "disable": {
                if (args.length < 1) {
                    this.getSm().sendMessage(sender, StringConverter.coloredString((String)(((SExecutableEvents)this.getSPlugin()).getNameDesign() + " &7To create enable or disable an event &e/ee enable/disable {eventId}")));
                    break;
                }
                String idToEnableOrDisable = args[0];
                ArrayList eventsToChange = new ArrayList();
                if (idToEnableOrDisable.contains("folder:")) {
                    String folderName = idToEnableOrDisable.replace("folder:", "");
                    eventsToChange.addAll(ExecutableEventLoader.getInstance().getAllLoadedObjectsOfFolder(folderName));
                } else {
                    ExecutableEventsManager.getInstance().getLoadedObjectWithID(idToEnableOrDisable).ifPresent(eventsToChange::add);
                }
                boolean enable = command.equals("enable");
                for (ExecutableEvent event : eventsToChange) {
                    event.getEnabled().setValue(enable);
                    if (enable) {
                        this.getSm().sendMessage(sender, ((SExecutableEvents)this.getSPlugin()).getNameDesign() + " &e" + event.getId() + " &7is now &eenabled !");
                        continue;
                    }
                    this.getSm().sendMessage(sender, ((SExecutableEvents)this.getSPlugin()).getNameDesign() + " &e" + event.getId() + " &7is now &cdisabled !");
                }
                break;
            }
            case "debug": {
                if (player != null) {
                    if (DebugMode.getInstance().getPlayersInDebugMode().contains(player)) {
                        DebugMode.getInstance().getPlayersInDebugMode().remove(player);
                        this.getSm().sendMessage(sender, ((SExecutableEvents)this.getSPlugin()).getNameDesign() + " &7debug mode &cdisabled &7!");
                        break;
                    }
                    DebugMode.getInstance().getPlayersInDebugMode().add(player);
                    this.getSm().sendMessage(sender, ((SExecutableEvents)this.getSPlugin()).getNameDesign() + " &7debug mode &aenabled &7!");
                    break;
                }
                if (DebugMode.getInstance().isEnabledInConsole()) {
                    DebugMode.getInstance().setEnabledInConsole(false);
                    this.getSm().sendMessage(sender, ((SExecutableEvents)this.getSPlugin()).getNameDesign() + " &7debug mode &cdisabled &7!");
                    break;
                }
                DebugMode.getInstance().setEnabledInConsole(true);
                this.getSm().sendMessage(sender, ((SExecutableEvents)this.getSPlugin()).getNameDesign() + " &7debug mode &aenabled &7!");
                break;
            }
            case "checkevents": {
                OptimizedEventsHandler.getInstance().displayOptimisation();
                this.getSm().sendMessage(sender, ((SExecutableEvents)this.getSPlugin()).getNameDesign() + " &7Check events sent in your console !");
                break;
            }
            case "default_events": {
                ExecutableEventLoader.getInstance().createDefaultObjectsFile(!PlaceholderAPI.isLotOfWork(), true);
                ((SExecutableEvents)this.getSPlugin()).getPlugin().onReload(true);
                this.getSm().sendMessage(sender, ((SExecutableEvents)this.getSPlugin()).getNameDesign() + " &7regenerates the default items, check them in the &e/ee show &7!");
                break;
            }
            case "create": {
                if (player == null) break;
                if (args.length == 1) {
                    if (ExecutableEventLoader.getInstance().getAllObjectsLowerCases().contains(args[0])) {
                        this.getSm().sendMessage(sender, "&c" + ((SExecutableEvents)this.getSPlugin()).getNameWithBrackets() + " &cError this id already exist re-enter &6/ee create ID &7(ID is the id you want for your new event)");
                        break;
                    }
                    if (ExecutableEventsManager.getInstance().getLoadedObjects().size() >= ExecutableEvents.plugin.getMaxSObjectsLimit() && PlaceholderAPI.isLotOfWork()) {
                        this.getSm().sendMessage(sender, "&c" + ((SExecutableEvents)this.getSPlugin()).getNameWithBrackets() + " &cREQUIRE PREMIUM: to add more than &6" + ExecutableEvents.plugin.getMaxSObjectsLimit() + " &7events you need the premium version");
                        return;
                    }
                    ExecutableEvent i = new ExecutableEvent(args[0], "plugins/ExecutableEvents/events/" + args[0] + ".yml");
                    i.save();
                    ExecutableEventsManager.getInstance().addLoadedObject((SObject)i);
                    i.openEditor(player);
                    break;
                }
                this.getSm().sendMessage(sender, StringConverter.coloredString((String)(((SExecutableEvents)this.getSPlugin()).getNameDesign() + " &7To create a new event you need to enter &e/ee create ID &7(ID is the id you want for your new event)")));
                break;
            }
            case "show": 
            case "editor": {
                if (player == null) break;
                NewSObjectsManagerEditor.getInstance().startEditing(player, (SObjectsEditorAbstract)new ExecutableEventsEditor());
                break;
            }
            case "edit": {
                if (player == null) break;
                if (args.length > 0) {
                    try {
                        Optional ei = ExecutableEventsManager.getInstance().getLoadedObjectWithID(args[0]);
                        if (ei.isPresent()) {
                            ((ExecutableEvent)((Object)ei.get())).openEditor(player);
                            break;
                        }
                        this.getSm().sendMessage(sender, StringConverter.coloredString((String)("&c" + ((SExecutableEvents)this.getSPlugin()).getNameWithBrackets() + " &cThis ExecutableEvent &6" + args[0] + " &cdoesn't exist")));
                    }
                    catch (NullPointerException e) {
                        this.getSm().sendMessage(sender, StringConverter.coloredString((String)("&c" + ((SExecutableEvents)this.getSPlugin()).getNameWithBrackets() + " &cError > Invalid EventID &6/ee edit {EventID}")));
                    }
                    break;
                }
                this.getSm().sendMessage(sender, StringConverter.coloredString((String)("&c" + ((SExecutableEvents)this.getSPlugin()).getNameWithBrackets() + " &cError > Invalid EventID &6/ee edit {EventID}")));
                break;
            }
            case "clear": {
                ClearCommand.clearCmd((SPlugin)ExecutableEvents.plugin, (CommandSender)sender, (String[])args);
                break;
            }
            case "actionbar": {
                if (sender instanceof Player) {
                    if (args.length == 1) {
                        ActionbarCommands.manageCommand((Player)((Player)sender), (String)args[0]);
                        break;
                    }
                    this.getSm().sendMessage(sender, StringConverter.coloredString((String)("&c" + ((SExecutableEvents)this.getSPlugin()).getNameWithBrackets() + " &6/ee actionbar on &cor &6/ee actionbar off")));
                    break;
                }
                this.getSm().sendMessage(sender, StringConverter.coloredString((String)("&c" + ((SExecutableEvents)this.getSPlugin()).getNameWithBrackets() + " &cThis is only an In-game command !")));
                break;
            }
            case "delete": {
                if (args.length == 2) {
                    if (!args[1].equalsIgnoreCase("confirm")) {
                        this.getSm().sendMessage(sender, StringConverter.coloredString((String)("&c" + ((SExecutableEvents)this.getSPlugin()).getNameWithBrackets() + " &cTo confirm the delete type &6/ee delete {eventID} confirm")));
                        return;
                    }
                    Optional eiOpt = ExecutableEventsManager.getInstance().getLoadedObjectWithID(args[0]);
                    if (eiOpt.isPresent()) {
                        ExecutableEventsManager.getInstance().deleteObject(args[0]);
                        this.getSm().sendMessage(sender, StringConverter.coloredString((String)(((SExecutableEvents)this.getSPlugin()).getNameDesign() + " &7Event &e" + args[0] + " &7deleted")));
                        if (player == null) break;
                        NewSObjectsManagerEditor.getInstance().startEditing(player, (SObjectsEditorAbstract)new ExecutableEventsEditor());
                        break;
                    }
                    this.getSm().sendMessage(sender, StringConverter.coloredString((String)("&c" + ((SExecutableEvents)this.getSPlugin()).getNameWithBrackets() + " &cEvent &6" + args[0] + " &cnot found")));
                    break;
                }
                this.getSm().sendMessage(sender, StringConverter.coloredString((String)("&c" + ((SExecutableEvents)this.getSPlugin()).getNameWithBrackets() + " &cTo confirm the delete type &6/ee delete {eventID} confirm")));
                break;
            }
            case "run-custom-trigger": {
                ArrayList<Object> trigger = new ArrayList<Object>();
                HashMap<String, String> otherArgs = new HashMap<String, String>();
                for (int i = 0; i < args.length; ++i) {
                    if (args[i].startsWith("trigger:")) {
                        Object triggerStr = args[i].replace("trigger:", "");
                        if (((String)triggerStr).startsWith("[") && ((String)triggerStr).endsWith("]")) {
                            String[] triggers;
                            triggerStr = ((String)triggerStr).replace("[", "");
                            triggerStr = ((String)triggerStr).replace("]", "");
                            for (String t : triggers = ((String)triggerStr).split(",")) {
                                trigger.add(t);
                            }
                            continue;
                        }
                        trigger.add(triggerStr);
                        continue;
                    }
                    otherArgs.put("%arg" + otherArgs.size() + "%", args[i]);
                }
                String allArgs = "";
                for (String arg : args) {
                    allArgs = allArgs + arg + " ";
                }
                if (!allArgs.isEmpty()) {
                    allArgs = allArgs.substring(0, allArgs.length() - 1);
                }
                otherArgs.put("%all_args%", allArgs);
                EventInfo eInfo = new EventInfo(null);
                eInfo.setOption((SOption)OptionGlobal.CUSTOM_TRIGGER);
                eInfo.setWhitelistActivatorsId(trigger);
                eInfo.setPlaceholders(otherArgs);
                EventsManager.getInstance().activeOption(eInfo);
                break;
            }
            default: {
                this.pathCommand.run(sender, command, args, typedCommand);
            }
        }
    }

    public List<String> getOnTabCompleteArguments(CommandSender sender, Command command, String label, String[] args) {
        ArrayList<String> arguments = new ArrayList<String>();
        if (args.length >= 2) {
            switch (args[0]) {
                case "clear": {
                    if (args.length != 3) break;
                    for (ClearType type : ClearType.values()) {
                        arguments.add(type.name());
                    }
                    return arguments;
                }
                case "edit": {
                    if (args.length != 2) break;
                    return ExecutableEventsManager.getInstance().getLoadedObjectsWith(args[1]);
                }
                case "enable": 
                case "disable": {
                    if (args.length != 2) break;
                    arguments.addAll(ExecutableEventsManager.getInstance().getLoadedObjectsWith(args[1]));
                    for (String str : ExecutableEventLoader.getInstance().getAllFoldersName()) {
                        arguments.add("folder:" + str);
                    }
                    return arguments;
                }
                case "actionbar": {
                    if (args.length != 2) break;
                    arguments.add("on");
                    arguments.add("off");
                    return arguments;
                }
                case "delete": {
                    if (args.length == 2) {
                        return ExecutableEventsManager.getInstance().getLoadedObjectsWith(args[1]);
                    }
                    if (args.length == 3) {
                        arguments.add("confirm");
                        return arguments;
                    }
                }
                case "reload": {
                    if (args.length != 2) break;
                    arguments.addAll(ExecutableEventsManager.getInstance().getLoadedObjectsWith(args[1]));
                    for (String str : ExecutableEventLoader.getInstance().getAllFoldersName()) {
                        arguments.add("folder:" + str);
                    }
                    return arguments;
                }
                default: {
                    arguments.addAll(this.pathCommand.getArguments(args[0], args));
                    if (arguments.isEmpty()) break;
                    return arguments;
                }
            }
        }
        return new ArrayList<String>();
    }
}

