/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.executableevents.events;

import com.ssomar.executableevents.configs.GeneralConfig;
import com.ssomar.executableevents.executableevents.ExecutableEvent;
import com.ssomar.executableevents.executableevents.manager.ExecutableEventsManager;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.features.custom.activators.activator.SActivator;
import com.ssomar.score.sobject.sactivator.EventInfo;
import com.ssomar.score.usedapi.AllWorldManager;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class EventsManager {
    private static final Boolean DEBUG = false;
    private static EventsManager instance;
    private ExecutableEventsManager iM = ExecutableEventsManager.getInstance();

    public static EventsManager getInstance() {
        if (instance == null) {
            instance = new EventsManager();
        }
        return instance;
    }

    public void activeOptionAllPlayer(EventInfo eInfo) {
        for (Player p : Bukkit.getOnlinePlayers()) {
            eInfo.setPlayer(Optional.of(p));
            eInfo.setWorld(Optional.of(p.getWorld()));
            this.activeOption(eInfo);
        }
    }

    public void activeOption(EventInfo eInfo) {
        SsomarDev.testMsg((String)"activeOption", (boolean)DEBUG);
        for (ExecutableEvent executableEvent : ExecutableEventsManager.getInstance().getAllObjects()) {
            if (!executableEvent.getEnabled().getValue().booleanValue()) continue;
            World world = (World)Bukkit.getWorlds().get(0);
            if (eInfo.getPlayer().isPresent()) {
                world = ((Player)eInfo.getPlayer().get()).getWorld();
            }
            if (!this.isValidWorld(eInfo.getWorld().orElse(world), executableEvent)) continue;
            SsomarDev.testMsg((String)("activeOption - isValidWorld >> " + executableEvent.getId()), (boolean)DEBUG);
            SsomarDev.testMsg((String)("activeOption >> " + executableEvent.getId()), (boolean)DEBUG);
            for (SActivator activator : executableEvent.getActivators().getActivators(eInfo.getOption(), eInfo.getWhitelistActivatorsId(), eInfo.getWhitelistActivators())) {
                SsomarDev.testMsg((String)("activeOption - activator >> " + activator.getId()), (boolean)DEBUG);
                activator.runWithException((Object)executableEvent, eInfo);
            }
        }
    }

    public boolean isValidWorld(World actual, ExecutableEvent item) {
        World world;
        Optional worldOptional;
        for (String str : GeneralConfig.getInstance().getDisableWorlds()) {
            worldOptional = AllWorldManager.getWorld((String)str);
            if (!worldOptional.isPresent() || (world = (World)worldOptional.get()) != actual) continue;
            return false;
        }
        for (String str : item.getDisabledWorlds().getValue()) {
            worldOptional = AllWorldManager.getWorld((String)str);
            if (!worldOptional.isPresent() || (world = (World)worldOptional.get()) != actual) continue;
            return false;
        }
        return true;
    }
}

