/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.executableevents.executableevents;

import com.ssomar.executableevents.ExecutableEvents;
import com.ssomar.executableevents.editor.ExecutableEventsEditor;
import com.ssomar.executableevents.executableevents.ExecutableEventEditor;
import com.ssomar.executableevents.executableevents.ExecutableEventEditorManager;
import com.ssomar.executableevents.executableevents.ExecutableEventLoader;
import com.ssomar.executableevents.executableevents.activators.ActivatorEEFeature;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.features.FeatureAbstract;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.custom.activators.activator.SActivator;
import com.ssomar.score.features.custom.activators.group.ActivatorsFeature;
import com.ssomar.score.features.types.BooleanFeature;
import com.ssomar.score.features.types.ColoredStringFeature;
import com.ssomar.score.features.types.MaterialFeature;
import com.ssomar.score.features.types.list.ListWorldFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.sobject.SObject;
import com.ssomar.score.sobject.SObjectWithActivators;
import com.ssomar.score.sobject.SObjectWithFileEditable;
import com.ssomar.score.sobject.SObjectWithFileLoader;
import com.ssomar.score.sobject.menu.NewSObjectsManagerEditor;
import com.ssomar.score.sobject.menu.SObjectsEditorAbstract;
import com.ssomar.score.splugin.SPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExecutableEvent
extends SObjectWithFileEditable<ExecutableEvent, ExecutableEventEditor, ExecutableEventEditorManager>
implements SObjectWithActivators {
    BooleanFeature enabled;
    ColoredStringFeature displayName;
    private MaterialFeature editorIcon;
    private ActivatorsFeature activatorsFeature;
    private ListWorldFeature disabledWorlds;

    public ExecutableEvent(FeatureParentInterface parent, String id, String path) {
        super((SPlugin)ExecutableEvents.plugin, id, parent, (FeatureSettingsInterface)FeatureSettingsSCore.EXECUTABLEEVENT, path, (SObjectWithFileLoader)ExecutableEventLoader.getInstance());
        this.reset();
    }

    public ExecutableEvent(String id, String path) {
        super((SPlugin)ExecutableEvents.plugin, id, null, (FeatureSettingsInterface)FeatureSettingsSCore.EXECUTABLEEVENT, path, (SObjectWithFileLoader)ExecutableEventLoader.getInstance());
        this.reset();
    }

    public boolean isPremium() {
        return !ExecutableEvents.plugin.isLotOfWork();
    }

    public ItemStack getIconItem() {
        return new ItemStack((Material)this.editorIcon.getValue().get());
    }

    public List<String> getDescription() {
        ArrayList<String> description = new ArrayList<String>();
        description.add("\u00a77ID: \u00a7f" + this.getId());
        description.add("\u00a77Enabled: \u00a7f" + this.enabled.getValue());
        description.add("\u00a77Path: \u00a7f" + this.getPath());
        description.add("\u00a77Activators: ");
        for (SActivator activator : this.activatorsFeature.getActivators().values()) {
            description.add("\u00a77- " + activator.getId());
        }
        return description;
    }

    public List<FeatureInterface> getFeatures() {
        ArrayList<FeatureAbstract> features = new ArrayList<FeatureAbstract>(Arrays.asList(this.enabled, this.editorIcon, this.displayName, this.disabledWorlds, this.activatorsFeature));
        return features;
    }

    public String getParentInfo() {
        return "(Event: " + this.getId() + ")";
    }

    public void reload() {
        if (this.getParent() instanceof ExecutableEvent) {
            ExecutableEvent item = (ExecutableEvent)this.getParent();
            item.setEnabled(this.enabled);
            item.setEditorIcon(this.editorIcon);
            item.setActivatorsFeature(this.activatorsFeature);
            item.setDisplayName(this.displayName);
            item.setDisabledWorlds(this.disabledWorlds);
        }
    }

    public ExecutableEvent clone(FeatureParentInterface parent) {
        ExecutableEvent clone = new ExecutableEvent((FeatureParentInterface)this, this.getId(), this.getPath());
        clone.setEnabled(this.enabled.clone((FeatureParentInterface)clone));
        clone.setEditorIcon(this.editorIcon.clone((FeatureParentInterface)clone));
        clone.setActivatorsFeature(this.activatorsFeature.clone((FeatureParentInterface)clone));
        clone.setDisplayName(this.displayName.clone((FeatureParentInterface)clone));
        clone.setDisabledWorlds(this.disabledWorlds.clone((FeatureParentInterface)clone));
        return clone;
    }

    public void openEditor(@NotNull Player player) {
        ExecutableEventEditorManager.getInstance().startEditing(player, (FeatureParentInterface)this);
    }

    public void openBackEditor(@NotNull Player player) {
        NewSObjectsManagerEditor.getInstance().startEditing(player, (SObjectsEditorAbstract)new ExecutableEventsEditor());
    }

    public List<String> load(SPlugin sPlugin, ConfigurationSection configurationSection, boolean premiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        for (FeatureInterface feature : this.getFeatures()) {
            errors.addAll(feature.load(sPlugin, configurationSection, premiumLoading));
        }
        return errors;
    }

    public void save(ConfigurationSection configurationSection) {
        for (FeatureInterface feature : this.getFeatures()) {
            feature.save(configurationSection);
        }
    }

    public ExecutableEvent getValue() {
        return this;
    }

    public ExecutableEvent initItemParentEditor(GUI gui, int i) {
        return null;
    }

    public void updateItemParentEditor(GUI gui) {
    }

    public void reset() {
        this.enabled = new BooleanFeature((FeatureParentInterface)this, Boolean.valueOf(true), (FeatureSettingsInterface)FeatureSettingsSCore.enabled);
        this.editorIcon = new MaterialFeature((FeatureParentInterface)this, Optional.of(Material.LEVER), (FeatureSettingsInterface)FeatureSettingsSCore.editorIcon, true);
        this.activatorsFeature = new ActivatorsFeature((FeatureParentInterface)this, (SActivator)new ActivatorEEFeature(null, "null"));
        this.displayName = new ColoredStringFeature((FeatureParentInterface)this, Optional.of("&eDefault name"), (FeatureSettingsInterface)FeatureSettingsSCore.name);
        this.disabledWorlds = new ListWorldFeature((FeatureParentInterface)this, new ArrayList(), (FeatureSettingsInterface)FeatureSettingsSCore.disabledWorlds);
    }

    @Nullable
    public SActivator getActivator(String s) {
        for (SActivator acti : this.activatorsFeature.getActivators().values()) {
            if (!acti.getId().equalsIgnoreCase(this.getId())) continue;
            return acti;
        }
        return null;
    }

    public ActivatorsFeature getActivators() {
        return this.activatorsFeature;
    }

    public ItemStack buildItem(int quantity, Optional<Player> playerOpt, Optional<Integer> usageOpt, Optional<ItemStack> itemStackOpt, Map<String, String> variables) {
        return new ItemStack((Material)this.editorIcon.getValue().get());
    }

    public void addCooldown(Player player, int cooldown, boolean isInTicks) {
        for (SActivator activator : this.activatorsFeature.getActivators().values()) {
            if (!(activator instanceof ActivatorEEFeature)) continue;
            ActivatorEEFeature activatorEE = (ActivatorEEFeature)activator;
            SsomarDev.testMsg((String)("addCooldown: " + player.getName() + " " + this.getId() + " " + cooldown + " " + isInTicks), (boolean)true);
            activatorEE.getCooldown().addCooldown((Entity)player, (SObject)this, cooldown, isInTicks);
        }
    }

    public void addCooldown(Player player, int cooldown, boolean isInTicks, String activatorId) {
        for (SActivator activator : this.activatorsFeature.getActivators().values()) {
            if (!(activator instanceof ActivatorEEFeature) || !activatorId.equalsIgnoreCase(activator.getId())) continue;
            ActivatorEEFeature activatorEE = (ActivatorEEFeature)activator;
            activatorEE.getCooldown().addCooldown((Entity)player, (SObject)this, cooldown, isInTicks);
            break;
        }
    }

    public void addGlobalCooldown(int i, boolean b) {
        for (SActivator activator : this.activatorsFeature.getActivators().values()) {
            if (!(activator instanceof ActivatorEEFeature)) continue;
            ActivatorEEFeature activatorEI = (ActivatorEEFeature)activator;
            activatorEI.getCooldown().addGlobalCooldown(i, b);
        }
    }

    public void addGlobalCooldown(int i, boolean b, String activatorId) {
        for (SActivator activator : this.activatorsFeature.getActivators().values()) {
            if (!(activator instanceof ActivatorEEFeature) || !activatorId.equalsIgnoreCase(activator.getId())) continue;
            ActivatorEEFeature activatorEE = (ActivatorEEFeature)activator;
            activatorEE.getCooldown().addGlobalCooldown(i, b);
            break;
        }
    }

    public boolean hasCustomModel() {
        return false;
    }

    public BooleanFeature getEnabled() {
        return this.enabled;
    }

    public ColoredStringFeature getDisplayName() {
        return this.displayName;
    }

    public MaterialFeature getEditorIcon() {
        return this.editorIcon;
    }

    public ActivatorsFeature getActivatorsFeature() {
        return this.activatorsFeature;
    }

    public ListWorldFeature getDisabledWorlds() {
        return this.disabledWorlds;
    }

    public void setEnabled(BooleanFeature enabled) {
        this.enabled = enabled;
    }

    public void setDisplayName(ColoredStringFeature displayName) {
        this.displayName = displayName;
    }

    public void setEditorIcon(MaterialFeature editorIcon) {
        this.editorIcon = editorIcon;
    }

    public void setActivatorsFeature(ActivatorsFeature activatorsFeature) {
        this.activatorsFeature = activatorsFeature;
    }

    public void setDisabledWorlds(ListWorldFeature disabledWorlds) {
        this.disabledWorlds = disabledWorlds;
    }
}

