/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.executableevents.configs;

import com.ssomar.executableevents.ExecutableEvents;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.config.Config;
import com.ssomar.score.usedapi.AllWorldManager;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;

public class GeneralConfig
extends Config {
    private static GeneralConfig instance;
    private List<String> disableWorlds;

    public GeneralConfig() {
        super("config.yml");
        super.setup((Plugin)ExecutableEvents.plugin.getPlugin());
    }

    public static GeneralConfig getInstance() {
        if (instance == null) {
            instance = new GeneralConfig();
        }
        return instance;
    }

    public boolean converter(FileConfiguration fileConfiguration) {
        if (!fileConfiguration.contains("config_12_04_2024")) {
            fileConfiguration.set("config_12_04_2024", (Object)true);
            fileConfiguration.set("premiumEnableCooldownForOp", fileConfiguration.get("premium-enable-cooldown-for-op", (Object)true));
            fileConfiguration.set("premium-enable-cooldown-for-op", null);
            fileConfiguration.set("disabledWorlds", fileConfiguration.get("disable-world", new ArrayList()));
            fileConfiguration.set("disable-world", null);
            fileConfiguration.set("pickupLimit", fileConfiguration.get("pickup-limit", (Object)-1));
            fileConfiguration.set("pickup-limit", null);
            return true;
        }
        return false;
    }

    public void load() {
        this.disableWorlds = new ArrayList<String>();
        for (String str : this.config.getStringList("disabledWorlds")) {
            if (AllWorldManager.getWorld((String)str).isPresent()) {
                this.disableWorlds.add(str);
                continue;
            }
            ExecutableEvents.plugin.getPlugin().getServer().getLogger().severe(ExecutableEvents.plugin.getNameDesign() + " Invalid world: " + str + " in the option disabledWorlds");
        }
        this.loadBooleanSetting(Setting.premiumEnableCooldownForOp.name(), false);
        SsomarDev.testMsg((String)("premiumEnableCooldownForOp: " + this.getBooleanSetting(Setting.premiumEnableCooldownForOp.name())), (boolean)true);
        this.loadBooleanSetting(Setting.checkVersionMsg.name(), true);
        this.loadBooleanSetting(Setting.disableBackup.name(), false);
        if (this.loadIntSetting(Setting.deleteBackupsAfterDays.name(), 7) < 0) {
            this.getLoadedSettings().put(Setting.deleteBackupsAfterDays.name(), 14);
        }
    }

    public void reload() {
        instance = new GeneralConfig();
    }

    public List<String> getDisableWorlds() {
        return this.disableWorlds;
    }

    public void setDisableWorlds(List<String> disableWorlds) {
        this.disableWorlds = disableWorlds;
    }

    public static enum Setting {
        premiumEnableCooldownForOp,
        checkVersionMsg,
        disableBackup,
        deleteBackupsAfterDays;

    }
}

