/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.executableevents;

import com.ssomar.executableevents.MetricsLite;
import com.ssomar.executableevents.SExecutableEvents;
import com.ssomar.executableevents.api.load.ExecutableEventsPostLoadEvent;
import com.ssomar.executableevents.commands.CommandsClass;
import com.ssomar.executableevents.configs.GeneralConfig;
import com.ssomar.executableevents.configs.Message;
import com.ssomar.executableevents.events.EventsHandler;
import com.ssomar.executableevents.events.optimize.OptimizedEventsHandler;
import com.ssomar.executableevents.executableevents.ExecutableEventLoader;
import com.ssomar.executableevents.libs.com.alessiodp.libby.BukkitLibraryManager;
import com.ssomar.executableevents.libs.com.alessiodp.libby.Library;
import com.ssomar.score.SCore;
import com.ssomar.score.configs.messages.MessageMain;
import com.ssomar.score.usedapi.Dependency;
import com.ssomar.score.utils.logging.Utils;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ExecutableEvents
extends JavaPlugin {
    public static final String NAME = "ExecutableEvents";
    public static final String NAME_COLOR = "&dExecutableEvents";
    public static SExecutableEvents plugin;
    private CommandsClass commandClass;
    public static ClassLoader scoreClassLoader;

    public static SExecutableEvents getPluginSt() {
        return plugin;
    }

    public void onLoad() {
        if (Bukkit.getPluginManager().getPlugin("SCore") == null) {
            BukkitLibraryManager bukkitLibraryManager = new BukkitLibraryManager((Plugin)this);
            bukkitLibraryManager.addJitPack();
            String scoreVersion = "main-2ff812dab0-1";
            Library lib = Library.builder().groupId("com{}github{}Ssomar-Developement").artifactId("SCore").version(scoreVersion).resolveTransitiveDependencies(true).build();
            bukkitLibraryManager.loadLibrary(lib);
            try {
                URLClassLoader urlClassLoader = new URLClassLoader(new URL[]{new File(this.getDataFolder() + "/lib/com/github/Ssomar-Developement/SCore/" + scoreVersion + "/SCore-" + scoreVersion + ".jar").toURI().toURL()});
                scoreClassLoader = urlClassLoader;
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void onEnable() {
        if (!Dependency.SCORE.isInstalled()) {
            SCore.initLibPartOfSCore((Plugin)this, (ClassLoader)scoreClassLoader);
        } else if (!Dependency.SCORE.isEnabled()) {
            Bukkit.getPluginManager().enablePlugin(Bukkit.getPluginManager().getPlugin("SCore"));
        }
        plugin = new SExecutableEvents(this);
        this.sendPluginName();
        this.commandClass = new CommandsClass(plugin);
        plugin.getPlugin().saveDefaultConfig();
        if (plugin.isLotOfWork() && SCore.is1v11Less()) {
            plugin.getPlugin().getServer().getLogger().severe(plugin.getNameDesign() + " ExecutableEvents for 1.11 and less is only for the premium version !");
            this.sendPluginName();
            Bukkit.getServer().getPluginManager().disablePlugin((Plugin)plugin.getPlugin());
            return;
        }
        EventsHandler.getInstance().setup(this);
        GeneralConfig.getInstance();
        File backupfolder = new File(plugin.getPlugin().getDataFolder() + "/backups");
        if (backupfolder.exists() && backupfolder.isDirectory()) {
            for (File f : backupfolder.listFiles()) {
                try {
                    String name = f.getName();
                    DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy_MM_dd-HH_mm_ss");
                    LocalDateTime now = LocalDateTime.now();
                    if (!LocalDateTime.from(dtf.parse(name)).plusDays(GeneralConfig.getInstance().getIntSetting(GeneralConfig.Setting.deleteBackupsAfterDays.name(), 30)).isBefore(now)) continue;
                    for (File f2 : f.listFiles()) {
                        f2.delete();
                    }
                    f.delete();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        ExecutableEventLoader.getInstance().setCreateBackup(true);
        ExecutableEventLoader.getInstance().load();
        MessageMain.getInstance().loadMessagesOf((Plugin)plugin.getPlugin(), new ArrayList<Message>(Arrays.asList(Message.values())));
        this.getCommand("ee").setExecutor((CommandExecutor)this.commandClass);
        int pluginId = 16889;
        MetricsLite metrics = new MetricsLite((Plugin)this, pluginId);
        this.sendPluginName();
        Bukkit.getPluginManager().callEvent((Event)new ExecutableEventsPostLoadEvent());
    }

    public void onReload(boolean PluginCommand2) {
        this.sendPluginName();
        plugin.getPlugin().saveDefaultConfig();
        OptimizedEventsHandler.getInstance().reload();
        ExecutableEventLoader.getInstance().reload();
        GeneralConfig.getInstance().reload();
        MessageMain.getInstance().loadMessagesOf((Plugin)plugin.getPlugin(), new ArrayList<Message>(Arrays.asList(Message.values())));
        if (PluginCommand2) {
            // empty if block
        }
        this.sendPluginName();
    }

    public void sendPluginName() {
        if (plugin.isLotOfWork()) {
            Utils.sendConsoleMsg((String)"&7================ &dExecutableEvents &7================");
        } else {
            Utils.sendConsoleMsg((String)"&7========&e*&7======== &dExecutableEvents &7========&e*&7========");
        }
    }

    public void onDisable() {
        try {
            if (SCore.plugin.isEnabled()) {
                SCore.plugin.getServer().getPluginManager().disablePlugin((Plugin)SCore.plugin);
            }
        }
        catch (Error error) {
            // empty catch block
        }
    }
}

