/*
 * Decompiled with CFR 0.152.
 */
package com.apple.library.coregraphics;

import com.apple.library.coregraphics.CGAffineTransform;
import com.apple.library.coregraphics.CGBlendMode;
import com.apple.library.coregraphics.CGGradient;
import com.apple.library.coregraphics.CGGraphicsRenderer;
import com.apple.library.coregraphics.CGGraphicsState;
import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.coregraphics.CGSize;
import com.apple.library.foundation.NSString;
import com.apple.library.impl.AppearanceImpl;
import com.apple.library.impl.ClipContextImpl;
import com.apple.library.impl.GraphicsContextImpl;
import com.apple.library.impl.TooltipRenderer;
import com.apple.library.uikit.UIColor;
import com.apple.library.uikit.UIFont;
import com.apple.library.uikit.UIImage;
import com.apple.library.uikit.UIView;
import moe.plushie.armourers_workshop.compatibility.extensions.com.mojang.blaze3d.systems.RenderSystem.Fix18;
import moe.plushie.armourers_workshop.core.utils.ColorUtils;
import moe.plushie.armourers_workshop.init.ModDebugger;
import moe.plushie.armourers_workshop.utils.RenderSystem;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import org.jetbrains.annotations.Nullable;

public class CGGraphicsContext
implements GraphicsContextImpl {
    private final CGGraphicsState state;
    private final CGGraphicsRenderer renderer;
    private final ClipContextImpl clipContext;

    public CGGraphicsContext(CGGraphicsState state, CGGraphicsRenderer renderer) {
        this.state = state;
        this.renderer = renderer;
        this.clipContext = ClipContextImpl.getInstance();
    }

    public void drawImage(UIImage image, CGRect rect) {
        UIImage.ClipData clipData;
        UIImage.AnimationData animation;
        CGSize limitSize;
        CGSize size;
        if (image == null) {
            return;
        }
        float u = 0.0f;
        float v = 0.0f;
        float w = rect.width();
        float h = rect.height();
        float mw = 256.0f;
        float mh = 256.0f;
        CGPoint texturePos = image.uv();
        if (texturePos != null) {
            u = texturePos.x();
            v = texturePos.y();
        }
        if ((size = image.size()) != null) {
            w = size.width();
            h = size.height();
        }
        if ((limitSize = image.limit()) != null) {
            mw = limitSize.width();
            mh = limitSize.height();
        }
        if ((animation = image.animationData()) != null && animation.frames != 0) {
            int frame = (int)(System.currentTimeMillis() / (long)animation.speed % (long)animation.frames);
            v += h * (float)frame;
        }
        if ((clipData = image.clipData()) != null) {
            float t = clipData.contentInsets.top;
            float b = clipData.contentInsets.bottom;
            float l = clipData.contentInsets.left;
            float r = clipData.contentInsets.right;
            this.drawTilableImage(image.rl(), rect.x, rect.y, rect.width, rect.height, u, v, w, h, mw, mh, t, b, l, r, 0.0f);
            return;
        }
        CGSize sourceSize = image.source();
        if (sourceSize != null) {
            float sw = sourceSize.width;
            float sh = sourceSize.height;
            this.drawResizableImage(image.rl(), rect.x, rect.y, w, h, u, v, sw, sh, mw, mh);
            return;
        }
        this.drawResizableImage(image.rl(), rect.x, rect.y, w, h, u, v, w, h, mw, mh);
    }

    public void drawText(NSString text, float x, float y, UIFont font, @Nullable UIColor color, @Nullable UIColor shadowColor) {
        if (text == null) {
            return;
        }
        if (color == null) {
            color = AppearanceImpl.DEFAULT_TEXT_COLOR;
        }
        this.drawText(text, x, y, color.value(), shadowColor != null, font, 0.0f);
    }

    public void drawTooltip(Object tooltip, CGRect rect) {
        if (tooltip == null) {
            return;
        }
        if (tooltip instanceof NSString) {
            NSString text = (NSString)tooltip;
            this.renderer.renderTooltip(text, rect, UIFont.systemFont(), this);
            return;
        }
        if (tooltip instanceof class_1799) {
            class_1799 itemStack = (class_1799)tooltip;
            this.renderer.renderTooltip(itemStack, rect, UIFont.systemFont(), this);
            return;
        }
        if (tooltip instanceof TooltipRenderer) {
            TooltipRenderer view = (TooltipRenderer)tooltip;
            view.render(rect, this);
            return;
        }
    }

    public void drawContents(Object contents, CGRect rect, UIView view) {
        if (contents == null) {
            return;
        }
        if (contents instanceof UIImage) {
            UIImage image = (UIImage)contents;
            this.drawImage(image, rect);
            return;
        }
        if (contents instanceof UIColor) {
            UIColor color = (UIColor)contents;
            this.fillRect(rect, color);
            return;
        }
        if (contents instanceof CGGradient) {
            CGGradient gradient = (CGGradient)contents;
            this.fillRect(gradient, rect);
            return;
        }
    }

    public void drawEntity(class_1297 entity, CGPoint origin, int scale, CGPoint focus) {
        this.renderer.renderEntity(entity, origin, scale, focus, this);
    }

    public void drawItem(class_1799 itemStack, int x, int y) {
        this.renderer.renderItem(itemStack, x, y, this);
    }

    public void fillRect(CGRect rect, UIColor color) {
        if (color != null && color != UIColor.CLEAR) {
            this.fillRect(rect, color.value());
        }
    }

    public void fillRect(CGRect rect, int color) {
        this.drawColor(rect.x, rect.y, rect.x + rect.width, rect.y + rect.height, 0.0f, color, color);
    }

    public void fillRect(float x1, float y1, float x2, float y2, int color) {
        this.drawColor(x1, y1, x2, y2, 0.0f, color, color);
    }

    public void fillRect(CGGradient gradient, CGRect rect) {
        int color1 = gradient.startColor.value();
        int color2 = gradient.endColor.value();
        this.drawColor(rect.minX(), rect.minY(), rect.maxX(), rect.maxY(), 0.0f, color1, color2);
    }

    public void strokeRect(CGRect rect, UIColor color) {
        this.strokeRect(rect, 1.0f, color.value());
    }

    public void strokeRect(CGRect rect, float lineHeight, UIColor color) {
        this.strokeRect(rect, lineHeight, color.value());
    }

    public void strokeRect(CGRect rect, float lineHeight, int rgb) {
        this.drawBorder(rect.minX(), rect.minY(), rect.maxX(), rect.maxY(), 0.0f, lineHeight, rgb);
    }

    public void addClip(CGRect rect) {
        this.state.flush();
        this.clipContext.addClip(new ClipContextImpl.Rectangle(rect));
    }

    public void addClip(CGRect rect, float cornerRadius) {
        this.state.flush();
        this.clipContext.addClip(new ClipContextImpl.RoundRectangle(rect, cornerRadius));
    }

    public void removeClip() {
        this.state.flush();
        this.clipContext.removeClip();
    }

    public CGRect boundingBoxOfClipPath() {
        return this.clipContext.boundingBoxOfClipPath();
    }

    public void saveGraphicsState() {
        this.state.save();
    }

    public void translateCTM(float x, float y, float z) {
        this.state.translate(x, y, z);
    }

    public void scaleCTM(float x, float y, float z) {
        this.state.scale(x, y, z);
    }

    public void rotateCTM(float x, float y, float z) {
        this.state.rotate(x, y, z);
    }

    public void concatenateCTM(CGAffineTransform transform) {
        this.state.concatenate(transform);
    }

    public void restoreGraphicsState() {
        this.state.restore();
    }

    public void setBlendMode(CGBlendMode mode) {
    }

    public void enableBlend() {
        Fix18.enableAlphaTest(RenderSystem.class);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
    }

    public void disableBlend() {
    }

    public void setBlendColor(UIColor color) {
        RenderSystem.setShaderColor(color);
    }

    public void strokeDebugRect(int tag, CGRect rect) {
        if (ModDebugger.viewHierarchy) {
            int color = ColorUtils.getPaletteColor(tag);
            this.drawBorder(rect.minX(), rect.minY(), rect.maxX(), rect.maxY(), 0.0f, color);
        }
    }

    @Override
    public CGGraphicsState state() {
        return this.state;
    }
}

