/*
 * Decompiled with CFR 0.152.
 */
package com.apple.library.quartzcore;

import com.apple.library.quartzcore.CAAnimation;
import com.apple.library.quartzcore.CAMediaTimingFunction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;
import java.util.function.Consumer;
import org.apache.commons.lang3.tuple.Pair;

public class CATransaction {
    private static double time = 0.0;
    private static PassData current = new PassData();
    private static final Stack<PassData> animationStack = new Stack();
    private static final ArrayList<PassData> runningAnimations = new ArrayList();

    public static void begin() {
        animationStack.push(current);
        current = current.copy();
        current.begin();
    }

    public static void commit() {
        current.commit();
        runningAnimations.add(current);
        current = animationStack.pop();
    }

    public static double currentMediaTime() {
        return time;
    }

    public static double animationDuration() {
        return CATransaction.current.duration;
    }

    public static void setAnimationDuration(double duration) {
        CATransaction.current.duration = duration;
    }

    public static CAMediaTimingFunction animationTimingFunction() {
        return CATransaction.current.timingFunction;
    }

    public static void setAnimationTimingFunction(CAMediaTimingFunction function) {
        CATransaction.current.timingFunction = function;
    }

    public static Runnable completionBlock() {
        return CATransaction.current.completionBlock;
    }

    public static void setCompletionBlock(Runnable completionBlock) {
        CATransaction.current.completionBlock = completionBlock;
    }

    public static void _addAnimation(CAAnimation animation, String keyPath, Runnable completion) {
        animation._setAnimationData(current);
        CATransaction.current.animations.add((Pair<CAAnimation, Runnable>)Pair.of((Object)animation, (Object)completion));
    }

    public static void _removeAnimation(CAAnimation animation, String keyPath) {
        Object object = animation._animationData();
        if (object instanceof PassData) {
            PassData passData = (PassData)object;
            passData.remove(animation);
        }
    }

    public static void _updateAnimations(double tp) {
        time = tp;
        if (runningAnimations.isEmpty()) {
            return;
        }
        Iterator<PassData> iterator = runningAnimations.iterator();
        while (iterator.hasNext()) {
            PassData passData = iterator.next();
            passData.update(tp);
            if (!passData.isEmpty()) continue;
            iterator.remove();
        }
    }

    public static boolean _isEnabled() {
        return !animationStack.isEmpty();
    }

    public static class PassData {
        public double duration = 0.3f;
        public CAMediaTimingFunction timingFunction = CAMediaTimingFunction.EASE_IN_OUT;
        public Runnable completionBlock = null;
        public final ArrayList<Pair<CAAnimation, Runnable>> animations = new ArrayList();

        public void begin() {
        }

        public void commit() {
            double tp = CATransaction.currentMediaTime();
            this.animations.forEach((Consumer<Pair<CAAnimation, Runnable>>)((Consumer<Pair>)it -> {
                CAAnimation ani = (CAAnimation)it.getKey();
                if (ani.beginTime() == 0.0) {
                    ani.setBeginTime(tp);
                }
                if (ani.duration() == 0.0) {
                    ani.setDuration(this.duration);
                }
            }));
        }

        public void update(double tp) {
            Iterator<Pair<CAAnimation, Runnable>> iterator = this.animations.iterator();
            while (iterator.hasNext()) {
                double dur;
                Pair<CAAnimation, Runnable> it = iterator.next();
                CAAnimation animation = (CAAnimation)it.getKey();
                double t = animation._currentTime(tp);
                if (!(t >= (dur = animation.duration()))) continue;
                ((Runnable)it.getValue()).run();
                iterator.remove();
            }
            this.completeIfNeeded();
        }

        public void remove(CAAnimation animation) {
            this.animations.removeIf(it -> it.getKey() == animation);
            this.completeIfNeeded();
        }

        private void completeIfNeeded() {
            if (this.completionBlock != null && this.animations.isEmpty()) {
                this.completionBlock.run();
                this.completionBlock = null;
            }
        }

        public boolean isEmpty() {
            return this.animations.isEmpty();
        }

        public PassData copy() {
            PassData data = new PassData();
            data.duration = this.duration;
            data.timingFunction = this.timingFunction;
            return data;
        }
    }
}

