/*
 * Decompiled with CFR 0.152.
 */
package com.apple.library.uikit;

import com.apple.library.coregraphics.CGRect;
import com.apple.library.foundation.NSString;
import com.apple.library.foundation.NSTextAlignment;
import com.apple.library.impl.AppearanceImpl;
import com.apple.library.impl.SoundManagerImpl;
import com.apple.library.impl.StateValueImpl;
import com.apple.library.uikit.UIColor;
import com.apple.library.uikit.UIControl;
import com.apple.library.uikit.UIEvent;
import com.apple.library.uikit.UIImageView;
import com.apple.library.uikit.UILabel;

public class UICheckBox
extends UIControl {
    private final UILabel markerView = new UILabel(new CGRect(1.0f, 0.0f, 9.0f, 9.0f));
    private final UILabel titleView = new UILabel(CGRect.ZERO);
    private final UIImageView imageView = new UIImageView(new CGRect(0.0f, 0.0f, 9.0f, 9.0f));
    private final StateValueImpl<UIColor> titleColorContainer = new StateValueImpl();
    private float boxSize = 9.0f;
    private float boxSpacing = 2.0f;

    public UICheckBox(CGRect frame) {
        super(frame);
        this.imageView.setImage(AppearanceImpl.BUTTON_IMAGE.imageAtIndex(4));
        this.addSubview(this.imageView);
        this.markerView.setText(new NSString("x"));
        this.markerView.setTextColor(UIColor.WHITE);
        this.markerView.setTextHorizontalAlignment(NSTextAlignment.Horizontal.CENTER);
        this.setTitleColor(UIColor.GRAY, 4);
        this.addSubview(this.markerView);
        this.addSubview(this.titleView);
        this.setSelected(false);
    }

    @Override
    public void layoutSubviews() {
        super.layoutSubviews();
        CGRect rect = this.bounds();
        CGRect frame = new CGRect(0.0f, (rect.height - this.boxSize) / 2.0f, this.boxSize, this.boxSize);
        this.titleView.setFrame(rect.insetBy(0.0f, frame.width + this.boxSpacing, 0.0f, 0.0f));
        this.imageView.setFrame(frame);
        this.markerView.setFrame(frame.offset(0.5f, 0.0f));
    }

    @Override
    public void mouseDown(UIEvent event) {
        super.mouseDown(event);
        if (!this.isEnabled()) {
            return;
        }
        this.setSelected(!this.isSelected());
        this.sendEvent(UIControl.Event.VALUE_CHANGED);
        SoundManagerImpl.click();
    }

    public NSString title() {
        return this.titleView.text();
    }

    public void setTitle(NSString title) {
        this.titleView.setText(title);
    }

    public UIColor titleColor() {
        return this.titleView.textColor();
    }

    public void setTitleColor(UIColor color) {
        this.setTitleColor(color, 0);
    }

    public void setTitleColor(UIColor color, int state) {
        this.titleColorContainer.setValueForState(color, state);
        this.titleView.setTextColor(this.titleColorContainer.currentValue());
        this.updateStateIfNeeded();
    }

    public void setBox(float boxSize, float boxSpacing) {
        this.boxSize = boxSize;
        this.boxSpacing = boxSpacing;
        this.setNeedsLayout();
    }

    @Override
    protected void updateStateIfNeeded() {
        super.updateStateIfNeeded();
        int state = 0;
        if (this.isSelected()) {
            state |= 2;
        }
        if (!this.isEnabled()) {
            state |= 4;
        }
        this.markerView.setHidden(!super.isSelected());
        this.titleColorContainer.setCurrentState(state);
        this.titleView.setTextColor(this.titleColorContainer.currentValue());
    }
}

