/*
 * Decompiled with CFR 0.152.
 */
package com.apple.library.uikit;

import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.foundation.NSString;
import com.apple.library.impl.AppearanceImpl;
import com.apple.library.impl.InputManagerImpl;
import com.apple.library.uikit.UIButton;
import com.apple.library.uikit.UIControl;
import com.apple.library.uikit.UIEvent;
import java.util.function.Function;

public class UISliderBox
extends UIControl {
    private final UIButton leftView = this.shareStateButton();
    private final UIButton rightView = this.shareStateButton();
    private final UIButton middleView = new UIButton(new CGRect(0.0f, 0.0f, 8.0f, 8.0f));
    private final UIButton contentView = this.contentButton();
    private double value = 0.0;
    private double maxValue = 1.0;
    private double minValue = -1.0;
    private double stepValue = 1.0;
    private boolean isSmall = false;
    private boolean isEditing = false;
    private CGRect cachedBounds = CGRect.ZERO;
    private Function<Double, NSString> formatter;

    public UISliderBox(CGRect frame) {
        super(frame);
        this.setup();
    }

    private void setup() {
        this.contentView.setBackgroundImage(AppearanceImpl.BUTTON_IMAGE.imageAtIndex(4), 7);
        this.contentView.setTitleColor(AppearanceImpl.SLIDER_TEXT_COLOR, 0);
        this.contentView.setTitleColor(AppearanceImpl.SLIDER_HIGHLIGHTED_TEXT_COLOR, 1);
        this.contentView.setTitleColor(AppearanceImpl.SLIDER_HIGHLIGHTED_TEXT_COLOR, 2);
        this.addSubview(this.contentView);
        this.leftView.setBackgroundImage(AppearanceImpl.BUTTON_IMAGE, 7);
        this.leftView.addTarget(this, UIControl.Event.MOUSE_LEFT_DOWN, UISliderBox::updateValueAction);
        this.addSubview(this.leftView);
        this.middleView.setBackgroundImage(AppearanceImpl.BUTTON_IMAGE, 7);
        this.middleView.setUserInteractionEnabled(false);
        this.contentView.insertViewAtIndex(this.middleView, 0);
        this.rightView.setBackgroundImage(AppearanceImpl.BUTTON_IMAGE, 7);
        this.rightView.addTarget(this, UIControl.Event.MOUSE_LEFT_DOWN, UISliderBox::updateValueAction);
        this.addSubview(this.rightView);
    }

    @Override
    public void layoutSubviews() {
        super.layoutSubviews();
        CGRect rect = this.bounds();
        if (rect.equals(this.cachedBounds)) {
            return;
        }
        int width = 9;
        int spacing = 1;
        if (!this.isSmall) {
            this.leftView.setFrame(new CGRect(0.0f, 0.0f, width, rect.height));
            this.rightView.setFrame(new CGRect(rect.width - (float)width, 0.0f, width, rect.height));
            this.contentView.setFrame(new CGRect(width + spacing, 0.0f, rect.width - (float)((width + spacing) * 2), rect.height));
        } else {
            this.contentView.setFrame(rect);
        }
        this.middleView.setFrame(this.cursorRect());
        this.cachedBounds = rect;
    }

    public Function<Double, NSString> formatter() {
        return this.formatter;
    }

    public void setFormatter(Function<Double, NSString> formatter) {
        this.formatter = formatter;
        this.valueDidChange();
    }

    public double value() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = this.clampValue(value);
        this.valueDidChange();
    }

    public double stepValue() {
        return this.stepValue;
    }

    public void setStepValue(double value) {
        this.stepValue = value;
    }

    public double minValue() {
        return this.minValue;
    }

    public void setMinValue(double minValue) {
        this.minValue = minValue;
    }

    public double maxValue() {
        return this.maxValue;
    }

    public void setMaxValue(double maxValue) {
        this.maxValue = maxValue;
    }

    public boolean isSmall() {
        return this.isSmall;
    }

    public void setSmall(boolean small) {
        this.isSmall = small;
        this.leftView.setHidden(this.isSmall);
        this.rightView.setHidden(this.isSmall);
        this.setNeedsLayout();
    }

    @Override
    protected boolean shouldPassHighlighted() {
        return false;
    }

    private void beginEditing() {
        this.isEditing = true;
        this.sendEvent(UIControl.Event.EDITING_DID_BEGIN);
        this.updateHighlightedIfNeeded();
    }

    private void endEditing() {
        this.isEditing = false;
        this.sendEvent(UIControl.Event.EDITING_DID_END);
        this.updateHighlightedIfNeeded();
    }

    private void updateValueAction(UIControl control) {
        double value = this.stepValue;
        if (control == this.leftView) {
            value = -this.stepValue;
        }
        this.beginEditing();
        this.updateValue(this.getResolvedValue(value));
        this.endEditing();
    }

    private void updateValueWithEvent(UIEvent event) {
        CGPoint point = event.locationInView(this.contentView);
        double value = (double)point.x / (double)this.contentView.bounds().width;
        if (Math.abs(value - 0.5) < 0.01) {
            value = 0.5;
        }
        double resolvedValue = value * (this.maxValue - this.minValue);
        resolvedValue = (double)((int)(resolvedValue / this.stepValue)) * this.stepValue;
        this.updateValue(this.minValue + resolvedValue);
    }

    private void updateValue(double value) {
        this.setValue(value);
        this.valueDidChange();
        this.sendEvent(UIControl.Event.VALUE_CHANGED);
    }

    private void updateHighlightedIfNeeded() {
        this.middleView.setHighlighted(this.isEditing || this.contentView.isHighlighted());
        this.contentView.setSelected(this.isEditing || this.leftView.isHighlighted() || this.rightView.isHighlighted());
    }

    private void valueDidChange() {
        if (this.formatter != null) {
            this.contentView.setTitle(this.formatter.apply(this.value), 0);
        }
        this.middleView.setFrame(this.cursorRect());
    }

    private double clampValue(double value) {
        return Math.max(Math.min(value, this.maxValue), this.minValue);
    }

    private double getResolvedValue(double inc) {
        double modifier = InputManagerImpl.hasShiftDown() ? (InputManagerImpl.hasControlDown() ? 0.01 : 0.1) : (InputManagerImpl.hasControlDown() ? 10.0 : 1.0);
        double newValue = this.value + inc * modifier;
        if (InputManagerImpl.hasAltDown()) {
            newValue = (double)((int)(newValue / modifier)) * modifier;
        }
        return newValue;
    }

    private CGRect cursorRect() {
        CGRect rect = this.contentView.bounds();
        float width = rect.width;
        float height = rect.height;
        float valueWidth = this.middleView.frame().width;
        double progress = (this.value - this.minValue) / (this.maxValue - this.minValue);
        int x = (int)((double)(width - valueWidth) * progress);
        return new CGRect(x, 0.0f, valueWidth, height);
    }

    private UIButton shareStateButton() {
        return new UIButton(CGRect.ZERO){

            @Override
            public void setHighlighted(boolean highlighted) {
                super.setHighlighted(highlighted);
                UISliderBox.this.updateHighlightedIfNeeded();
            }
        };
    }

    private UIButton contentButton() {
        return new UIButton(CGRect.ZERO){

            @Override
            public void setHighlighted(boolean highlighted) {
                super.setHighlighted(highlighted);
                UISliderBox.this.updateHighlightedIfNeeded();
            }

            @Override
            public void mouseDown(UIEvent event) {
                UISliderBox.this.beginEditing();
                UISliderBox.this.updateValueWithEvent(event);
                this.nextResponder().mouseDown(event);
            }

            @Override
            public void mouseDragged(UIEvent event) {
                UISliderBox.this.updateValueWithEvent(event);
                this.nextResponder().mouseDragged(event);
            }

            @Override
            public void mouseUp(UIEvent event) {
                UISliderBox.this.updateValueWithEvent(event);
                UISliderBox.this.endEditing();
                this.nextResponder().mouseUp(event);
            }
        };
    }
}

