/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.api.core;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.core.IDataSerializable;
import moe.plushie.armourers_workshop.api.core.IDataSerializer;
import moe.plushie.armourers_workshop.core.utils.TagSerializer;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_4208;

public interface IDataCodec<A> {
    public static final IDataCodec<Boolean> BOOL = IDataCodec.wrap(Codec.BOOL);
    public static final IDataCodec<Byte> BYTE = IDataCodec.wrap(Codec.BYTE);
    public static final IDataCodec<Short> SHORT = IDataCodec.wrap(Codec.SHORT);
    public static final IDataCodec<Integer> INT = IDataCodec.wrap(Codec.INT);
    public static final IDataCodec<Long> LONG = IDataCodec.wrap(Codec.LONG);
    public static final IDataCodec<Float> FLOAT = IDataCodec.wrap(Codec.FLOAT);
    public static final IDataCodec<Double> DOUBLE = IDataCodec.wrap(Codec.DOUBLE);
    public static final IDataCodec<String> STRING = IDataCodec.wrap(Codec.STRING);
    public static final IDataCodec<ByteBuffer> BYTE_BUFFER = IDataCodec.wrap(Codec.BYTE_BUFFER);
    public static final IDataCodec<UUID> UUID = INT.listOf().xmap(it -> {
        long l = (long)((Integer)it.get(0)).intValue() << 32 | (long)((Integer)it.get(1)).intValue() & 0xFFFFFFFFL;
        long m = (long)((Integer)it.get(2)).intValue() << 32 | (long)((Integer)it.get(3)).intValue() & 0xFFFFFFFFL;
        return new UUID(l, m);
    }, it -> {
        ArrayList<Integer> result = new ArrayList<Integer>();
        long l = it.getMostSignificantBits();
        long m = it.getLeastSignificantBits();
        result.add((int)(l >> 32));
        result.add((int)l);
        result.add((int)(m >> 32));
        result.add((int)m);
        return result;
    });
    public static final IDataCodec<class_2338> BLOCK_POS = IDataCodec.wrap(class_2338.field_25064).alternative(LONG, class_2338::method_10092);
    public static final IDataCodec<class_4208> GLOBAL_POS = IDataCodec.wrap(class_4208.field_25066);
    public static final IDataCodec<class_2487> COMPOUND_TAG = IDataCodec.wrap(class_2487.field_25128);
    public static final IDataCodec<class_1799> ITEM_STACK = IDataCodec.wrap(class_1799.field_24671);

    public Codec<A> codec();

    public static <T> IDataCodec<T> wrap(Codec<T> codec) {
        return () -> codec;
    }

    public static <T> Field<T> wrap(MapCodec<T> codec) {
        return () -> IDataCodec.wrap(codec.codec());
    }

    public static <F, S> IDataCodec<Pair<F, S>> pair(IDataCodec<F> first, IDataCodec<S> second) {
        return IDataCodec.wrap(Codec.pair(first.codec(), second.codec()));
    }

    public static <F, S> IDataCodec<Either<F, S>> either(IDataCodec<F> first, IDataCodec<S> second) {
        return IDataCodec.wrap(Codec.either(first.codec(), second.codec()));
    }

    default public IDataCodec<List<A>> listOf() {
        return IDataCodec.wrap(this.codec().listOf());
    }

    default public <S> IDataCodec<S> xmap(Function<? super A, ? extends S> to, Function<? super S, ? extends A> from) {
        return IDataCodec.wrap(this.codec().xmap(to, from));
    }

    default public <T> IDataCodec<A> alternative(IDataCodec<T> alternative, Function<T, A> converter) {
        return IDataCodec.either(this, alternative).xmap(either -> either.map(v -> v, converter), Either::left);
    }

    default public <T extends IDataSerializable.Immutable> IDataCodec<T> serializer(Function<? super IDataSerializer, ? extends T> factory) {
        return this.xmap(tag -> {
            TagSerializer serializer = new TagSerializer((class_2487)tag);
            return (IDataSerializable.Immutable)factory.apply(serializer);
        }, it -> {
            TagSerializer serializer = new TagSerializer();
            it.serialize(serializer);
            return serializer.tag();
        });
    }

    default public Field<A> fieldOf(String name) {
        return IDataCodec.wrap(this.codec().fieldOf(name));
    }

    default public Field<Optional<A>> optionalFieldOf(String name) {
        return IDataCodec.wrap(this.codec().optionalFieldOf(name));
    }

    default public Field<A> optionalFieldOf(String name, A defaultValue) {
        return IDataCodec.wrap(this.codec().optionalFieldOf(name, defaultValue));
    }

    public static interface Field<A> {
        public IDataCodec<A> codec();
    }
}

