/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.item;

import java.util.List;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.api.common.IConfigurableToolProperty;
import moe.plushie.armourers_workshop.api.core.IRegistryHolder;
import moe.plushie.armourers_workshop.builder.item.PaintbrushItem;
import moe.plushie.armourers_workshop.builder.item.impl.IPaintToolAction;
import moe.plushie.armourers_workshop.builder.item.option.PaintingToolOptions;
import moe.plushie.armourers_workshop.builder.other.CubePaintingEvent;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.ToolAPI;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import moe.plushie.armourers_workshop.core.utils.ColorUtils;
import moe.plushie.armourers_workshop.init.ModSounds;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_2561;
import net.minecraft.class_3414;

public class HueToolItem
extends PaintbrushItem {
    public HueToolItem(class_1792.class_1793 properties) {
        super(properties);
    }

    @Override
    public void createToolProperties(Consumer<IConfigurableToolProperty<?>> builder) {
        builder.accept(PaintingToolOptions.CHANGE_HUE);
        builder.accept(PaintingToolOptions.CHANGE_SATURATION);
        builder.accept(PaintingToolOptions.CHANGE_BRIGHTNESS);
        builder.accept(PaintingToolOptions.CHANGE_PAINT_TYPE);
        super.createToolProperties(builder);
    }

    @Override
    public IPaintToolAction createPaintToolAction(class_1838 context) {
        class_1799 itemStack = context.method_8041();
        SkinPaintColor paintColor = this.getItemColor(itemStack, SkinPaintColor.WHITE);
        Boolean hue = ToolAPI.get(itemStack, PaintingToolOptions.CHANGE_HUE);
        Boolean saturation = ToolAPI.get(itemStack, PaintingToolOptions.CHANGE_SATURATION);
        Boolean brightness = ToolAPI.get(itemStack, PaintingToolOptions.CHANGE_BRIGHTNESS);
        Boolean paintType = ToolAPI.get(itemStack, PaintingToolOptions.CHANGE_PAINT_TYPE);
        return new CubePaintingEvent.HueAction(paintColor, hue, saturation, brightness, paintType);
    }

    @Override
    public void appendColorHoverText(class_1799 itemStack, List<class_2561> tooltips) {
        SkinPaintColor paintColor = this.getItemColor(itemStack, SkinPaintColor.WHITE);
        tooltips.addAll(ColorUtils.getColorTooltips(paintColor, true));
    }

    @Override
    public IRegistryHolder<class_3414> getItemSoundEvent(class_1838 context) {
        return ModSounds.PAINT;
    }
}

