/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.network;

import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import moe.plushie.armourers_workshop.api.network.IFriendlyByteBuf;
import moe.plushie.armourers_workshop.api.network.IServerPacketHandler;
import moe.plushie.armourers_workshop.builder.blockentity.AdvancedBuilderBlockEntity;
import moe.plushie.armourers_workshop.builder.menu.AdvancedBuilderMenu;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinLoader;
import moe.plushie.armourers_workshop.core.skin.serializer.SkinSerializer;
import moe.plushie.armourers_workshop.core.skin.serializer.document.SkinDocumentNode;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.init.ModPermissions;
import moe.plushie.armourers_workshop.library.data.SkinLibraryManager;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_3222;

public class AdvancedImportPacket
extends CustomPacket {
    private final class_2338 pos;
    private final Skin skin;
    private final String target;

    public AdvancedImportPacket(AdvancedBuilderBlockEntity blockEntity, Skin skin, String target) {
        this.pos = blockEntity.method_11016();
        this.skin = skin;
        this.target = target;
    }

    public AdvancedImportPacket(IFriendlyByteBuf buffer) {
        this.pos = buffer.readBlockPos();
        this.target = buffer.readUtf();
        this.skin = this.decodeSkin(buffer);
    }

    @Override
    public void encode(IFriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos);
        buffer.writeUtf(this.target);
        this.encodeSkin(buffer);
    }

    @Override
    public void accept(IServerPacketHandler packetHandler, class_3222 player) {
        AdvancedBuilderBlockEntity blockEntity1;
        block10: {
            block9: {
                class_2586 blockEntity = player.method_14220().method_8321(this.pos);
                if (!(blockEntity instanceof AdvancedBuilderBlockEntity)) break block9;
                blockEntity1 = (AdvancedBuilderBlockEntity)blockEntity;
                if (player.field_7512 instanceof AdvancedBuilderMenu && this.skin != null) break block10;
            }
            this.abort((class_1657)player, "unauthorized", "user status is incorrect or the skin is invalid");
            return;
        }
        SkinLibraryManager.Server server = SkinLibraryManager.getServer();
        if (!server.shouldUploadFile((class_1657)player)) {
            this.abort((class_1657)player, "import", "uploading prohibited in the config file");
            return;
        }
        if (!ModPermissions.ADVANCED_SKIN_BUILDER_SKIN_IMPORT.accept((class_1657)player)) {
            this.abort((class_1657)player, "import", "prohibited by the config file");
            return;
        }
        if (!this.skin.settings().isEditable()) {
            this.abort((class_1657)player, "import", "prohibited by the skin can't editing.");
            return;
        }
        SkinDocumentNode node = null;
        if (!this.target.isEmpty() && (node = blockEntity1.document().nodeById(this.target)) == null) {
            this.abort((class_1657)player, "import", "can't found node.");
            return;
        }
        this.accept((class_1657)player, "import");
        String identifier = SkinLoader.getInstance().saveSkin("", this.skin);
        if (node != null) {
            blockEntity1.importToNode(identifier, this.skin, node);
        } else {
            blockEntity1.importToDocument(identifier, this.skin);
        }
    }

    private void accept(class_1657 player, String op) {
        ModLog.info("accept {} request of the '{}'", op, player.method_5820());
    }

    private void abort(class_1657 player, String op, String reason) {
        ModLog.info("abort {} request of the '{}', reason: '{}'", op, player.method_5820(), reason);
    }

    private void encodeSkin(IFriendlyByteBuf buffer) {
        try (GZIPOutputStream outputStream = new GZIPOutputStream((OutputStream)new ByteBufOutputStream(buffer.asByteBuf()));){
            SkinSerializer.writeToStream(this.skin, null, outputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Skin decodeSkin(IFriendlyByteBuf buffer) {
        Skin skin;
        GZIPInputStream inputStream = new GZIPInputStream((InputStream)new ByteBufInputStream(buffer.asByteBuf()));
        try {
            skin = SkinSerializer.readFromStream(null, inputStream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        inputStream.close();
        return skin;
    }
}

