/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.blockentity;

import java.util.Map;
import moe.plushie.armourers_workshop.api.core.IDataCodec;
import moe.plushie.armourers_workshop.api.core.IDataSerializer;
import moe.plushie.armourers_workshop.api.core.IDataSerializerKey;
import moe.plushie.armourers_workshop.core.block.HologramProjectorBlock;
import moe.plushie.armourers_workshop.core.blockentity.RotableContainerBlockEntity;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.bake.SkinBakery;
import moe.plushie.armourers_workshop.core.data.SimpleContainer;
import moe.plushie.armourers_workshop.core.data.ticket.TicketManager;
import moe.plushie.armourers_workshop.core.math.OpenMath;
import moe.plushie.armourers_workshop.core.math.OpenQuaternionf;
import moe.plushie.armourers_workshop.core.math.OpenRectangle3f;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.utils.Collections;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2738;
import net.minecraft.class_2769;
import org.apache.commons.lang3.tuple.Pair;

public class HologramProjectorBlockEntity
extends RotableContainerBlockEntity {
    private static final Map<?, OpenVector3f> FACING_TO_ROT = Collections.immutableMap(it -> {
        it.put((Object)Pair.of((Object)class_2738.field_12473, (Object)class_2350.field_11034), (Object)new OpenVector3f(180.0f, 270.0f, 0.0f));
        it.put((Object)Pair.of((Object)class_2738.field_12473, (Object)class_2350.field_11043), (Object)new OpenVector3f(180.0f, 180.0f, 0.0f));
        it.put((Object)Pair.of((Object)class_2738.field_12473, (Object)class_2350.field_11039), (Object)new OpenVector3f(180.0f, 90.0f, 0.0f));
        it.put((Object)Pair.of((Object)class_2738.field_12473, (Object)class_2350.field_11035), (Object)new OpenVector3f(180.0f, 0.0f, 0.0f));
        it.put((Object)Pair.of((Object)class_2738.field_12471, (Object)class_2350.field_11034), (Object)new OpenVector3f(270.0f, 0.0f, 270.0f));
        it.put((Object)Pair.of((Object)class_2738.field_12471, (Object)class_2350.field_11035), (Object)new OpenVector3f(270.0f, 0.0f, 180.0f));
        it.put((Object)Pair.of((Object)class_2738.field_12471, (Object)class_2350.field_11039), (Object)new OpenVector3f(270.0f, 0.0f, 90.0f));
        it.put((Object)Pair.of((Object)class_2738.field_12471, (Object)class_2350.field_11043), (Object)new OpenVector3f(270.0f, 0.0f, 0.0f));
        it.put((Object)Pair.of((Object)class_2738.field_12475, (Object)class_2350.field_11034), (Object)new OpenVector3f(0.0f, 270.0f, 0.0f));
        it.put((Object)Pair.of((Object)class_2738.field_12475, (Object)class_2350.field_11035), (Object)new OpenVector3f(0.0f, 180.0f, 0.0f));
        it.put((Object)Pair.of((Object)class_2738.field_12475, (Object)class_2350.field_11039), (Object)new OpenVector3f(0.0f, 90.0f, 0.0f));
        it.put((Object)Pair.of((Object)class_2738.field_12475, (Object)class_2350.field_11043), (Object)new OpenVector3f(0.0f, 0.0f, 0.0f));
    });
    private final SimpleContainer container = new SimpleContainer(1);
    private OpenQuaternionf renderRotations;
    private int powerMode = 0;
    private float modelScale = 1.0f;
    private boolean isGlowing = true;
    private boolean isPowered = false;
    private boolean showRotationPoint = false;
    private OpenVector3f modelAngle = OpenVector3f.ZERO;
    private OpenVector3f modelOffset = OpenVector3f.ZERO;
    private OpenVector3f rotationSpeed = OpenVector3f.ZERO;
    private OpenVector3f rotationOffset = OpenVector3f.ZERO;

    public HologramProjectorBlockEntity(class_2591<?> blockEntityType, class_2338 blockPos, class_2680 blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    @Override
    public void readAdditionalData(IDataSerializer serializer) {
        this.container.deserialize(serializer);
        this.modelAngle = serializer.read(CodingKeys.ANGLE);
        this.modelOffset = serializer.read(CodingKeys.OFFSET);
        this.rotationSpeed = serializer.read(CodingKeys.ROTATION_SPEED);
        this.rotationOffset = serializer.read(CodingKeys.ROTATION_OFFSET);
        this.isGlowing = serializer.read(CodingKeys.IS_GLOWING);
        this.isPowered = serializer.read(CodingKeys.IS_POWERED);
        this.modelScale = serializer.read(CodingKeys.SCALE).floatValue();
        this.powerMode = serializer.read(CodingKeys.POWER_MODE);
        this.setRenderChanged();
    }

    @Override
    public void writeAdditionalData(IDataSerializer serializer) {
        this.container.serialize(serializer);
        serializer.write(CodingKeys.ANGLE, this.modelAngle);
        serializer.write(CodingKeys.OFFSET, this.modelOffset);
        serializer.write(CodingKeys.ROTATION_SPEED, this.rotationSpeed);
        serializer.write(CodingKeys.ROTATION_OFFSET, this.rotationOffset);
        serializer.write(CodingKeys.IS_GLOWING, this.isGlowing);
        serializer.write(CodingKeys.IS_POWERED, this.isPowered);
        serializer.write(CodingKeys.SCALE, Float.valueOf(this.modelScale));
        serializer.write(CodingKeys.POWER_MODE, this.powerMode);
    }

    public void updatePowerStats() {
        boolean newValue = this.isRunningForState(this.method_11010());
        if (newValue != this.isPowered) {
            this.updateBlockStates();
        }
    }

    public void updateBlockStates() {
        class_2680 state = this.method_11010();
        this.isPowered = this.isRunningForState(state);
        this.method_5431();
        this.setRenderChanged();
        boolean growing = this.isPowered && this.isGlowing;
        class_1937 level = this.method_10997();
        if (level != null && !level.method_8608()) {
            if ((Boolean)state.method_11654((class_2769)HologramProjectorBlock.LIT) != growing) {
                class_2680 newState = (class_2680)state.method_11657((class_2769)HologramProjectorBlock.LIT, (Comparable)Boolean.valueOf(growing));
                level.method_8652(this.method_11016(), newState, 2);
            } else {
                level.method_8413(this.method_11016(), state, state, 2);
            }
        }
    }

    public int powerMode() {
        return this.powerMode;
    }

    public void setPowerMode(int powerMode) {
        this.powerMode = powerMode;
        this.updateBlockStates();
    }

    public boolean isPowered() {
        return this.isPowered;
    }

    protected boolean isRunningForState(class_2680 state) {
        class_1937 level = this.method_10997();
        if (level != null && !SkinDescriptor.of(this.container.method_5438(0)).isEmpty()) {
            return switch (this.powerMode) {
                case 1 -> level.method_8479(this.method_11016());
                case 2 -> {
                    if (!level.method_8479(this.method_11016())) {
                        yield true;
                    }
                    yield false;
                }
                default -> true;
            };
        }
        return false;
    }

    public boolean isOverrideLight() {
        return this.isGlowing;
    }

    public boolean isOverrideOrigin() {
        return true;
    }

    public boolean isGlowing() {
        return this.isGlowing;
    }

    public void setGlowing(boolean glowing) {
        this.isGlowing = glowing;
        this.updateBlockStates();
    }

    public void setShowRotationPoint(boolean showRotationPoint) {
        this.showRotationPoint = showRotationPoint;
    }

    public boolean shouldShowRotationPoint() {
        return this.showRotationPoint;
    }

    @Override
    protected SimpleContainer getContainer() {
        return this.container;
    }

    @Override
    protected void setContainerChanged() {
        super.setContainerChanged();
        this.updateBlockStates();
    }

    public boolean method_5437(int i, class_1799 itemStack) {
        return !SkinDescriptor.of(itemStack).isEmpty();
    }

    public OpenVector3f getRotationSpeed() {
        return this.rotationSpeed;
    }

    public void setRotationSpeed(OpenVector3f rotationSpeed) {
        this.rotationSpeed = rotationSpeed;
        this.updateBlockStates();
    }

    public OpenVector3f getRotationOffset() {
        return this.rotationOffset;
    }

    public void setRotationOffset(OpenVector3f rotationOffset) {
        this.rotationOffset = rotationOffset;
        this.updateBlockStates();
    }

    public OpenVector3f getModelOffset() {
        return this.modelOffset;
    }

    public void setModelOffset(OpenVector3f modelOffset) {
        this.modelOffset = modelOffset;
        this.updateBlockStates();
    }

    public OpenVector3f getModelAngle() {
        return this.modelAngle;
    }

    public void setModelAngle(OpenVector3f modelAngle) {
        this.modelAngle = modelAngle;
        this.updateBlockStates();
    }

    public float getModelScale() {
        return this.modelScale;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public OpenQuaternionf getRenderRotations(class_2680 blockState) {
        if (this.renderRotations != null) {
            return this.renderRotations;
        }
        class_2738 face = blockState.method_28500((class_2769)HologramProjectorBlock.FACE).orElse(class_2738.field_12475);
        class_2350 facing = blockState.method_28500((class_2769)HologramProjectorBlock.field_11177).orElse(class_2350.field_11043);
        OpenVector3f rot = FACING_TO_ROT.getOrDefault(Pair.of((Object)face, (Object)facing), OpenVector3f.ZERO);
        this.renderRotations = new OpenQuaternionf(rot.x(), rot.y(), rot.z(), true);
        return this.renderRotations;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public OpenRectangle3f getRenderShape(class_2680 blockState) {
        float z;
        float y;
        float x;
        if (!this.isPowered()) {
            return null;
        }
        SkinDescriptor descriptor = SkinDescriptor.of(this.method_5438(0));
        BakedSkin bakedSkin = SkinBakery.getInstance().loadSkin(TicketManager.TEST.get(descriptor));
        if (bakedSkin == null) {
            return null;
        }
        OpenRectangle3f rect = bakedSkin.renderBounds();
        float f = 0.0625f;
        float scale = this.getModelScale() * f;
        float modelRadius = 0.0f;
        float rotationRadius = 0.0f;
        if (!rect.equals(OpenRectangle3f.ZERO)) {
            x = Math.max(Math.abs(rect.minX()), Math.abs(rect.maxX()));
            y = Math.max(Math.abs(rect.minY()), Math.abs(rect.maxY()));
            z = Math.max(Math.abs(rect.minZ()), Math.abs(rect.maxZ()));
            modelRadius = OpenMath.sqrt(x * x + y * y + z * z);
        }
        if (!this.rotationOffset.equals(OpenVector3f.ZERO)) {
            x = Math.abs(this.rotationOffset.x());
            y = Math.abs(this.rotationOffset.y());
            z = Math.abs(this.rotationOffset.z());
            rotationRadius = OpenMath.sqrt(x * x + y * y + z * z);
        }
        float tr = (rotationRadius + modelRadius) * scale;
        float tx = this.modelOffset.x() * scale;
        float ty = this.modelOffset.y() * scale + 0.5f;
        float tz = this.modelOffset.z() * scale;
        if (this.isOverrideOrigin()) {
            ty += rect.maxY() * scale;
        }
        return new OpenRectangle3f(tx - tr, ty - tr, tz - tr, tr * 2.0f, tr * 2.0f, tr * 2.0f);
    }

    private static class CodingKeys {
        public static final IDataSerializerKey<OpenVector3f> ANGLE = IDataSerializerKey.create("Angle", OpenVector3f.CODEC, OpenVector3f.ZERO);
        public static final IDataSerializerKey<OpenVector3f> OFFSET = IDataSerializerKey.create("Offset", OpenVector3f.CODEC, OpenVector3f.ZERO);
        public static final IDataSerializerKey<OpenVector3f> ROTATION_SPEED = IDataSerializerKey.create("RotSpeed", OpenVector3f.CODEC, OpenVector3f.ZERO);
        public static final IDataSerializerKey<OpenVector3f> ROTATION_OFFSET = IDataSerializerKey.create("RotOffset", OpenVector3f.CODEC, OpenVector3f.ZERO);
        public static final IDataSerializerKey<Boolean> IS_GLOWING = IDataSerializerKey.create("Glowing", IDataCodec.BOOL, true);
        public static final IDataSerializerKey<Boolean> IS_POWERED = IDataSerializerKey.create("Powered", IDataCodec.BOOL, false);
        public static final IDataSerializerKey<Float> SCALE = IDataSerializerKey.create("Scale", IDataCodec.FLOAT, Float.valueOf(1.0f));
        public static final IDataSerializerKey<Integer> POWER_MODE = IDataSerializerKey.create("PowerMode", IDataCodec.INT, 0);

        private CodingKeys() {
        }
    }
}

