/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.blockentity;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.common.IBlockEntityCapability;
import moe.plushie.armourers_workshop.api.common.ITickable;
import moe.plushie.armourers_workshop.api.core.IDataCodec;
import moe.plushie.armourers_workshop.api.core.IDataSerializer;
import moe.plushie.armourers_workshop.api.core.IDataSerializerKey;
import moe.plushie.armourers_workshop.core.block.SkinnableBlock;
import moe.plushie.armourers_workshop.core.blockentity.RotableContainerBlockEntity;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.bake.SkinBakery;
import moe.plushie.armourers_workshop.core.data.SimpleContainer;
import moe.plushie.armourers_workshop.core.data.ticket.TicketManager;
import moe.plushie.armourers_workshop.core.math.OpenMatrix4f;
import moe.plushie.armourers_workshop.core.math.OpenQuaternionf;
import moe.plushie.armourers_workshop.core.math.OpenRectangle3f;
import moe.plushie.armourers_workshop.core.math.OpenRectangle3i;
import moe.plushie.armourers_workshop.core.math.OpenVector3d;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.SkinMarker;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.init.ModLog;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2738;
import net.minecraft.class_2769;
import net.minecraft.class_4208;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class SkinnableBlockEntity
extends RotableContainerBlockEntity
implements ITickable {
    private static final Map<?, OpenVector3f> FACING_TO_ROT = Collections.immutableMap(it -> {
        it.put((Object)Pair.of((Object)class_2738.field_12473, (Object)class_2350.field_11034), (Object)new OpenVector3f(180.0f, 270.0f, 0.0f));
        it.put((Object)Pair.of((Object)class_2738.field_12473, (Object)class_2350.field_11043), (Object)new OpenVector3f(180.0f, 180.0f, 0.0f));
        it.put((Object)Pair.of((Object)class_2738.field_12473, (Object)class_2350.field_11039), (Object)new OpenVector3f(180.0f, 90.0f, 0.0f));
        it.put((Object)Pair.of((Object)class_2738.field_12473, (Object)class_2350.field_11035), (Object)new OpenVector3f(180.0f, 0.0f, 0.0f));
        it.put((Object)Pair.of((Object)class_2738.field_12471, (Object)class_2350.field_11034), (Object)new OpenVector3f(0.0f, 270.0f, 0.0f));
        it.put((Object)Pair.of((Object)class_2738.field_12471, (Object)class_2350.field_11035), (Object)new OpenVector3f(0.0f, 180.0f, 0.0f));
        it.put((Object)Pair.of((Object)class_2738.field_12471, (Object)class_2350.field_11039), (Object)new OpenVector3f(0.0f, 90.0f, 0.0f));
        it.put((Object)Pair.of((Object)class_2738.field_12471, (Object)class_2350.field_11043), (Object)new OpenVector3f(0.0f, 0.0f, 0.0f));
        it.put((Object)Pair.of((Object)class_2738.field_12475, (Object)class_2350.field_11034), (Object)new OpenVector3f(0.0f, 270.0f, 0.0f));
        it.put((Object)Pair.of((Object)class_2738.field_12475, (Object)class_2350.field_11035), (Object)new OpenVector3f(0.0f, 180.0f, 0.0f));
        it.put((Object)Pair.of((Object)class_2738.field_12475, (Object)class_2350.field_11039), (Object)new OpenVector3f(0.0f, 90.0f, 0.0f));
        it.put((Object)Pair.of((Object)class_2738.field_12475, (Object)class_2350.field_11043), (Object)new OpenVector3f(0.0f, 0.0f, 0.0f));
    });
    private class_2338 reference = class_2338.field_10980;
    private OpenRectangle3i collisionShape = OpenRectangle3i.ZERO;
    private SimpleContainer container;
    private List<class_2338> refers;
    private List<SkinMarker> markers;
    private class_4208 linkedPos = null;
    private SkinProperties properties;
    private SkinDescriptor skin = SkinDescriptor.EMPTY;
    private OpenQuaternionf renderRotations;
    private class_238 renderBoundingBox;
    private class_265 cachedRenderShape = null;
    private class_265 cachedCollisionShape = null;
    private class_1799 droppedStack = null;
    private LinkedSnapshot lastSnapshot;
    private int callDepth = 0;
    private boolean isParent = false;

    public SkinnableBlockEntity(class_2591<?> blockEntityType, class_2338 blockPos, class_2680 blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    public static OpenVector3f getRotations(class_2680 state) {
        class_2738 face = state.method_28500((class_2769)SkinnableBlock.FACE).orElse(class_2738.field_12475);
        class_2350 facing = state.method_28500((class_2769)SkinnableBlock.field_11177).orElse(class_2350.field_11043);
        return FACING_TO_ROT.getOrDefault(Pair.of((Object)face, (Object)facing), OpenVector3f.ZERO);
    }

    @Override
    public void readAdditionalData(IDataSerializer serializer) {
        this.reference = serializer.read(CodingKeys.REFERENCE);
        this.collisionShape = serializer.read(CodingKeys.SHAPE);
        this.cachedRenderShape = null;
        this.cachedCollisionShape = null;
        this.isParent = class_2338.field_10980.equals((Object)this.reference);
        if (!this.isParent()) {
            return;
        }
        SkinProperties oldProperties = this.properties;
        this.refers = serializer.read(CodingKeys.REFERENCES);
        this.markers = serializer.read(CodingKeys.MARKERS);
        this.skin = serializer.read(CodingKeys.SKIN);
        this.properties = serializer.read(CodingKeys.SKIN_PROPERTIES);
        this.linkedPos = serializer.read(CodingKeys.LINKED_POS);
        if (oldProperties != null) {
            oldProperties.clear();
            oldProperties.putAll(this.properties);
            this.properties = oldProperties;
        }
        this.getOrCreateItems().deserialize(serializer);
    }

    @Override
    public void writeAdditionalData(IDataSerializer serializer) {
        serializer.write(CodingKeys.REFERENCE, this.reference);
        serializer.write(CodingKeys.SHAPE, this.collisionShape);
        if (!this.isParent()) {
            return;
        }
        serializer.write(CodingKeys.REFERENCES, this.refers);
        serializer.write(CodingKeys.MARKERS, this.markers);
        serializer.write(CodingKeys.SKIN, this.skin);
        serializer.write(CodingKeys.SKIN_PROPERTIES, this.properties);
        serializer.write(CodingKeys.LINKED_POS, this.linkedPos);
        this.getOrCreateItems().serialize(serializer);
    }

    @Override
    public void tick() {
        if (this.isParent()) {
            this.parentTick();
        } else {
            this.childTick();
        }
    }

    protected void parentTick() {
        LinkedSnapshot snapshot = this.makeLinkedSnapshot();
        if (!Objects.equals(this.lastSnapshot, snapshot)) {
            this.updateStateAndNeighbors();
            this.lastSnapshot = snapshot;
        }
    }

    protected void childTick() {
        class_1937 level = this.method_10997();
        SkinnableBlockEntity parent = this.getParent();
        if (parent == null && level != null && !level.method_8608()) {
            ModLog.warn("found a zombie block at {}, destroy it.", this.method_11016());
            this.kill();
        }
    }

    public void updateBlockStates() {
        this.method_5431();
        class_1937 level = this.method_10997();
        if (level != null && !level.method_8608()) {
            level.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 2);
        }
    }

    public void updateStateAndNeighbors() {
        class_1937 level = this.method_10997();
        if (level != null && !level.method_8608()) {
            level.method_8455(this.method_11016(), this.method_11010().method_26204());
            level.method_8452(this.method_11016(), this.method_11010().method_26204());
        }
    }

    public void setSkin(SkinDescriptor skin) {
        this.skin = skin;
    }

    public SkinDescriptor getSkin() {
        if (this.isParent()) {
            return this.skin;
        }
        return SkinDescriptor.EMPTY;
    }

    public class_265 getShape() {
        if (this.cachedRenderShape != null) {
            return this.cachedRenderShape;
        }
        this.cachedRenderShape = this.calcCollisionShape();
        return this.cachedRenderShape;
    }

    public class_265 getCollisionShape() {
        if (this.noCollision()) {
            return class_259.method_1073();
        }
        if (this.cachedCollisionShape != null) {
            return this.cachedCollisionShape;
        }
        this.cachedCollisionShape = this.calcCollisionShape();
        return this.cachedCollisionShape;
    }

    public void setLinkedPos(class_4208 pos) {
        SkinnableBlockEntity blockEntity = this.getParent();
        if (blockEntity != null) {
            blockEntity.linkedPos = pos;
            blockEntity.updateBlockStates();
            blockEntity.updateStateAndNeighbors();
        }
    }

    public class_4208 getLinkedPos() {
        return this.getValueFromParent(te -> te.linkedPos).orElse(null);
    }

    public void kill() {
        class_1937 level = this.method_10997();
        if (level != null && !level.method_8608()) {
            level.method_8501(this.method_11016(), class_2246.field_10124.method_9564());
        }
    }

    @Override
    public int method_5439() {
        return 81;
    }

    @Override
    protected SimpleContainer getContainer() {
        return this.getOrCreateItems();
    }

    @Nullable
    public String getInventoryName() {
        return this.getProperty(SkinProperty.ALL_CUSTOM_NAME);
    }

    @Override
    @Nullable
    public class_1263 getInventory() {
        return this.getParent();
    }

    public int getAnalogOutputSignal() {
        return this.getLinkedValueFromParent((level, pos) -> level.method_8320(pos).method_26176(level, pos)).orElse(0);
    }

    public int getSignal(class_2350 dir) {
        return this.getLinkedValueFromParent((level, pos) -> level.method_8320(pos).method_26195((class_1922)level, pos, dir)).orElse(0);
    }

    public int getDirectSignal(class_2350 dir) {
        return this.getLinkedValueFromParent((level, pos) -> level.method_8320(pos).method_26203((class_1922)level, pos, dir)).orElse(0);
    }

    public Collection<class_2338> getRefers() {
        if (this.refers == null) {
            this.refers = this.getValueFromParent(te -> te.refers).orElse(null);
        }
        if (this.refers == null) {
            return Collections.emptyList();
        }
        return this.refers;
    }

    public class_2338 getParentPos() {
        return this.method_11016().method_10059((class_2382)this.reference);
    }

    public OpenVector3d getSeatPos() {
        float dx = 0.0f;
        float dy = 0.0f;
        float dz = 0.0f;
        class_2338 parentPos = this.getParentPos();
        Collection<SkinMarker> markers = this.getMarkers();
        if (markers != null && !markers.isEmpty()) {
            SkinMarker marker = markers.iterator().next();
            dx = (float)marker.x / 16.0f;
            dy = (float)marker.y / 16.0f;
            dz = (float)marker.z / 16.0f;
        }
        return new OpenVector3d((float)parentPos.method_10263() + dx, (float)parentPos.method_10264() + dy, (float)parentPos.method_10260() + dz);
    }

    public class_2338 getBedPos() {
        class_2338 parentPos = this.getParentPos();
        Collection<SkinMarker> markers = this.getMarkers();
        if (markers == null || markers.isEmpty()) {
            class_2350 facing = this.method_11010().method_28500((class_2769)SkinnableBlock.field_11177).orElse(class_2350.field_11043);
            return parentPos.method_10093(class_2470.field_11464.method_10503(facing));
        }
        SkinMarker marker = markers.iterator().next();
        return parentPos.method_10069(marker.x / 16, marker.y / 16, marker.z / 16);
    }

    public Collection<SkinMarker> getMarkers() {
        if (this.markers == null) {
            this.markers = this.getValueFromParent(te -> te.markers).orElse(null);
        }
        return this.markers;
    }

    @Nullable
    public SkinProperties getProperties() {
        if (this.properties == null) {
            this.properties = this.getValueFromParent(te -> te.properties).orElse(null);
        }
        return this.properties;
    }

    @Nullable
    public SkinnableBlockEntity getParent() {
        if (this.isParent()) {
            return this;
        }
        if (this.method_10997() != null) {
            return Objects.safeCast(this.method_10997().method_8321(this.getParentPos()), SkinnableBlockEntity.class);
        }
        return null;
    }

    public void setDropped(class_1799 itemStack) {
        this.droppedStack = itemStack;
    }

    public class_1799 getDropped() {
        return this.droppedStack;
    }

    public boolean isDropped() {
        return this.droppedStack != null;
    }

    public boolean isLadder() {
        return this.getProperty(SkinProperty.BLOCK_LADDER);
    }

    public boolean isEmissive() {
        return this.getProperty(SkinProperty.BLOCK_GLOWING);
    }

    public boolean isSeat() {
        return this.getProperty(SkinProperty.BLOCK_SEAT);
    }

    public boolean isBed() {
        return this.getProperty(SkinProperty.BLOCK_BED);
    }

    public boolean isLinked() {
        return this.getLinkedPos() != null;
    }

    public boolean isInventory() {
        return this.getProperty(SkinProperty.BLOCK_INVENTORY) != false || this.isEnderInventory();
    }

    public boolean isEnderInventory() {
        return this.getProperty(SkinProperty.BLOCK_ENDER_INVENTORY);
    }

    public boolean isParent() {
        return this.isParent;
    }

    public boolean noCollision() {
        return this.getProperty(SkinProperty.BLOCK_NO_COLLISION);
    }

    public int getInventoryWidth() {
        return this.getProperty(SkinProperty.BLOCK_INVENTORY_WIDTH);
    }

    public int getInventoryHeight() {
        return this.getProperty(SkinProperty.BLOCK_INVENTORY_HEIGHT);
    }

    @Override
    @Nullable
    public <T> T getCapability(IBlockEntityCapability<T> capability, @Nullable class_2350 dir) {
        return this.getLinkedValueFromParent((level, pos) -> {
            class_2680 state = level.method_8320(pos);
            class_2586 entity = level.method_8321(pos);
            return capability.get((class_1937)level, (class_2338)pos, state, entity, dir);
        }).orElse(null);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public OpenQuaternionf getRenderRotations(class_2680 blockState) {
        if (this.renderRotations != null) {
            return this.renderRotations;
        }
        OpenVector3f r = SkinnableBlockEntity.getRotations(blockState);
        this.renderRotations = new OpenQuaternionf(r.x(), r.y(), r.z(), true);
        return this.renderRotations;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public OpenRectangle3f getRenderShape(class_2680 blockState) {
        BakedSkin bakedSkin = SkinBakery.getInstance().loadSkin(TicketManager.TEST.get(this.getSkin()));
        if (bakedSkin == null) {
            return null;
        }
        float f = 0.0625f;
        OpenRectangle3f box = bakedSkin.renderBounds().copy();
        box.mul(OpenMatrix4f.createScaleMatrix(-f, -f, f));
        return box;
    }

    private SimpleContainer getOrCreateItems() {
        if (this.container == null) {
            this.container = new SimpleContainer(this.method_5439());
        }
        return this.container;
    }

    public <V> Optional<V> getValueFromParent(Function<SkinnableBlockEntity, V> getter) {
        SkinnableBlockEntity blockEntity = this.getParent();
        if (blockEntity != null) {
            return Optional.ofNullable(getter.apply(blockEntity));
        }
        return Optional.empty();
    }

    public <V> Optional<V> getLinkedValueFromParent(BiFunction<class_1937, class_2338, V> getter) {
        class_4208 globalPos = this.getLinkedPos();
        if (globalPos == null) {
            return Optional.empty();
        }
        class_1937 level = this.method_10997();
        if (level == null) {
            return Optional.empty();
        }
        if (!Objects.equals(level.method_27983(), globalPos.method_19442())) {
            MinecraftServer server = level.method_8503();
            if (server == null) {
                return Optional.empty();
            }
            level = server.method_3847(globalPos.method_19442());
        }
        if (level == null || !level.method_8477(globalPos.method_19446()) || this.callDepth > 10) {
            return Optional.empty();
        }
        ++this.callDepth;
        V result = getter.apply(level, globalPos.method_19446());
        --this.callDepth;
        return Optional.ofNullable(result);
    }

    private <V> V getProperty(SkinProperty<V> property) {
        SkinProperties properties = this.getProperties();
        if (properties != null) {
            return properties.get(property);
        }
        return property.defaultValue();
    }

    private LinkedSnapshot makeLinkedSnapshot() {
        Optional<LinkedSnapshot> result = this.getLinkedValueFromParent((level, pos) -> {
            LinkedSnapshot snapshot = new LinkedSnapshot();
            class_2680 state = level.method_8320(pos);
            if (state.method_26221()) {
                snapshot.analogOutputSignal = state.method_26176(level, pos);
            }
            for (class_2350 dir : class_2350.values()) {
                snapshot.redstoneSignal[dir.method_10146()] = state.method_26195((class_1922)level, pos, dir);
                snapshot.directRedstoneSignal[dir.method_10146()] = state.method_26203((class_1922)level, pos, dir);
            }
            return snapshot;
        });
        return result.orElse(null);
    }

    private class_265 calcCollisionShape() {
        if (this.collisionShape.equals(OpenRectangle3i.ZERO)) {
            return class_259.method_1077();
        }
        float minX = (float)this.collisionShape.minX() / 16.0f + 0.5f;
        float minY = (float)this.collisionShape.minY() / 16.0f + 0.5f;
        float minZ = (float)this.collisionShape.minZ() / 16.0f + 0.5f;
        float maxX = (float)this.collisionShape.maxX() / 16.0f + 0.5f;
        float maxY = (float)this.collisionShape.maxY() / 16.0f + 0.5f;
        float maxZ = (float)this.collisionShape.maxZ() / 16.0f + 0.5f;
        return class_259.method_1081((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
    }

    private static class CodingKeys {
        public static final IDataSerializerKey<class_2338> REFERENCE = IDataSerializerKey.create("Refer", IDataCodec.BLOCK_POS, class_2338.field_10980);
        public static final IDataSerializerKey<OpenRectangle3i> SHAPE = IDataSerializerKey.create("Shape", OpenRectangle3i.CODEC, OpenRectangle3i.ZERO);
        public static final IDataSerializerKey<class_4208> LINKED_POS = IDataSerializerKey.create("LinkedPos", IDataCodec.GLOBAL_POS, null);
        public static final IDataSerializerKey<SkinDescriptor> SKIN = IDataSerializerKey.create("Skin", SkinDescriptor.CODEC, SkinDescriptor.EMPTY);
        public static final IDataSerializerKey<SkinProperties> SKIN_PROPERTIES = IDataSerializerKey.create("SkinProperties", SkinProperties.CODEC, SkinProperties.EMPTY, SkinProperties.EMPTY::copy);
        public static final IDataSerializerKey<List<class_2338>> REFERENCES = IDataSerializerKey.create("Refers", IDataCodec.BLOCK_POS.listOf(), Collections.emptyList());
        public static final IDataSerializerKey<List<SkinMarker>> MARKERS = IDataSerializerKey.create("Markers", SkinMarker.CODEC.listOf(), Collections.emptyList());

        private CodingKeys() {
        }
    }

    private static class LinkedSnapshot {
        private int analogOutputSignal = 0;
        private final int[] redstoneSignal = new int[]{0, 0, 0, 0, 0, 0};
        private final int[] directRedstoneSignal = new int[]{0, 0, 0, 0, 0, 0};

        private LinkedSnapshot() {
        }

        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LinkedSnapshot)) {
                return false;
            }
            LinkedSnapshot snapshot = (LinkedSnapshot)o;
            return this.analogOutputSignal == snapshot.analogOutputSignal && Arrays.equals(this.redstoneSignal, snapshot.redstoneSignal) && Arrays.equals(this.directRedstoneSignal, snapshot.directRedstoneSignal);
        }

        public int hashCode() {
            int result = this.analogOutputSignal;
            result = 31 * result + Arrays.hashCode(this.redstoneSignal);
            result = 31 * result + Arrays.hashCode(this.directRedstoneSignal);
            return result;
        }
    }
}

