/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.animation;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import moe.plushie.armourers_workshop.api.core.math.IPoseStack;
import moe.plushie.armourers_workshop.api.core.math.ITransform;
import moe.plushie.armourers_workshop.core.client.animation.AnimatedOutputPoint;
import moe.plushie.armourers_workshop.core.client.animation.AnimatedPoint;
import moe.plushie.armourers_workshop.core.math.OpenMath;
import moe.plushie.armourers_workshop.core.math.OpenQuaternionf;
import moe.plushie.armourers_workshop.core.math.OpenTransform3f;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTransform;
import moe.plushie.armourers_workshop.core.utils.Collections;
import org.jetbrains.annotations.Nullable;

public class AnimatedTransform
implements ITransform {
    private final OpenVector3f pivot;
    private final OpenVector3f afterTranslate;
    private final OpenTransform3f parent;
    private final List<AnimatedOutputPoint> pendingPoints = new ArrayList<AnimatedOutputPoint>();
    private final List<AnimatedPoint> points = new ArrayList<AnimatedPoint>();
    private final List<AnimatedPoint> defaultPoints = new ArrayList<AnimatedPoint>();
    private final List<AnimatedPoint> mixedPoints = new ArrayList<AnimatedPoint>();
    private final OpenVector3f lastPivot = new OpenVector3f(0.0f, 0.0f, 0.0f);
    private final OpenVector3f lastTranslate = new OpenVector3f(0.0f, 0.0f, 0.0f);
    private final OpenVector3f lastRotation = new OpenVector3f(0.0f, 0.0f, 0.0f);
    private final OpenVector3f lastScale = new OpenVector3f(1.0f, 1.0f, 1.0f);
    protected AnimatedOutputPoint controller;
    protected AnimatedPoint snapshot;
    protected int dirty = 0;

    public AnimatedTransform(OpenTransform3f parent) {
        this.parent = parent;
        this.pivot = parent.pivot();
        this.afterTranslate = parent.afterTranslate();
    }

    @Nullable
    public static AnimatedTransform of(SkinPartTransform partTransform) {
        ITransform childTransform2;
        for (ITransform childTransform2 : partTransform.children()) {
            if (!(childTransform2 instanceof AnimatedTransform)) continue;
            AnimatedTransform animatedTransform = (AnimatedTransform)childTransform2;
            return animatedTransform;
        }
        childTransform2 = partTransform.parent();
        if (!(childTransform2 instanceof OpenTransform3f)) {
            return null;
        }
        OpenTransform3f parent = (OpenTransform3f)childTransform2;
        AnimatedTransform animatedTransform = new AnimatedTransform(parent);
        partTransform.replaceChild(parent, animatedTransform);
        return animatedTransform;
    }

    public void link(AnimatedOutputPoint point) {
        this.pendingPoints.add(point);
        this.pendingPoints.sort(Comparator.comparingInt(it -> it.mode().priority()));
        this.points.clear();
        this.defaultPoints.clear();
        this.mixedPoints.clear();
        this.points.addAll(this.pendingPoints);
        this.defaultPoints.addAll(Collections.filter(this.pendingPoints, it -> !it.mode().isMixMode()));
        this.mixedPoints.addAll(Collections.filter(this.pendingPoints, it -> it.mode().isMixMode()));
    }

    @Override
    public void apply(IPoseStack poseStack) {
        OpenVector3f scale;
        OpenVector3f translate = this.translation();
        if (translate != OpenVector3f.ZERO) {
            poseStack.translate(translate.x(), translate.y(), translate.z());
        }
        OpenVector3f pivot = this.pivot();
        OpenVector3f rotation = this.rotation();
        if (rotation != OpenVector3f.ZERO) {
            if (pivot != OpenVector3f.ZERO) {
                poseStack.translate(pivot.x(), pivot.y(), pivot.z());
            }
            poseStack.rotate(OpenQuaternionf.fromEulerAnglesZYX(rotation, true));
            if (pivot != OpenVector3f.ZERO) {
                poseStack.translate(-pivot.x(), -pivot.y(), -pivot.z());
            }
        }
        if ((scale = this.scale()) != OpenVector3f.ONE) {
            if (pivot != OpenVector3f.ZERO) {
                poseStack.translate(pivot.x(), pivot.y(), pivot.z());
            }
            poseStack.scale(scale.x(), scale.y(), scale.z());
            if (pivot != OpenVector3f.ZERO) {
                poseStack.translate(-pivot.x(), -pivot.y(), -pivot.z());
            }
        }
        if (this.afterTranslate != OpenVector3f.ZERO) {
            poseStack.translate(this.afterTranslate.x(), this.afterTranslate.y(), this.afterTranslate.z());
        }
    }

    public void export(AnimatedPoint value) {
        value.clear();
        this.exportTranslate(value);
        this.exportRotation(value);
        this.exportScale(value);
    }

    private void exportTranslate(AnimatedPoint result) {
        OpenVector3f base = this.parent.translate();
        OpenVector3f delta = OpenVector3f.ZERO;
        for (AnimatedPoint point : this.points) {
            OpenVector3f value = point.translation();
            if (value == OpenVector3f.ZERO) continue;
            delta = value;
        }
        result.setTranslation(base.x() + delta.x(), base.y() + delta.y(), base.z() + delta.z());
    }

    private void exportRotation(AnimatedPoint result) {
        OpenVector3f base = this.parent.rotation();
        OpenVector3f delta = OpenVector3f.ZERO;
        for (AnimatedPoint point : this.defaultPoints) {
            OpenVector3f value = point.rotation();
            if (value == OpenVector3f.ZERO) continue;
            delta = value;
        }
        if (this.controller != null) {
            delta = this.controller.rotation();
            base = OpenVector3f.ZERO;
        }
        float x = base.x() + delta.x();
        float y = base.y() + delta.y();
        float z = base.z() + delta.z();
        for (AnimatedPoint point : this.mixedPoints) {
            OpenVector3f value = point.rotation();
            if (value == OpenVector3f.ZERO) continue;
            x += value.x();
            y += value.y();
            z += value.z();
        }
        result.setRotation(OpenMath.wrapDegrees(x), OpenMath.wrapDegrees(y), OpenMath.wrapDegrees(z));
    }

    private void exportScale(AnimatedPoint result) {
        OpenVector3f base = this.parent.scale();
        OpenVector3f delta = OpenVector3f.ONE;
        for (AnimatedPoint point : this.points) {
            OpenVector3f value = point.scale();
            if (value == OpenVector3f.ONE) continue;
            delta = value;
        }
        result.setScale(base.x() * delta.x(), base.y() * delta.y(), base.z() * delta.z());
    }

    public void clear() {
        this.points.forEach(AnimatedPoint::clear);
        this.dirty = 0;
    }

    public void reset() {
        this.snapshot = null;
    }

    public void setDirty(int flags) {
        this.dirty |= flags;
    }

    public void setController(AnimatedOutputPoint controller) {
        this.controller = controller;
    }

    public AnimatedOutputPoint controller() {
        return this.controller;
    }

    public OpenTransform3f parent() {
        return this.parent;
    }

    public OpenVector3f translation() {
        if (this.snapshot != null) {
            return this.snapshot.translation();
        }
        return this.parent.translate();
    }

    public OpenVector3f rotation() {
        if (this.snapshot != null) {
            return this.snapshot.rotation();
        }
        if (this.controller != null) {
            return this.controller.rotation();
        }
        return this.parent.rotation();
    }

    public OpenVector3f scale() {
        if (this.snapshot != null) {
            return this.snapshot.scale();
        }
        return this.parent.scale();
    }

    public OpenVector3f pivot() {
        return this.pivot;
    }
}

