/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.gui.widget;

import com.apple.library.coregraphics.CGGraphicsContext;
import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.coregraphics.CGSize;
import com.apple.library.foundation.NSIndexPath;
import com.apple.library.foundation.NSString;
import com.apple.library.uikit.UIControl;
import com.apple.library.uikit.UIFont;
import com.apple.library.uikit.UIImage;
import com.apple.library.uikit.UIImageView;
import com.apple.library.uikit.UIResponder;
import com.apple.library.uikit.UIScrollView;
import com.apple.library.uikit.UITableView;
import com.apple.library.uikit.UITableViewCell;
import com.apple.library.uikit.UITableViewDataSource;
import com.apple.library.uikit.UITableViewDelegate;
import com.apple.library.uikit.UIView;
import com.apple.library.uikit.UIWindow;
import java.util.ArrayList;
import java.util.Collection;
import moe.plushie.armourers_workshop.api.core.math.IPoseStack;
import moe.plushie.armourers_workshop.api.library.ISkinLibrary;
import moe.plushie.armourers_workshop.api.skin.property.ISkinProperties;
import moe.plushie.armourers_workshop.api.skin.serializer.ISkinFileHeader;
import moe.plushie.armourers_workshop.compatibility.client.AbstractBufferSource;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.bake.SkinBakery;
import moe.plushie.armourers_workshop.core.client.gui.widget.ScrollIndicator;
import moe.plushie.armourers_workshop.core.client.render.ExtendedItemRenderer;
import moe.plushie.armourers_workshop.core.data.ticket.TicketHolder;
import moe.plushie.armourers_workshop.core.math.OpenMath;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.core.skin.serializer.SkinFile;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintScheme;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.ModTextures;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import moe.plushie.armourers_workshop.init.platform.ItemTooltipManager;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class SkinFileList<T extends SkinFile>
extends UIControl
implements UITableViewDataSource,
UITableViewDelegate {
    private final EntryList tableView = new EntryList(CGRect.ZERO);
    private final EntryListIndicator scrollIndicator = new EntryListIndicator(new CGRect(0.0f, 0.0f, 10.0f, 100.0f));
    private final TicketHolder tickets = new TicketHolder("SkinFileList");
    private final ArrayList<Entry> cells = new ArrayList();
    private Entry selectedItem;

    public SkinFileList(CGRect frame) {
        super(frame);
        this.setup();
    }

    private void setup() {
        CGRect bounds = this.bounds();
        UIImageView bg1 = new UIImageView(new CGRect(0.0f, 0.0f, bounds.width - 10.0f, bounds.height));
        bg1.setImage(UIImage.of(ModTextures.LIST).fixed(11.0f, 11.0f).clip(1.0f, 1.0f, 1.0f, 1.0f).build());
        bg1.setAutoresizingMask(18);
        this.addSubview(bg1);
        this.tableView.setRowHeight(14);
        this.tableView.setShowsVerticalScrollIndicator(false);
        this.tableView.setDelegate(this);
        this.tableView.setDataSource(this);
        this.tableView.setFrame(bg1.frame().insetBy(1.0f, 1.0f, 1.0f, 1.0f));
        this.tableView.setAutoresizingMask(18);
        this.addSubview(this.tableView);
        this.scrollIndicator.forwardingResponder = this.tableView;
        this.scrollIndicator.setFrame(new CGRect(bounds.width - 10.0f, 0.0f, 10.0f, bounds.height));
        this.scrollIndicator.setAutoresizingMask(17);
        this.scrollIndicator.addTarget(this, UIControl.Event.VALUE_CHANGED, SkinFileList::updateContentOffsetIfNeeded);
        this.addSubview(this.scrollIndicator);
    }

    public void reloadData(Collection<T> entries) {
        this.tickets.invalidate();
        this.cells.clear();
        entries.forEach(entry -> this.cells.add(new Entry(this, entry)));
        this.tableView.reloadData();
        this.tableView.setContentOffset(this.tableView.contentOffset());
    }

    @Override
    public void removeFromSuperview() {
        super.removeFromSuperview();
        this.tickets.invalidate();
    }

    @Override
    public int tableViewNumberOfRowsInSection(UITableView tableView, int section) {
        return this.cells.size();
    }

    @Override
    public UITableViewCell tableViewCellForRow(UITableView tableView, NSIndexPath indexPath) {
        return this.cells.get(indexPath.row);
    }

    @Override
    public void tableViewDidSelectRow(UITableView tableView, NSIndexPath indexPath) {
        tableView.deselectRow(indexPath, false);
        this.selectedItem = this.entryAtIndex(indexPath.row);
        this.sendEvent(UIControl.Event.VALUE_CHANGED);
    }

    @Override
    public void scrollViewDidScroll(UIScrollView scrollView) {
        this.updateProgressIfNeeded();
    }

    @Override
    protected boolean shouldPassHighlighted() {
        return false;
    }

    @Nullable
    public T selectedItem() {
        if (this.selectedItem != null) {
            return this.selectedItem.entry;
        }
        return null;
    }

    public void setSelectedItem(ISkinLibrary.Entry entry) {
        this.selectedItem = this.findEntry(entry);
        this.sendEvent(UIControl.Event.VALUE_CHANGED);
    }

    public CGPoint contentOffset() {
        return this.tableView.contentOffset();
    }

    public void setContentOffset(CGPoint contentOffset) {
        this.tableView.setContentOffset(contentOffset);
    }

    private void updateContentOffsetIfNeeded(UIControl sender) {
        CGPoint offset = this.tableView.contentOffset();
        CGSize size = this.tableView.contentSize();
        float value = (size.height - this.tableView.frame().height()) * this.scrollIndicator.value();
        if (offset.y != value) {
            this.tableView.setContentOffset(new CGPoint(offset.x, value));
        }
    }

    private void updateProgressIfNeeded() {
        CGPoint offset = this.tableView.contentOffset();
        CGSize size = this.tableView.contentSize();
        float value = 0.0f;
        float height = size.height - this.tableView.frame().height();
        if (offset.y != 0.0f && height > 0.0f) {
            value = offset.y / height;
        }
        this.scrollIndicator.setValue(value);
    }

    private Entry findEntry(ISkinLibrary.Entry entry) {
        if (entry == null) {
            return null;
        }
        for (Entry cell : this.cells) {
            if (!cell.entry.equals(entry)) continue;
            return cell;
        }
        return null;
    }

    public SkinFile itemAtIndex(int index) {
        Entry entry = this.entryAtIndex(index);
        if (entry != null) {
            return entry.entry;
        }
        return null;
    }

    private Entry entryAtIndex(int index) {
        if (index >= 0 && index < this.cells.size()) {
            return this.cells.get(index);
        }
        return null;
    }

    public static class EntryList
    extends UITableView {
        public EntryList(CGRect frame) {
            super(frame);
        }

        @Override
        public void layerDidDraw(CGGraphicsContext context) {
            super.layerDidDraw(context);
            EnvironmentManager.getClient().method_22940().method_23000().method_22993();
        }
    }

    public static class EntryListIndicator
    extends ScrollIndicator {
        public UIView forwardingResponder;

        public EntryListIndicator(CGRect frame) {
            super(frame);
        }

        @Override
        public UIResponder nextResponder() {
            if (this.forwardingResponder != null) {
                return this.forwardingResponder;
            }
            return super.nextResponder();
        }
    }

    public static class Entry
    extends UITableViewCell {
        private final NSString title;
        private final T entry;
        private final UIFont font;
        private final UIView iconView;
        private SkinDescriptor descriptor;
        private String securityData;
        final /* synthetic */ SkinFileList this$0;

        public Entry(T entry) {
            this.this$0 = this$0;
            super(CGRect.ZERO);
            this.font = UIFont.systemFont(7.0f);
            this.iconView = new UIView(CGRect.ZERO);
            this.descriptor = SkinDescriptor.EMPTY;
            this.title = new NSString(((SkinFile)entry).name());
            this.entry = entry;
            if (!((SkinFile)entry).isDirectory() && ((SkinFile)entry).skinIdentifier() != null) {
                this.descriptor = new SkinDescriptor(((SkinFile)entry).skinIdentifier(), ((SkinFile)entry).skinType(), SkinPaintScheme.EMPTY);
                this.securityData = this.getSecurityData(((SkinFile)entry).skinHeader());
            }
            this.iconView.setFrame(new CGRect(0.0f, 0.0f, 16.0f, 14.0f));
            this.addSubview(this.iconView);
        }

        @Override
        public void render(CGPoint point, CGGraphicsContext context) {
            float left = 0.0f;
            float top = 0.0f;
            float width = this.bounds().width();
            float height = this.bounds().height();
            int textColor = -5592406;
            int backgroundColor = 0;
            int iconOffset = 0;
            if (this.isHighlighted()) {
                textColor = -16777216;
                backgroundColor = -3355444;
            }
            if (((SkinFile)this.entry).isDirectory()) {
                textColor = -7798904;
            }
            if (((SkinFile)this.entry).isPrivateDirectory()) {
                textColor = -7829249;
            }
            if (this.securityData != null) {
                textColor = -30584;
            }
            if (this.this$0.selectedItem == this) {
                textColor = -16777216;
                backgroundColor = -120;
            }
            iconOffset = 16;
            if (backgroundColor != 0) {
                context.fillRect(left, top, left + width, top + height, backgroundColor);
            }
            context.drawText(this.title, left + (float)iconOffset + 2.0f, top + 3.0f, textColor);
            this.renderIcon(context, left, top - 1.0f, 16.0f, 16.0f);
        }

        public void renderIcon(CGGraphicsContext context, float x, float y, float width, float height) {
            if (((SkinFile)this.entry).isDirectory()) {
                int u = ((SkinFile)this.entry).isPrivateDirectory() ? 32 : 16;
                context.drawResizableImage(ModTextures.LIST, x + (width - 12.0f) / 2.0f, y + (height - 12.0f) / 2.0f, 12.0f, 12.0f, u, 0.0f, 16.0f, 16.0f, 256.0f, 256.0f);
                return;
            }
            SkinDescriptor descriptor = this.descriptor();
            if (descriptor.isEmpty()) {
                int u = 48;
                context.drawResizableImage(ModTextures.LIST, x + (width - 12.0f) / 2.0f, y + (height - 12.0f) / 2.0f, 12.0f, 12.0f, u, 0.0f, 16.0f, 16.0f, 256.0f, 256.0f);
                return;
            }
            BakedSkin bakedSkin = SkinBakery.getInstance().loadSkin(this.this$0.tickets.get(descriptor));
            if (bakedSkin == null) {
                return;
            }
            AbstractBufferSource buffers = AbstractBufferSource.buffer();
            ExtendedItemRenderer.renderSkinInGUI(bakedSkin, x, y, 100.0f, width, height - 1.0f, 20.0f, 45.0f, 0.0f, context.state().ctm(), buffers);
        }

        public void renderTooltip(CGRect rect, CGGraphicsContext context) {
            UIWindow window = this.window();
            if (window == null) {
                return;
            }
            if (this.securityData != null) {
                context.drawTooltip(NSString.localizedString("skin-library.rollover.canNotPreview", new Object[0]), rect);
                return;
            }
            BakedSkin bakedSkin = SkinBakery.getInstance().loadSkin(this.this$0.tickets.get(this.descriptor()));
            if (bakedSkin == null) {
                return;
            }
            CGRect bounds = window.bounds();
            CGPoint point = this.convertPointToView(CGPoint.ZERO, null);
            float size = 144.0f;
            float dx = point.x - size - 5.0f;
            float dy = OpenMath.clamp(context.state().mousePos().y() - size / 2.0f, 0.0f, bounds.height - size);
            context.drawTilableImage(ModTextures.GUI_PREVIEW, dx, dy, size, size, 0.0f, 0.0f, 62.0f, 62.0f, 4.0f, 4.0f, 4.0f, 4.0f);
            ArrayList<NSString> tooltips = Collections.compactMap(ItemTooltipManager.createSkinInfo(bakedSkin), NSString::new);
            context.drawMultilineText(tooltips, dx + 4.0f, dy + 4.0f, size - 8.0f, -1, true, this.font, 0.0f);
            IPoseStack poseStack = context.state().ctm();
            AbstractBufferSource buffers = AbstractBufferSource.buffer();
            ExtendedItemRenderer.renderSkinInGUI(bakedSkin, dx, dy, 100.0f, size, size, 30.0f, 45.0f, 0.0f, poseStack, buffers);
            buffers.endBatch();
        }

        @Override
        public void didMoveToWindow() {
            super.didMoveToWindow();
            if (!this.descriptor.isEmpty() && this.window() != null) {
                this.iconView.setTooltip(this::renderTooltip);
            } else {
                this.iconView.setTooltip(null);
            }
        }

        public SkinDescriptor descriptor() {
            if (!ModConfig.Common.allowLibraryPreviews) {
                return SkinDescriptor.EMPTY;
            }
            if (this.securityData != null) {
                return SkinDescriptor.EMPTY;
            }
            return this.descriptor;
        }

        public String getSecurityData(ISkinFileHeader header) {
            ISkinProperties properties;
            if (header != null && (properties = header.properties()) != null) {
                return properties.get(SkinProperty.SECURITY_DATA);
            }
            return null;
        }
    }
}

