/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.other;

import java.util.HashMap;
import java.util.Iterator;
import moe.plushie.armourers_workshop.api.client.model.IModel;
import moe.plushie.armourers_workshop.api.event.client.AddRendererLayerEvent;
import moe.plushie.armourers_workshop.api.event.client.RemoveRendererLayerEvent;
import moe.plushie.armourers_workshop.compatibility.client.model.AbstractModelHolder;
import moe.plushie.armourers_workshop.core.armature.ArmatureTransformer;
import moe.plushie.armourers_workshop.core.armature.ArmatureTransformerManager;
import moe.plushie.armourers_workshop.core.client.bake.BakedArmatureTransformer;
import moe.plushie.armourers_workshop.core.client.layer.SkinWardrobeLayer;
import moe.plushie.armourers_workshop.core.client.skinrender.SkinRendererManager;
import moe.plushie.armourers_workshop.core.data.DataContainer;
import moe.plushie.armourers_workshop.core.entity.EntityProfile;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.init.platform.EventManager;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_583;
import net.minecraft.class_897;
import net.minecraft.class_922;
import org.jetbrains.annotations.Nullable;

public class EntityRendererContext {
    private int version = 0;
    private class_1299<?> entityType;
    private EntityProfile entityProfile;
    private final class_897<?> entityRenderer;
    private final HashMap<class_583<?>, BakedArmatureTransformer> cachedTransformers = new HashMap();

    public EntityRendererContext(class_897<?> entityRenderer) {
        this.entityRenderer = entityRenderer;
    }

    public static EntityRendererContext of(class_897<?> entityRenderer) {
        return DataContainer.of(entityRenderer, EntityRendererContext::new);
    }

    @Nullable
    public BakedArmatureTransformer createTransformer(@Nullable IModel entityModel, ArmatureTransformerManager transformerManager) {
        if (this.entityType == null || this.entityProfile == null) {
            return null;
        }
        ArmatureTransformer transformer = transformerManager.getTransformer(this.entityType, this.entityProfile, entityModel);
        if (transformer != null) {
            return BakedArmatureTransformer.create(transformer, this.entityRenderer);
        }
        return null;
    }

    @Nullable
    public BakedArmatureTransformer getTransformer(@Nullable class_583<?> entityModel) {
        if (this.entityType == null || this.entityProfile == null) {
            return null;
        }
        if (entityModel == null) {
            entityModel = this.entityModel();
        }
        return this.cachedTransformers.computeIfAbsent(entityModel, entityModel1 -> {
            Object model = AbstractModelHolder.ofNullable(entityModel1);
            return this.createTransformer((IModel)model, SkinRendererManager.DEFAULT);
        });
    }

    public void setEntityType(class_1299<?> entityType) {
        this.entityType = entityType;
    }

    public class_1299<?> entityType() {
        return this.entityType;
    }

    public void setEntityProfile(EntityProfile entityProfile) {
        if (Objects.equals(this.entityProfile, entityProfile)) {
            return;
        }
        EntityProfile oldValue = this.entityProfile;
        this.cachedTransformers.clear();
        this.entityProfile = entityProfile;
        ++this.version;
        class_897<?> class_8972 = this.entityRenderer;
        if (class_8972 instanceof class_922) {
            class_922 livingEntityRenderer = (class_922)class_8972;
            if (oldValue == null && entityProfile != null) {
                this.addLayer(livingEntityRenderer);
            }
            if (oldValue != null && entityProfile == null) {
                this.removeLayer(livingEntityRenderer);
            }
        }
    }

    public EntityProfile entityProfile() {
        return this.entityProfile;
    }

    public class_583<?> entityModel() {
        class_897<?> class_8972 = this.entityRenderer;
        if (class_8972 instanceof class_3883) {
            class_3883 modelProvider = (class_3883)class_8972;
            return modelProvider.method_4038();
        }
        return null;
    }

    public int version() {
        return this.version;
    }

    private <T extends class_1309, V extends class_583<T>> void addLayer(class_922<T, V> livingRenderer) {
        this.removeLayer(livingRenderer);
        BakedArmatureTransformer transformer = this.getTransformer(null);
        if (transformer != null) {
            SkinWardrobeLayer layer = new SkinWardrobeLayer(transformer, livingRenderer);
            livingRenderer.field_4738.add(0, layer);
            this.didAddLayer(layer, livingRenderer);
        }
    }

    private <T extends class_1309, V extends class_583<T>> void removeLayer(class_922<T, V> livingRenderer) {
        Iterator iterator = livingRenderer.field_4738.iterator();
        while (iterator.hasNext()) {
            class_3887 layer = (class_3887)iterator.next();
            if (!(layer instanceof SkinWardrobeLayer)) continue;
            iterator.remove();
            this.didRemoveLayer(layer, livingRenderer);
        }
    }

    private <T extends class_1309, V extends class_583<T>> void didAddLayer(final class_3887<T, V> layer, final class_922<T, V> renderer) {
        EventManager.post(AddRendererLayerEvent.class, new AddRendererLayerEvent<T, V>(){

            @Override
            public class_3887<T, V> getLayer() {
                return layer;
            }

            @Override
            public class_922<T, V> getRenderer() {
                return renderer;
            }
        });
    }

    private <T extends class_1309, V extends class_583<T>> void didRemoveLayer(final class_3887<T, V> layer, final class_922<T, V> renderer) {
        EventManager.post(RemoveRendererLayerEvent.class, new RemoveRendererLayerEvent<T, V>(){

            @Override
            public class_3887<T, V> getLayer() {
                return layer;
            }

            @Override
            public class_922<T, V> getRenderer() {
                return renderer;
            }
        });
    }
}

