/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.render;

import moe.plushie.armourers_workshop.api.client.IVertexConsumer;
import moe.plushie.armourers_workshop.api.core.math.IPoseStack;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintType;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintTypes;
import moe.plushie.armourers_workshop.core.utils.OpenDirection;

public class ExtendedFaceRenderer {
    private static final float[][] FACE_MARK_TEXTURES = new float[][]{{0.998f, 0.998f}, {0.998f, 0.0f}, {0.0f, 0.0f}, {0.0f, 0.998f}};
    private static final float[][][] FACE_MARK_VERTEXES = new float[][][]{new float[][]{{0.0f, 0.0f, 1.0f}, {0.0f, 0.0f, 0.0f}, {1.0f, 0.0f, 0.0f}, {1.0f, 0.0f, 1.0f}, {0.0f, -1.0f, 0.0f}}, new float[][]{{1.0f, 1.0f, 1.0f}, {1.0f, 1.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {0.0f, 1.0f, 1.0f}, {0.0f, 1.0f, 0.0f}}, new float[][]{{0.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {1.0f, 1.0f, 0.0f}, {1.0f, 0.0f, 0.0f}, {0.0f, 0.0f, -1.0f}}, new float[][]{{1.0f, 0.0f, 1.0f}, {1.0f, 1.0f, 1.0f}, {0.0f, 1.0f, 1.0f}, {0.0f, 0.0f, 1.0f}, {0.0f, 0.0f, 1.0f}}, new float[][]{{0.0f, 0.0f, 1.0f}, {0.0f, 1.0f, 1.0f}, {0.0f, 1.0f, 0.0f}, {0.0f, 0.0f, 0.0f}, {-1.0f, 0.0f, 0.0f}}, new float[][]{{1.0f, 0.0f, 0.0f}, {1.0f, 1.0f, 0.0f}, {1.0f, 1.0f, 1.0f}, {1.0f, 0.0f, 1.0f}, {1.0f, 0.0f, 0.0f}}};

    public static void renderMarker(int x, int y, int z, OpenDirection direction, SkinPaintColor paintColor, int alpha, int light, int overlay, IPoseStack poseStack, IVertexConsumer builder) {
        if (paintColor.paintType() == SkinPaintTypes.NORMAL) {
            return;
        }
        IPoseStack.Pose pose = poseStack.last();
        SkinPaintType paintType = paintColor.paintType();
        int u = paintType.ordinal() % 8;
        int v = paintType.ordinal() / 8;
        float[][] vertexes = FACE_MARK_VERTEXES[direction.get3DDataValue()];
        for (int i = 0; i < 4; ++i) {
            builder.vertex(pose, (float)x + vertexes[i][0], (float)y + vertexes[i][1], (float)z + vertexes[i][2]).color(255, 255, 255, alpha & 0xFF).uv(((float)u + FACE_MARK_TEXTURES[i][0]) / 8.0f, ((float)v + FACE_MARK_TEXTURES[i][1]) / 8.0f).overlayCoords(overlay).uv2(light).normal(pose, vertexes[4][0], vertexes[4][1], vertexes[4][2]).endVertex();
        }
    }

    public static void render2(int x, int y, int z, OpenDirection direction, SkinPaintColor paintColor, int alpha, int light, int overlay, IPoseStack poseStack, IVertexConsumer builder) {
        IPoseStack.Pose entry = poseStack.last();
        boolean u = false;
        boolean v = false;
        int color = paintColor.argb();
        float[][] vertexes = FACE_MARK_VERTEXES[direction.get3DDataValue()];
        for (int i = 0; i < 4; ++i) {
            builder.vertex(entry, (float)x + vertexes[i][0], (float)y + vertexes[i][1], (float)z + vertexes[i][2]).color(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, alpha & 0xFF).uv((float)u + FACE_MARK_TEXTURES[i][0], (float)v + FACE_MARK_TEXTURES[i][1]).overlayCoords(overlay).uv2(light).normal(entry, vertexes[4][0], vertexes[4][1], vertexes[4][2]).endVertex();
        }
    }
}

