/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.render;

import com.apple.library.uikit.UIColor;
import moe.plushie.armourers_workshop.api.client.IBufferSource;
import moe.plushie.armourers_workshop.api.core.math.IPoseStack;
import moe.plushie.armourers_workshop.compatibility.client.AbstractBufferSource;
import moe.plushie.armourers_workshop.compatibility.client.AbstractModelViewStack;
import moe.plushie.armourers_workshop.compatibility.client.AbstractPoseStack;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.other.EntityRenderData;
import moe.plushie.armourers_workshop.core.client.other.PlaceholderManager;
import moe.plushie.armourers_workshop.core.client.other.SkinItemSource;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderTesselator;
import moe.plushie.armourers_workshop.core.entity.MannequinEntity;
import moe.plushie.armourers_workshop.core.math.OpenMatrix4f;
import moe.plushie.armourers_workshop.core.math.OpenQuaternionf;
import moe.plushie.armourers_workshop.core.math.OpenRectangle3f;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.core.skin.texture.EntityTextureDescriptor;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintScheme;
import moe.plushie.armourers_workshop.core.utils.TickUtils;
import moe.plushie.armourers_workshop.init.ModDebugger;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import moe.plushie.armourers_workshop.utils.RenderSystem;
import moe.plushie.armourers_workshop.utils.ShapeTesselator;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_238;
import net.minecraft.class_898;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public final class ExtendedItemRenderer {
    public static void renderSkinInGUI(BakedSkin bakedSkin, float x, float y, float z, float width, float height, float rx, float ry, float rz, IPoseStack poseStack, IBufferSource bufferSource) {
        ExtendedItemRenderer.renderSkinInBox(bakedSkin, SkinPaintScheme.EMPTY, class_1799.field_8037, OpenVector3f.ONE, x, y, z, width, height, rx, ry, rz, 0.0f, 0xF000F0, 0, poseStack, bufferSource);
    }

    public static void renderSkinInGUI(BakedSkin bakedSkin, SkinPaintScheme scheme, class_1799 itemStack, float x, float y, float z, float width, float height, float rx, float ry, float rz, float partialTicks, int light, IPoseStack poseStack, IBufferSource bufferSource) {
        ExtendedItemRenderer.renderSkinInBox(bakedSkin, scheme, itemStack, OpenVector3f.ONE, x, y, z, width, height, rx, ry, rz, partialTicks, light, 0, poseStack, bufferSource);
    }

    public static void renderSkinInTooltip(BakedSkin bakedSkin, SkinPaintScheme scheme, class_1799 itemStack, float x, float y, float z, float width, float height, float rx, float ry, float rz, float partialTicks, int light, IPoseStack poseStack, IBufferSource bufferSource) {
        ExtendedItemRenderer.renderSkinInBox(bakedSkin, scheme, itemStack, OpenVector3f.ONE, x, y, z, width, height, rx, ry, rz, partialTicks, light, 0, poseStack, bufferSource);
    }

    public static int renderSkinInBox(BakedSkin bakedSkin, SkinPaintScheme scheme, float partialTicks, int light, SkinItemSource itemSource, IPoseStack poseStack, IBufferSource bufferSource) {
        return ExtendedItemRenderer.renderSkinInBox(bakedSkin, scheme, OpenVector3f.ONE, partialTicks, light, 0, itemSource, poseStack, bufferSource);
    }

    public static int renderSkinInBox(BakedSkin bakedSkin, SkinPaintScheme scheme, float partialTicks, int light, int outlineColor, SkinItemSource itemSource, IPoseStack poseStack, IBufferSource bufferSource) {
        return ExtendedItemRenderer.renderSkinInBox(bakedSkin, scheme, OpenVector3f.ONE, partialTicks, light, outlineColor, itemSource, poseStack, bufferSource);
    }

    private static void renderSkinInBox(BakedSkin bakedSkin, SkinPaintScheme scheme, class_1799 itemStack, @Nullable OpenVector3f targetBox, float x, float y, float z, float width, float height, float rx, float ry, float rz, float partialTicks, int light, int outlineColor, IPoseStack poseStack, IBufferSource bufferSource) {
        if (bakedSkin == null) {
            return;
        }
        double t = TickUtils.animationTicks();
        float si = Math.min(width, height);
        poseStack.pushPose();
        poseStack.translate(x + width / 2.0f, y + height / 2.0f, z);
        poseStack.scale(1.0f, -1.0f, 1.0f);
        poseStack.rotate(OpenVector3f.XP.rotationDegrees(rx));
        poseStack.rotate(OpenVector3f.YP.rotationDegrees(ry + (float)(t * 100.0 % 360.0)));
        poseStack.scale(0.625f, 0.625f, 0.625f);
        poseStack.scale(si, si, si);
        ExtendedItemRenderer.renderSkinInBox(bakedSkin, scheme, targetBox, partialTicks, light, outlineColor, SkinItemSource.create(itemStack), poseStack, bufferSource);
        poseStack.popPose();
    }

    private static int renderSkinInBox(BakedSkin bakedSkin, SkinPaintScheme scheme, @Nullable OpenVector3f targetBox, float partialTicks, int light, int outlineColor, SkinItemSource itemSource, IPoseStack poseStack, IBufferSource bufferSource) {
        int counter = 0;
        SkinRenderTesselator tesselator = SkinRenderTesselator.create(bakedSkin);
        if (tesselator == null) {
            return counter;
        }
        poseStack.pushPose();
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        tesselator.setLightmap(light);
        tesselator.setPartialTicks(partialTicks);
        tesselator.setRenderData(EntityRenderData.of((class_1297)tesselator.mannequin()));
        tesselator.setColorScheme(scheme);
        tesselator.setItemSource(itemSource);
        tesselator.setUseItemTransforms(true);
        tesselator.setOutlineColor(outlineColor);
        tesselator.setDisplayBox(targetBox);
        tesselator.setDisplayContext(itemSource.displayContext());
        float f = 0.0625f;
        poseStack.scale(f, f, f);
        tesselator.setPoseStack(poseStack);
        tesselator.setBufferSource(bufferSource);
        tesselator.setModelViewStack(AbstractModelViewStack.getInstance());
        counter = tesselator.draw();
        poseStack.popPose();
        return counter;
    }

    public static void renderMannequin(EntityTextureDescriptor descriptor, OpenVector3f rotation, float targetWidth, float targetHeight, float targetDepth, float partialTicks, int light, IPoseStack poseStack, IBufferSource bufferSource) {
        MannequinEntity entity = PlaceholderManager.MANNEQUIN.get();
        if (entity == null || entity.method_37908() == null) {
            return;
        }
        poseStack.pushPose();
        poseStack.rotate(OpenVector3f.YP.rotationDegrees(180.0f));
        if (!descriptor.equals(entity.getTextureDescriptor())) {
            entity.setTextureDescriptor(descriptor);
        }
        class_238 aabb = entity.method_5829();
        OpenRectangle3f rect = new OpenRectangle3f(aabb.field_1323, aabb.field_1322, aabb.field_1321, aabb.method_17939(), aabb.method_17940(), aabb.method_17941());
        if (ModDebugger.targetBounds) {
            ShapeTesselator.stroke(-targetWidth / 2.0f, -targetHeight / 2.0f, -targetDepth / 2.0f, targetWidth / 2.0f, targetHeight / 2.0f, targetDepth / 2.0f, UIColor.ORANGE, poseStack, bufferSource);
            ShapeTesselator.vector(0.0f, 0.0f, 0.0f, targetWidth, targetHeight, targetDepth, poseStack, bufferSource);
        }
        OpenRectangle3f resolvedRect = rect.offset(rect.midX(), rect.midY(), rect.midZ());
        resolvedRect.mul(new OpenMatrix4f(new OpenQuaternionf(rotation.x(), rotation.y(), rotation.z(), true)));
        float newScale = Math.min(targetWidth / resolvedRect.width(), targetHeight / resolvedRect.height());
        poseStack.scale(newScale, newScale, newScale);
        poseStack.translate(-rect.midX(), -rect.midY(), -rect.midZ());
        class_898 rendererManager = EnvironmentManager.getClient().method_1561();
        RenderSystem.runAsFancy(() -> rendererManager.method_3954((class_1297)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, AbstractPoseStack.unwrap(poseStack), AbstractBufferSource.unwrap(bufferSource), light));
        poseStack.popPose();
    }
}

