/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.shader;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.api.client.IRenderType;
import moe.plushie.armourers_workshop.core.client.shader.ShaderVertexGroup;
import moe.plushie.armourers_workshop.core.client.shader.ShaderVertexObject;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class ShaderVertexMerger {
    private int maxVertexCount = 0;
    private final ArrayList<ShaderVertexGroup> sortedGroups = new ArrayList();
    private final HashMap<IRenderType, ShaderVertexGroup> pending = new HashMap();

    public void add(ShaderVertexObject pass) {
        ShaderVertexGroup group = this.pending.get(pass.type());
        if (group == null) {
            group = this.addAndSort(pass.type());
            this.pending.put(pass.type(), group);
        }
        group.add(pass);
        this.maxVertexCount = Math.max(this.maxVertexCount, pass.total());
    }

    public void forEach(Consumer<ShaderVertexGroup> consumer) {
        for (ShaderVertexGroup group : this.sortedGroups) {
            if (group.isEmpty()) continue;
            group.maxVertexCount = this.maxVertexCount;
            consumer.accept(group);
        }
    }

    public void prepare() {
    }

    public void reset() {
        this.pending.forEach((? super K renderType, ? super V group) -> group.clear());
        this.maxVertexCount = 0;
    }

    public void clear() {
        this.sortedGroups.clear();
        this.pending.clear();
    }

    public int size() {
        int total = 0;
        for (ShaderVertexGroup group : this.pending.values()) {
            total += group.size();
        }
        return total;
    }

    public boolean isEmpty() {
        return this.maxVertexCount == 0;
    }

    private ShaderVertexGroup addAndSort(IRenderType type) {
        ShaderVertexGroup group = new ShaderVertexGroup(type);
        this.sortedGroups.add(group);
        this.sortedGroups.sort(Comparator.comparing(this::getRenderOrder));
        return group;
    }

    private int getRenderOrder(ShaderVertexGroup group) {
        int index = group.renderType().ordinal();
        if (index > 0) {
            return index;
        }
        return Integer.MAX_VALUE;
    }
}

