/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.sound;

import io.netty.buffer.ByteBuf;
import java.util.LinkedHashMap;
import java.util.Map;
import moe.plushie.armourers_workshop.api.skin.sound.ISkinSoundProvider;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.sounds.SoundEvent.Constructor;
import moe.plushie.armourers_workshop.core.client.other.SmartResourceManager;
import moe.plushie.armourers_workshop.core.client.sound.SmartSoundManager;
import moe.plushie.armourers_workshop.core.data.DataContainer;
import moe.plushie.armourers_workshop.core.skin.sound.SkinSoundData;
import moe.plushie.armourers_workshop.core.skin.sound.SkinSoundProperties;
import moe.plushie.armourers_workshop.core.utils.OpenRandomSource;
import moe.plushie.armourers_workshop.core.utils.OpenResourceLocation;
import moe.plushie.armourers_workshop.core.utils.ReferenceCounted;
import moe.plushie.armourers_workshop.init.ModConstants;
import moe.plushie.armourers_workshop.utils.RenderSystem;
import net.minecraft.class_3414;

public class SmartSound
extends ReferenceCounted {
    private final String name;
    private final OpenResourceLocation location;
    private final SkinSoundProperties properties;
    private final Map<OpenResourceLocation, ByteBuf> soundBuffers;
    private class_3414 soundEvent;

    public SmartSound(SkinSoundData provider) {
        this.name = provider.name();
        this.properties = provider.properties();
        this.location = ModConstants.key("sounds/dynamic/" + OpenRandomSource.nextInt(SmartSound.class) + ".ogg");
        this.soundBuffers = this.resolveSoundBuffers(this.location, provider);
    }

    public static SmartSound of(class_3414 soundEvent) {
        return DataContainer.getOrDefault(soundEvent, null);
    }

    @Override
    protected void init() {
        RenderSystem.safeCall(() -> {
            this.soundBuffers.forEach(SmartResourceManager.getInstance()::register);
            SmartSoundManager.getInstance().uploadSound(this);
        });
    }

    @Override
    protected void dispose() {
        RenderSystem.safeCall(() -> {
            SmartSoundManager.getInstance().releaseSound(this);
            this.soundBuffers.keySet().forEach(SmartResourceManager.getInstance()::unregister);
        });
    }

    public String name() {
        return this.name;
    }

    public OpenResourceLocation location() {
        return this.location;
    }

    public class_3414 soundEvent() {
        if (this.soundEvent == null) {
            this.soundEvent = Constructor.createVariableRangeEvent(class_3414.class, this.location.toLocation());
            DataContainer.set(this.soundEvent, this);
        }
        return this.soundEvent;
    }

    protected void unbind() {
        DataContainer.set(this.soundEvent, null);
        while (this.refCnt() > 0) {
            this.release();
        }
    }

    private Map<OpenResourceLocation, ByteBuf> resolveSoundBuffers(OpenResourceLocation location, ISkinSoundProvider provider) {
        LinkedHashMap<OpenResourceLocation, ByteBuf> results = new LinkedHashMap<OpenResourceLocation, ByteBuf>();
        results.put(location, provider.buffer());
        return results;
    }
}

