/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.data;

import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.Entity.Fix1619;
import moe.plushie.armourers_workshop.core.data.EntityDataStorage;
import moe.plushie.armourers_workshop.core.data.action.EntityAction;
import moe.plushie.armourers_workshop.core.data.action.EntityActionSet;
import moe.plushie.armourers_workshop.core.skin.part.wings.WingPartTransform;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1452;
import net.minecraft.class_1496;
import net.minecraft.class_1690;
import net.minecraft.class_4050;
import org.jetbrains.annotations.Nullable;

public class EntityAnimationState
extends EntityActionSet {
    private class_1297 transitingVehicle = null;
    private TransitingMode transitingMode = null;

    @Nullable
    public static EntityAnimationState of(@Nullable class_1297 entity) {
        if (entity != null) {
            return EntityDataStorage.of(entity).animationState().orElse(null);
        }
        return null;
    }

    public void startRiding(class_1297 target) {
        this.transitingVehicle = target;
        this.transitingMode = TransitingMode.UP;
    }

    public void stopRiding(class_1297 target) {
        this.transitingVehicle = target;
        this.transitingMode = TransitingMode.DOWN;
    }

    public void tick(class_1297 entity) {
        class_1309 livingEntity;
        this.flags.clear();
        if (entity.method_7325()) {
            return;
        }
        class_1297 vehicle = entity.method_5854();
        if (vehicle == null) {
            vehicle = this.transitingVehicle;
        }
        boolean onGround = Fix1619.onGround(entity) || entity.method_5740();
        double dx = entity.method_23317() - entity.field_6038;
        double dy = entity.method_23318() - entity.field_5971;
        double dz = entity.method_23321() - entity.field_5989;
        boolean isWalk = dx * dx + dz * dz > 2.5E-7;
        boolean isWalkUp = dy > 1.0E-7;
        boolean isWalkDown = dy < -1.0E-7;
        boolean isSprinting = entity.method_5624();
        boolean isCrouching = entity.method_18276();
        if (vehicle != null) {
            this.set(EntityAction.RIDING, true);
            this.set(EntityAction.RIDING_WALK, isWalk);
            this.set(EntityAction.RIDING_BOOST, isWalk && isSprinting);
            this.set(EntityAction.RIDING_UP, this.transitingMode == TransitingMode.UP);
            this.set(EntityAction.RIDING_DOWN, this.transitingMode == TransitingMode.DOWN);
            this.set(EntityAction.RIDING_BOAT, this.isBoat(vehicle));
            this.set(EntityAction.RIDING_PIG, this.isPig(vehicle));
            this.set(EntityAction.RIDING_HORSE, this.isHorse(vehicle));
            if (this.transitingMode != null && entity.method_18376() != class_4050.field_18081) {
                this.transitingVehicle = null;
                this.transitingMode = null;
            }
            return;
        }
        if (entity instanceof class_1309 && this.isFlying(livingEntity = (class_1309)entity)) {
            this.set(EntityAction.FLYING, true);
            this.set(EntityAction.FLYING_WALK, isWalk);
            this.set(EntityAction.FLYING_BOOST, isWalk && isSprinting);
            this.set(EntityAction.FLYING_UP, isWalkUp);
            this.set(EntityAction.FLYING_DOWN, isWalkDown);
            this.set(EntityAction.FLYING_FALL, livingEntity.method_6128());
            return;
        }
        if (entity.method_5799()) {
            this.set(EntityAction.SWIMMING, true);
            this.set(EntityAction.SWIMMING_WALK, isWalk);
            this.set(EntityAction.SWIMMING_BOOST, entity.method_5681());
            this.set(EntityAction.SWIMMING_UP, isWalkUp);
            this.set(EntityAction.SWIMMING_DOWN, isWalkDown && !onGround);
            return;
        }
        if (entity.method_18376() == class_4050.field_18079) {
            this.set(EntityAction.CRAWLING, true);
            this.set(EntityAction.CRAWLING_WALK, isWalk);
            return;
        }
        if (entity instanceof class_1309 && (livingEntity = (class_1309)entity).method_6101()) {
            this.set(EntityAction.CLIMBING, true);
            this.set(EntityAction.CLIMBING_WALK, isWalk);
            this.set(EntityAction.CLIMBING_UP, isWalkUp && !onGround);
            this.set(EntityAction.CLIMBING_DOWN, isWalkDown && !onGround && !isCrouching);
            this.set(EntityAction.CLIMBING_HOLD, isCrouching && !onGround && !isWalkUp);
            return;
        }
        this.set(EntityAction.WALK, isWalk);
        this.set(EntityAction.RUNNING, isSprinting);
        this.set(EntityAction.SNEAK, isCrouching);
        this.set(EntityAction.JUMP, !onGround);
    }

    private boolean isFlying(class_1309 entity) {
        return WingPartTransform.isFlying(entity);
    }

    private boolean isBoat(class_1297 entity) {
        return entity instanceof class_1690;
    }

    private boolean isPig(class_1297 entity) {
        return entity instanceof class_1452;
    }

    private boolean isHorse(class_1297 entity) {
        return entity instanceof class_1496;
    }

    public static enum TransitingMode {
        UP,
        DOWN;

    }
}

