/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.data;

import java.lang.ref.WeakReference;
import java.util.List;
import moe.plushie.armourers_workshop.api.core.IDataSerializer;
import moe.plushie.armourers_workshop.api.core.IDataSerializerKey;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.Entity.CustomCollisionProvider;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import moe.plushie.armourers_workshop.core.data.EntityCollisionShape;
import moe.plushie.armourers_workshop.core.data.SkinContainerEvaluator;
import moe.plushie.armourers_workshop.core.math.OpenRectangle3f;
import moe.plushie.armourers_workshop.core.network.UpdateWardrobePacket;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import org.jetbrains.annotations.Nullable;

public class EntityCollisionContainer {
    private final WeakReference<class_1297> entity;
    private final SkinContainerEvaluator evaluator;
    private EntityCollisionShape result;

    public EntityCollisionContainer(class_1277 container, class_1297 entity) {
        this.entity = new WeakReference<class_1297>(entity);
        this.evaluator = this.createIfNeeded(container, entity);
    }

    public void deserialize(IDataSerializer serializer) {
        this.setResult(serializer.read(CodingKeys.COLLISION_SHAPE));
        if (this.evaluator != null) {
            this.evaluator.reset();
        }
    }

    public void serialize(IDataSerializer serializer) {
        serializer.write(CodingKeys.COLLISION_SHAPE, this.result);
    }

    public void beginUpdates() {
        if (this.evaluator != null) {
            this.evaluator.beginUpdates();
        }
    }

    public void endUpdates() {
        if (this.evaluator != null) {
            this.evaluator.endUpdates();
        }
    }

    public void setResult(EntityCollisionShape boundingBox) {
        EntityCollisionShape oldValue = this.result;
        this.result = boundingBox;
        if (Objects.equals(oldValue, boundingBox)) {
            return;
        }
        class_1297 entity1 = (class_1297)this.entity.get();
        if (entity1 != null) {
            CustomCollisionProvider.setCustomCollision(entity1, this.result);
        }
    }

    public EntityCollisionShape result() {
        return this.result;
    }

    private void reload(List<Skin> skins) {
        EntityCollisionShape newResult = this.resolve(skins);
        if (!Objects.equals(newResult, this.result)) {
            ModLog.debug("{} reload collision shape: {}", this.entity.get(), newResult);
            this.setResult(newResult);
            this.sendChanges();
        }
    }

    @Nullable
    private EntityCollisionShape resolve(List<Skin> skins) {
        for (Skin skin : skins) {
            List<OpenRectangle3f> boundingBox;
            if (skin.type() == SkinTypes.BLOCK || (boundingBox = skin.settings().collisionBox()) == null || boundingBox.isEmpty()) continue;
            return EntityCollisionShape.size(boundingBox.get(0));
        }
        return null;
    }

    private void sendChanges() {
        class_1297 entity1 = (class_1297)this.entity.get();
        if (entity1 == null) {
            return;
        }
        SkinWardrobe wardrobe = SkinWardrobe.of(entity1);
        if (wardrobe == null) {
            return;
        }
        EntityCollisionShape result = this.result();
        NetworkManager.sendToTracking(UpdateWardrobePacket.Field.WARDROBE_COLLISION_SHAPE.buildPacket(wardrobe, result), entity1);
    }

    private SkinContainerEvaluator createIfNeeded(class_1277 container, class_1297 entity) {
        class_1937 level = entity.method_37908();
        if (level == null || level.method_8608()) {
            return null;
        }
        SkinContainerEvaluator evaluator = new SkinContainerEvaluator(container);
        evaluator.addListener(this::reload);
        return evaluator;
    }

    private static class CodingKeys {
        public static final IDataSerializerKey<EntityCollisionShape> COLLISION_SHAPE = IDataSerializerKey.create("Collisions", EntityCollisionShape.CODEC, null);

        private CodingKeys() {
        }
    }
}

