/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.item;

import java.util.List;
import java.util.function.BiConsumer;
import moe.plushie.armourers_workshop.api.common.IItemModelProperty;
import moe.plushie.armourers_workshop.api.common.IItemPropertiesProvider;
import moe.plushie.armourers_workshop.api.common.IItemTintColorProvider;
import moe.plushie.armourers_workshop.api.common.ITooltipContext;
import moe.plushie.armourers_workshop.api.core.IDataComponentType;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.ComponentAPI;
import moe.plushie.armourers_workshop.core.data.paint.IItemPaintable;
import moe.plushie.armourers_workshop.core.data.paint.IPaintProvider;
import moe.plushie.armourers_workshop.core.data.paint.IPaintToolPicker;
import moe.plushie.armourers_workshop.core.item.FlavouredItem;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintTypes;
import moe.plushie.armourers_workshop.core.utils.ColorUtils;
import moe.plushie.armourers_workshop.core.utils.OpenDirection;
import moe.plushie.armourers_workshop.core.utils.TranslateUtils;
import moe.plushie.armourers_workshop.init.ModConstants;
import moe.plushie.armourers_workshop.init.ModDataComponents;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1269;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;

public class BottleItem
extends FlavouredItem
implements IItemTintColorProvider,
IItemPropertiesProvider,
IItemPaintable,
IPaintToolPicker {
    public BottleItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public class_1269 method_7884(class_1838 context) {
        return this.usePickTool(context);
    }

    @Override
    public class_1269 usePickTool(class_1937 level, class_2338 pos, OpenDirection dir, class_2586 blockEntity, class_1838 context) {
        class_1799 itemStack = context.method_8041();
        if (blockEntity instanceof IPaintProvider) {
            IPaintProvider provider = (IPaintProvider)blockEntity;
            this.setItemColor(itemStack, provider.color());
            return class_1269.method_29236((boolean)level.method_8608());
        }
        return class_1269.field_5811;
    }

    public boolean method_7886(class_1799 itemStack) {
        SkinPaintColor paintColor = this.getItemColor(itemStack);
        if (paintColor != null) {
            return paintColor.paintType() != SkinPaintTypes.NORMAL;
        }
        return false;
    }

    @Override
    public void setItemColor(class_1799 itemStack, SkinPaintColor paintColor) {
        ComponentAPI.set(itemStack, (IDataComponentType)ModDataComponents.TOOL_COLOR.get(), paintColor);
    }

    @Override
    public SkinPaintColor getItemColor(class_1799 itemStack) {
        return (SkinPaintColor)ComponentAPI.get(itemStack, (IDataComponentType)ModDataComponents.TOOL_COLOR.get());
    }

    @Override
    public int getTintColor(class_1799 itemStack, int index) {
        if (index == 1) {
            return ColorUtils.getDisplayRGB(itemStack);
        }
        return -1;
    }

    @Override
    public void createModelProperties(BiConsumer<IResourceLocation, IItemModelProperty> builder) {
        builder.accept(ModConstants.key("empty"), (itemStack, level, entity, id) -> ComponentAPI.has(itemStack, (IDataComponentType)ModDataComponents.TOOL_COLOR.get()) ? 0.0f : 1.0f);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void appendHoverText(class_1799 itemStack, List<class_2561> tooltips, ITooltipContext context) {
        super.appendHoverText(itemStack, tooltips, context);
        SkinPaintColor paintColor = this.getItemColor(itemStack);
        if (paintColor != null) {
            tooltips.addAll(ColorUtils.getColorTooltips(paintColor, false));
        } else {
            tooltips.add((class_2561)TranslateUtils.subtitle("item.armourers_workshop.rollover.empty", new Object[0]));
        }
    }
}

