/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.item;

import java.util.List;
import moe.plushie.armourers_workshop.api.common.IEntityType;
import moe.plushie.armourers_workshop.api.common.ITooltipContext;
import moe.plushie.armourers_workshop.api.core.IDataComponentType;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.ComponentAPI;
import moe.plushie.armourers_workshop.core.data.MannequinHitResult;
import moe.plushie.armourers_workshop.core.entity.MannequinEntity;
import moe.plushie.armourers_workshop.core.item.FlavouredItem;
import moe.plushie.armourers_workshop.core.skin.texture.EntityTextureDescriptor;
import moe.plushie.armourers_workshop.core.utils.TranslateUtils;
import moe.plushie.armourers_workshop.init.ModDataComponents;
import moe.plushie.armourers_workshop.init.ModEntityTypes;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3730;

public class MannequinItem
extends FlavouredItem {
    public MannequinItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public static boolean isSmall(class_1799 itemStack) {
        class_2487 entityTag = (class_2487)ComponentAPI.get(itemStack, (IDataComponentType)ModDataComponents.ENTITY_DATA.get());
        if (entityTag != null) {
            MannequinEntity.EntityData entityData = new MannequinEntity.EntityData(entityTag);
            return entityData.isSmall();
        }
        return false;
    }

    public static float getScale(class_1799 itemStack) {
        class_2487 entityTag = (class_2487)ComponentAPI.get(itemStack, (IDataComponentType)ModDataComponents.ENTITY_DATA.get());
        if (entityTag != null) {
            MannequinEntity.EntityData entityData = new MannequinEntity.EntityData(entityTag);
            return entityData.scale();
        }
        return 1.0f;
    }

    public class_1269 method_7884(class_1838 context) {
        if (context.method_20287() != class_1268.field_5808) {
            return class_1269.field_5814;
        }
        class_1657 player = context.method_8036();
        if (player == null) {
            return class_1269.field_5814;
        }
        class_1937 level = context.method_8045();
        class_243 origin = new class_243(player.method_23317(), player.method_23318(), player.method_23321());
        MannequinHitResult rayTraceResult = MannequinHitResult.test(player, origin, context.method_17698(), context.method_8037());
        class_1799 itemStack = context.method_8041();
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            MannequinEntity entity = (MannequinEntity)((IEntityType)ModEntityTypes.MANNEQUIN.get()).create(serverLevel, rayTraceResult.method_17777(), itemStack, class_3730.field_16465);
            if (entity == null) {
                return class_1269.field_5814;
            }
            class_243 clickedLocation = rayTraceResult.method_17784();
            entity.method_5641(clickedLocation.method_10216(), clickedLocation.method_10214(), clickedLocation.method_10215(), 0.0f, 0.0f);
            entity.method_5636(rayTraceResult.rotation());
            serverLevel.method_8649((class_1297)entity);
            serverLevel.method_8465(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), class_3417.field_14969, class_3419.field_15245, 0.75f, 0.8f);
            itemStack.method_7934(1);
            return class_1269.method_29236((boolean)serverLevel.method_8608());
        }
        return class_1269.field_5814;
    }

    public String method_7866(class_1799 itemStack) {
        float scale = MannequinItem.getScale(itemStack);
        if (scale <= 0.5f) {
            return super.method_7866(itemStack) + ".small";
        }
        if (scale >= 2.0f) {
            return super.method_7866(itemStack) + ".big";
        }
        return super.method_7866(itemStack);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void appendHoverText(class_1799 itemStack, List<class_2561> tooltips, ITooltipContext context) {
        super.appendHoverText(itemStack, tooltips, context);
        EntityTextureDescriptor descriptor = EntityTextureDescriptor.of(itemStack);
        if (descriptor.name() != null) {
            tooltips.add((class_2561)TranslateUtils.subtitle("item.armourers_workshop.rollover.user", descriptor.name()));
        }
        if (descriptor.url() != null) {
            tooltips.add((class_2561)TranslateUtils.subtitle("item.armourers_workshop.rollover.url", descriptor.url()));
        }
    }
}

