/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.geometry;

import java.util.LinkedHashMap;
import moe.plushie.armourers_workshop.api.core.IRegistryHolder;
import moe.plushie.armourers_workshop.core.skin.geometry.SkinGeometryType;
import moe.plushie.armourers_workshop.core.utils.OpenResourceLocation;
import moe.plushie.armourers_workshop.init.ModBlocks;
import moe.plushie.armourers_workshop.init.ModLog;
import net.minecraft.class_2248;

public final class SkinGeometryTypes {
    private static final SkinGeometryType[] ALL_GEOMETRY_TYPE_MAPPING = new SkinGeometryType[256];
    private static final LinkedHashMap<String, SkinGeometryType> ALL_GEOMETRY_TYPES = new LinkedHashMap();
    public static final SkinGeometryType BLOCK_SOLID = SkinGeometryTypes.register("solid", 0, ModBlocks.SKIN_CUBE);
    public static final SkinGeometryType BLOCK_GLOWING = SkinGeometryTypes.register("glowing", 1, ModBlocks.SKIN_CUBE_GLOWING);
    public static final SkinGeometryType BLOCK_GLASS = SkinGeometryTypes.register("glass", 2, ModBlocks.SKIN_CUBE_GLASS);
    public static final SkinGeometryType BLOCK_GLASS_GLOWING = SkinGeometryTypes.register("glass_glowing", 3, ModBlocks.SKIN_CUBE_GLASS_GLOWING);
    public static final SkinGeometryType CUBE = SkinGeometryTypes.register("cube", 4, ModBlocks.BOUNDING_BOX);
    public static final SkinGeometryType CUBE_CULL = SkinGeometryTypes.register("cube_cull", 6, ModBlocks.BOUNDING_BOX);
    public static final SkinGeometryType MESH = SkinGeometryTypes.register("mesh", 5, ModBlocks.BOUNDING_BOX);
    public static final SkinGeometryType MESH_CULL = SkinGeometryTypes.register("mesh_cull", 7, ModBlocks.BOUNDING_BOX);

    public static SkinGeometryType byName(String name) {
        SkinGeometryType cube = ALL_GEOMETRY_TYPES.get(name);
        if (cube != null) {
            return cube;
        }
        return BLOCK_SOLID;
    }

    public static SkinGeometryType byId(int index) {
        SkinGeometryType cubeType = ALL_GEOMETRY_TYPE_MAPPING[index & 0xFF];
        if (cubeType != null) {
            return cubeType;
        }
        return BLOCK_SOLID;
    }

    public static SkinGeometryType byBlock(class_2248 block) {
        for (SkinGeometryType cubeType : ALL_GEOMETRY_TYPES.values()) {
            if (cubeType.block() != block) continue;
            return cubeType;
        }
        return BLOCK_SOLID;
    }

    public static boolean isGlassBlock(SkinGeometryType geometryType) {
        return geometryType == BLOCK_GLASS || geometryType == BLOCK_GLASS_GLOWING;
    }

    public static boolean isGlowingBlock(SkinGeometryType geometryType) {
        return geometryType == BLOCK_GLOWING || geometryType == BLOCK_GLASS_GLOWING;
    }

    private static SkinGeometryType register(String name, int id, IRegistryHolder<class_2248> block) {
        SkinGeometryType geometryType = new SkinGeometryType(id, block);
        geometryType.setRegistryName(OpenResourceLocation.create("armourers", name));
        if (ALL_GEOMETRY_TYPES.containsKey(geometryType.registryName().toString())) {
            ModLog.warn("A mod tried to register a geometry type with an id that is in use.", new Object[0]);
            return geometryType;
        }
        ALL_GEOMETRY_TYPES.put(geometryType.registryName().toString(), geometryType);
        SkinGeometryTypes.ALL_GEOMETRY_TYPE_MAPPING[geometryType.id() & 0xFF] = geometryType;
        ModLog.debug("Registering Skin Geometry '{}'", geometryType.registryName());
        return geometryType;
    }

    public static int getTotalCubes() {
        return ALL_GEOMETRY_TYPES.size();
    }
}

