/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.molang.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.DoubleSupplier;
import moe.plushie.armourers_workshop.core.skin.molang.core.Name;
import moe.plushie.armourers_workshop.core.skin.molang.runtime.MathHelper;

public class Result
implements BooleanSupplier,
DoubleSupplier {
    public static final Result NULL = new Result(Type.NULL, 0.0, null, null, null, null);
    public static final Result ONE = new Result(Type.NUMBER, 1.0, null, null, null, null);
    public static final Result ZERO = new Result(Type.NUMBER, 0.0, null, null, null, null);
    private final Type type;
    private final double doubleValue;
    private final String stringValue;
    private final List<Result> arrayValue;
    private final Map<Name, Result> structValue;
    private final Object referenceValue;

    public Result(Type type, double doubleValue, String stringValue, List<Result> arrayValue, Map<Name, Result> structValue, Object referenceValue) {
        this.type = type;
        this.doubleValue = doubleValue;
        this.stringValue = stringValue;
        this.arrayValue = arrayValue;
        this.structValue = structValue;
        this.referenceValue = referenceValue;
    }

    public static Result newArray() {
        return Result.valueOf(new ArrayList<Result>());
    }

    public static Result newStruct() {
        return Result.valueOf(new HashMap<Name, Result>());
    }

    public static Result parse(Object value) {
        if (value == null) {
            return NULL;
        }
        if (value instanceof Result) {
            Result result = (Result)value;
            return result;
        }
        if (value instanceof Boolean) {
            Boolean boolValue = (Boolean)value;
            return Result.valueOf(boolValue);
        }
        if (value instanceof Double) {
            Double doubleValue = (Double)value;
            return Result.valueOf(doubleValue);
        }
        if (value instanceof String) {
            String stringValue = (String)value;
            return Result.valueOf(stringValue);
        }
        if (value instanceof Number) {
            Number numberValue = (Number)value;
            return Result.valueOf(numberValue.doubleValue());
        }
        if (value instanceof List) {
            List arrayValue = (List)value;
            return Result.valueOf(arrayValue);
        }
        if (value instanceof Map) {
            Map structValue = (Map)value;
            return Result.valueOf(structValue);
        }
        return Result.wrap(value);
    }

    public static Result valueOf(boolean value) {
        if (value) {
            return ONE;
        }
        return ZERO;
    }

    public static Result valueOf(double value) {
        return new Result(Type.NUMBER, value, null, null, null, null);
    }

    public static Result valueOf(String value) {
        return new Result(Type.STRING, 0.0, value, null, null, null);
    }

    public static Result valueOf(List<Result> array) {
        return new Result(Type.ARRAY, 0.0, null, array, null, null);
    }

    public static Result valueOf(Map<Name, Result> struct) {
        return new Result(Type.STRUCT, 0.0, null, null, struct, null);
    }

    public static Result wrap(Object reference) {
        return new Result(Type.REFERENCE, 0.0, null, null, null, reference);
    }

    public Result copy() {
        if (this.arrayValue != null) {
            ArrayList<Result> newArrayValue = new ArrayList<Result>(this.arrayValue.size());
            for (Result element : this.arrayValue) {
                newArrayValue.add(element.copy());
            }
            return Result.valueOf(newArrayValue);
        }
        if (this.structValue != null) {
            HashMap<Name, Result> newStructValue = new HashMap<Name, Result>(this.structValue.size());
            for (Map.Entry<Name, Result> element : this.structValue.entrySet()) {
                newStructValue.put(element.getKey(), element.getValue().copy());
            }
            return Result.valueOf(newStructValue);
        }
        return this;
    }

    public boolean notEquals(Object o) {
        return !this.equals(o);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Result)) {
            return false;
        }
        Result that = (Result)o;
        if (this.type != that.type) {
            return false;
        }
        return switch (this.type.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> true;
            case 1 -> {
                if (Double.compare(this.doubleValue, that.doubleValue) == 0) {
                    yield true;
                }
                yield false;
            }
            case 2 -> Objects.equals(this.stringValue, that.stringValue);
            case 3 -> Objects.equals(this.arrayValue, that.arrayValue);
            case 4 -> Objects.equals(this.structValue, that.structValue);
            case 5 -> Objects.equals(this.referenceValue, that.referenceValue);
        };
    }

    public int hashCode() {
        int hash = switch (this.type.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> 0;
            case 1 -> Objects.hash(this.doubleValue);
            case 2 -> Objects.hash(this.stringValue);
            case 3 -> Objects.hash(this.arrayValue);
            case 4 -> Objects.hash(this.structValue);
            case 5 -> Objects.hash(this.referenceValue);
        };
        hash = 31 * hash + this.type.hashCode();
        return hash;
    }

    public String toString() {
        return switch (this.type.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> "<null>";
            case 1 -> String.format("%s", this.doubleValue);
            case 2 -> String.format("'%s'", this.stringValue);
            case 3 -> String.format("%s", this.arrayValue);
            case 4 -> String.format("%s", this.structValue);
            case 5 -> String.format("%s", this.referenceValue);
        };
    }

    @Override
    public double getAsDouble() {
        return this.doubleValue;
    }

    @Override
    public boolean getAsBoolean() {
        return this.doubleValue != 0.0;
    }

    public int getAsInt() {
        return MathHelper.floor(this.doubleValue);
    }

    public String getAsString() {
        if (this.stringValue != null) {
            return this.stringValue;
        }
        return this.toString();
    }

    public Object getAsReference() {
        return this.referenceValue;
    }

    public Type type() {
        return this.type;
    }

    public boolean isValid() {
        return this.type != Type.NULL;
    }

    public boolean isNull() {
        return this.type == Type.NULL;
    }

    public boolean isNumber() {
        return this.type == Type.NUMBER;
    }

    public boolean isString() {
        return this.type == Type.STRING;
    }

    public boolean isArray() {
        return this.type == Type.ARRAY;
    }

    public boolean isStruct() {
        return this.type == Type.STRUCT;
    }

    public void set(int index, Result value) {
        if (this.arrayValue != null && !this.arrayValue.isEmpty()) {
            this.arrayValue.set(Math.max(index, 0) % this.arrayValue.size(), value);
        }
    }

    public Result get(int index) {
        if (this.arrayValue != null && !this.arrayValue.isEmpty()) {
            return this.arrayValue.get(Math.max(index, 0) % this.arrayValue.size());
        }
        return NULL;
    }

    public void set(Name name, Result value) {
        if (this.structValue != null) {
            this.structValue.put(name, value);
        }
    }

    public Result get(Name name) {
        if (this.structValue != null) {
            return this.structValue.getOrDefault(name, NULL);
        }
        return NULL;
    }

    public int size() {
        if (this.arrayValue != null) {
            return this.arrayValue.size();
        }
        if (this.structValue != null) {
            return this.structValue.size();
        }
        return 0;
    }

    public static enum Type {
        NULL,
        NUMBER,
        STRING,
        ARRAY,
        STRUCT,
        REFERENCE;

    }
}

