/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.molang.runtime;

import java.util.Arrays;
import moe.plushie.armourers_workshop.core.skin.molang.core.Result;
import moe.plushie.armourers_workshop.core.skin.molang.runtime.Scope;

public class LocalVariableStorage {
    private Result[] elements;
    private final Scope scope = new Scope();

    public LocalVariableStorage() {
        this(16);
    }

    public LocalVariableStorage(int initialCapacity) {
        this.elements = new Result[Math.max(initialCapacity, 1)];
    }

    public Scope scope() {
        return this.scope;
    }

    public void setVariable(int address, Result value) {
        this.ensureCapacity(address + 1);
        this.elements[address] = value;
    }

    public Result getVariable(int address) {
        this.ensureCapacity(address + 1);
        Result result = this.elements[address];
        if (result == null) {
            result = Result.NULL;
        }
        return result;
    }

    private void ensureCapacity(int minCapacity) {
        if (this.elements.length < minCapacity) {
            int newSize = Math.max(this.elements.length * 2, minCapacity);
            this.elements = Arrays.copyOf(this.elements, newSize);
        }
    }
}

