/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.molang.runtime.function.builtin;

import java.util.List;
import moe.plushie.armourers_workshop.core.skin.molang.core.ExecutionContext;
import moe.plushie.armourers_workshop.core.skin.molang.core.Expression;
import moe.plushie.armourers_workshop.core.skin.molang.core.Result;
import moe.plushie.armourers_workshop.core.skin.molang.runtime.MathHelper;
import moe.plushie.armourers_workshop.core.skin.molang.runtime.Scope;
import moe.plushie.armourers_workshop.core.skin.molang.runtime.function.Function;

public final class Loop
extends Function {
    private final Expression count;
    private final Expression body;

    public Loop(Expression name, List<Expression> arguments) {
        super(name, 2, arguments);
        this.count = arguments.get(0);
        this.body = arguments.get(1);
    }

    @Override
    public double compute(ExecutionContext context) {
        return this.evaluate(context).getAsDouble();
    }

    @Override
    public Result evaluate(ExecutionContext context) {
        Scope scope = context.stack().scope().beginEnumerate();
        int total = MathHelper.floor(MathHelper.clamp(this.count.compute(context), 0.0, 1024.0));
        for (int i = 0; i < total; ++i) {
            this.body.evaluate(context);
            if (scope.isBreakOrReturn()) break;
        }
        return scope.endEnumerate();
    }

    public Expression count() {
        return this.count;
    }

    public Expression body() {
        return this.body;
    }
}

