/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.nbt.CompoundTag.OptionalAPI;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.nbt.NumericTag.ABI;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IInputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IOutputStream;
import moe.plushie.armourers_workshop.core.utils.Collections;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2494;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2503;
import net.minecraft.class_2514;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import org.jetbrains.annotations.Nullable;

public abstract class OpenProperties {
    protected final LinkedHashMap<String, Object> properties;

    public OpenProperties() {
        this(new LinkedHashMap<String, Object>());
    }

    public OpenProperties(LinkedHashMap<String, Object> properties) {
        this.properties = properties;
    }

    public void readFromStream(IInputStream stream) throws IOException {
        Serializer.DEFAULT.readFromStream(this, stream);
    }

    public void writeToStream(IOutputStream stream) throws IOException {
        Serializer.DEFAULT.writeToStream(this, stream);
    }

    public void readFromNBT(class_2487 nbt) {
        Serializer.DEFAULT.readFromNBT(this, nbt);
    }

    public void writeToNBT(class_2487 nbt) {
        Serializer.DEFAULT.writeToNBT(this, nbt);
    }

    public void put(String key, Object value) {
        if (value == null) {
            this.properties.remove(key);
        } else {
            this.properties.put(key, value);
        }
    }

    public void putAll(OpenProperties newValue) {
        this.properties.putAll(newValue.properties);
    }

    public void remove(String key) {
        this.properties.remove(key);
    }

    public void clear() {
        this.properties.clear();
    }

    public Object get(String key) {
        return this.properties.get(key);
    }

    public Object getOrDefault(String key, Object defaultValue) {
        return this.properties.getOrDefault(key, defaultValue);
    }

    public boolean containsKey(String key) {
        return this.properties.containsKey(key);
    }

    public boolean containsValue(String key) {
        return this.properties.containsValue(key);
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    public abstract OpenProperties copy();

    public abstract OpenProperties empty();

    public Set<Map.Entry<String, Object>> entrySet() {
        return this.properties.entrySet();
    }

    public class_2487 serializeNBT() {
        class_2487 tag = new class_2487();
        this.writeToNBT(tag);
        return tag;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OpenProperties)) {
            return false;
        }
        OpenProperties that = (OpenProperties)o;
        return this.properties.equals(that.properties);
    }

    public int hashCode() {
        return this.properties.hashCode();
    }

    public String toString() {
        return this.properties.toString();
    }

    private static class Serializer {
        private static final Serializer DEFAULT = new Serializer();
        private static final Serializer ONLY_VALUE = new Serializer(){

            @Override
            protected void writeTypeToStream(DataTypes dataTypes, IOutputStream stream) {
            }
        };

        private Serializer() {
        }

        protected void writeToStream(OpenProperties instance, IOutputStream stream) throws IOException {
            stream.writeInt(instance.properties.size());
            for (Map.Entry<String, Object> entry : instance.properties.entrySet()) {
                stream.writeString(entry.getKey());
                this.writeValueToStream(entry.getValue(), stream);
            }
        }

        protected void writeTypeToStream(DataTypes dataTypes, IOutputStream stream) throws IOException {
            stream.writeByte(dataTypes.ordinal());
        }

        protected void writeValueToStream(Object value, IOutputStream stream) throws IOException {
            if (value instanceof String) {
                String stringValue = (String)value;
                this.writeTypeToStream(DataTypes.STRING, stream);
                stream.writeString(stringValue);
            } else if (value instanceof Long) {
                Long longValue = (Long)value;
                this.writeTypeToStream(DataTypes.LONG, stream);
                stream.writeLong(longValue);
            } else if (value instanceof Integer) {
                Integer intValue = (Integer)value;
                this.writeTypeToStream(DataTypes.INT, stream);
                stream.writeInt(intValue);
            } else if (value instanceof Float) {
                Float floatValue = (Float)value;
                this.writeTypeToStream(DataTypes.FLOAT, stream);
                stream.writeFloat(floatValue.floatValue());
            } else if (value instanceof Double) {
                Double doubleValue = (Double)value;
                this.writeTypeToStream(DataTypes.DOUBLE, stream);
                stream.writeDouble(doubleValue);
            } else if (value instanceof Boolean) {
                Boolean boolValue = (Boolean)value;
                this.writeTypeToStream(DataTypes.BOOLEAN, stream);
                stream.writeBoolean(boolValue);
            } else if (value instanceof List) {
                List listValue = (List)value;
                this.writeTypeToStream(DataTypes.LIST, stream);
                stream.writeInt(listValue.size());
                Serializer serializer = DEFAULT;
                for (Object element : listValue) {
                    serializer.writeValueToStream(element, stream);
                    serializer = ONLY_VALUE;
                }
            } else if (value instanceof OpenProperties) {
                OpenProperties compoundValue = (OpenProperties)value;
                this.writeTypeToStream(DataTypes.COMPOUND, stream);
                compoundValue.writeToStream(stream);
            }
        }

        protected void readFromStream(OpenProperties instance, IInputStream stream) throws IOException {
            int size = stream.readInt();
            for (int i = 0; i < size; ++i) {
                String key = stream.readString();
                DataTypes type = this.readTypeFromStream(stream);
                instance.properties.put(key, this.readValueFromStream(instance, type, stream));
            }
        }

        protected DataTypes readTypeFromStream(IInputStream stream) throws IOException {
            byte byteType = stream.readByte();
            DataTypes type = DataTypes.byId(byteType);
            if (type == null) {
                throw new IOException("Error loading properties " + byteType);
            }
            return type;
        }

        protected Object readValueFromStream(OpenProperties instance, DataTypes type, IInputStream stream) throws IOException {
            return switch (type.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> stream.readString();
                case 1 -> stream.readInt();
                case 7 -> stream.readLong();
                case 6 -> Float.valueOf(stream.readFloat());
                case 2 -> stream.readDouble();
                case 3 -> stream.readBoolean();
                case 4 -> {
                    int size = stream.readInt();
                    if (size == 0) {
                        yield Collections.emptyList();
                    }
                    DataTypes elementType = this.readTypeFromStream(stream);
                    ArrayList<Object> elements = new ArrayList<Object>();
                    for (int i = 0; i < size; ++i) {
                        elements.add(this.readValueFromStream(instance, elementType, stream));
                    }
                    yield elements;
                }
                case 5 -> {
                    OpenProperties properties1 = instance.empty();
                    properties1.readFromStream(stream);
                    yield properties1;
                }
            };
        }

        protected void writeToNBT(OpenProperties instance, class_2487 nbt) {
            for (Map.Entry<String, Object> entry : instance.properties.entrySet()) {
                nbt.method_10566(entry.getKey(), this.writeValueToNbt(entry.getValue()));
            }
        }

        protected class_2520 writeValueToNbt(Object value) {
            if (value instanceof String) {
                String stringValue = (String)value;
                return class_2519.method_23256((String)stringValue);
            }
            if (value instanceof Long) {
                Long longValue = (Long)value;
                return class_2503.method_23251((long)longValue);
            }
            if (value instanceof Integer) {
                Integer intValue = (Integer)value;
                return class_2497.method_23247((int)intValue);
            }
            if (value instanceof Float) {
                Float floatValue = (Float)value;
                return class_2494.method_23244((float)floatValue.floatValue());
            }
            if (value instanceof Double) {
                Double doubleValue = (Double)value;
                return class_2489.method_23241((double)doubleValue);
            }
            if (value instanceof Boolean) {
                Boolean boolValue = (Boolean)value;
                return class_2481.method_23234((boolean)boolValue);
            }
            if (value instanceof List) {
                List listValue = (List)value;
                class_2499 listTag = new class_2499();
                for (Object element : listValue) {
                    listTag.add((Object)this.writeValueToNbt(element));
                }
                return listTag;
            }
            if (value instanceof OpenProperties) {
                OpenProperties compoundValue = (OpenProperties)value;
                class_2487 compoundTag = new class_2487();
                compoundValue.writeToNBT(compoundTag);
                return compoundTag;
            }
            return null;
        }

        protected void readFromNBT(OpenProperties instance, class_2487 nbt) {
            for (String key : OptionalAPI.keySet(nbt)) {
                instance.properties.put(key, this.readValueFromNBT(instance, nbt.method_10580(key)));
            }
        }

        protected Object readValueFromNBT(OpenProperties instance, Object value) {
            if (value instanceof class_2519) {
                class_2519 stringTag = (class_2519)value;
                return moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.nbt.StringTag.ABI.value(stringTag);
            }
            if (value instanceof class_2503) {
                class_2503 longTag = (class_2503)value;
                return ABI.longValue((class_2514)longTag);
            }
            if (value instanceof class_2497) {
                class_2497 intTag = (class_2497)value;
                return ABI.intValue((class_2514)intTag);
            }
            if (value instanceof class_2494) {
                class_2494 floatTag = (class_2494)value;
                return Float.valueOf(ABI.floatValue((class_2514)floatTag));
            }
            if (value instanceof class_2489) {
                class_2489 doubleTag = (class_2489)value;
                return ABI.doubleValue((class_2514)doubleTag);
            }
            if (value instanceof class_2481) {
                class_2481 byteTag = (class_2481)value;
                return ABI.byteValue((class_2514)byteTag) != 0;
            }
            if (value instanceof class_2499) {
                class_2499 listTag = (class_2499)value;
                ArrayList<Object> elements = new ArrayList<Object>();
                for (class_2520 element : listTag) {
                    elements.add(this.readValueFromNBT(instance, element));
                }
                return elements;
            }
            if (value instanceof class_2487) {
                class_2487 compoundTag = (class_2487)value;
                OpenProperties compoundValue = instance.empty();
                compoundValue.readFromNBT(compoundTag);
                return compoundValue;
            }
            return null;
        }
    }

    private static enum DataTypes {
        STRING,
        INT,
        DOUBLE,
        BOOLEAN,
        LIST,
        COMPOUND,
        FLOAT,
        LONG;


        @Nullable
        public static DataTypes byId(int id) {
            if (id >= 0 & id < DataTypes.values().length) {
                return DataTypes.values()[id];
            }
            return null;
        }
    }
}

