/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.utils;

import moe.plushie.armourers_workshop.core.utils.OpenDirection;

public enum OpenRotation {
    NONE("none"),
    CLOCKWISE_90("clockwise_90"),
    CLOCKWISE_180("180"),
    COUNTERCLOCKWISE_90("counterclockwise_90");

    private final String id;

    private OpenRotation(String id) {
        this.id = id;
    }

    public OpenRotation getRotated(OpenRotation rotation) {
        return switch (rotation.ordinal()) {
            case 2 -> {
                switch (this.ordinal()) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case 0: {
                        yield CLOCKWISE_180;
                    }
                    case 1: {
                        yield COUNTERCLOCKWISE_90;
                    }
                    case 2: {
                        yield NONE;
                    }
                    case 3: 
                }
                yield CLOCKWISE_90;
            }
            case 3 -> {
                switch (this.ordinal()) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case 0: {
                        yield COUNTERCLOCKWISE_90;
                    }
                    case 1: {
                        yield NONE;
                    }
                    case 2: {
                        yield CLOCKWISE_90;
                    }
                    case 3: 
                }
                yield CLOCKWISE_180;
            }
            case 1 -> {
                switch (this.ordinal()) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case 0: {
                        yield CLOCKWISE_90;
                    }
                    case 1: {
                        yield CLOCKWISE_180;
                    }
                    case 2: {
                        yield COUNTERCLOCKWISE_90;
                    }
                    case 3: 
                }
                yield NONE;
            }
            default -> this;
        };
    }

    public OpenDirection rotate(OpenDirection direction) {
        if (direction.axis() == OpenDirection.Axis.Y) {
            return direction;
        }
        return switch (this.ordinal()) {
            case 1 -> direction.clockWise();
            case 2 -> direction.opposite();
            case 3 -> direction.counterClockWise();
            default -> direction;
        };
    }

    public int rotate(int i, int j) {
        return switch (this.ordinal()) {
            case 1 -> (i + j / 4) % j;
            case 2 -> (i + j / 2) % j;
            case 3 -> (i + j * 3 / 4) % j;
            default -> i;
        };
    }
}

