/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init;

import com.apple.library.coregraphics.CGPoint;
import com.apple.library.uikit.UIImage;
import java.util.HashMap;
import moe.plushie.armourers_workshop.core.utils.OpenResourceLocation;
import moe.plushie.armourers_workshop.init.ModConstants;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class ModTextures {
    public static final OpenResourceLocation WARDROBE_1 = ModTextures.res("textures/gui/wardrobe/wardrobe-1.png");
    public static final OpenResourceLocation WARDROBE_2 = ModTextures.res("textures/gui/wardrobe/wardrobe-2.png");
    public static final OpenResourceLocation SKINNING_TABLE = ModTextures.res("textures/gui/skinning_table/skinning-table.png");
    public static final OpenResourceLocation DYE_TABLE = ModTextures.res("textures/gui/dye_table/dye-table.png");
    public static final OpenResourceLocation SKIN_LIBRARY = ModTextures.res("textures/gui/skin_library/armour-library.png");
    public static final OpenResourceLocation GLOBAL_SKIN_LIBRARY = ModTextures.res("textures/gui/global_library/global-library.png");
    public static final OpenResourceLocation COLOR_MIXER = ModTextures.res("textures/gui/colour_mixer/colour-mixer.png");
    public static final OpenResourceLocation OUTFIT_MAKER = ModTextures.res("textures/gui/outfit_maker/outfit-maker.png");
    public static final OpenResourceLocation ARMOURER = ModTextures.res("textures/gui/armourer/armourer.png");
    public static final OpenResourceLocation ADVANCED_SKIN_BUILDER = ModTextures.res("textures/gui/advanced_skin_builder/advanced-skin-builder.png");
    public static final OpenResourceLocation TABS = ModTextures.res("textures/gui/controls/tabs.png");
    public static final OpenResourceLocation COMMON = ModTextures.res("textures/gui/common.png");
    public static final OpenResourceLocation WIDGETS = ModTextures.res("textures/gui/widgets.png");
    public static final OpenResourceLocation MENUS = ModTextures.res("textures/gui/controls/menus.png");
    public static final OpenResourceLocation LIST = ModTextures.res("textures/gui/controls/list.png");
    public static final OpenResourceLocation RATING = ModTextures.res("textures/gui/controls/rating.png");
    public static final OpenResourceLocation TAB_ICONS = ModTextures.res("textures/gui/controls/tab_icons.png");
    public static final OpenResourceLocation HUE = ModTextures.res("textures/gui/controls/slider-hue.png");
    public static final OpenResourceLocation TOASTS = ModTextures.res("textures/gui/controls/toasts.png");
    public static final OpenResourceLocation BUTTONS = ModTextures.res("textures/gui/controls/buttons.png");
    public static final OpenResourceLocation HELP = ModTextures.res("textures/gui/controls/help.png");
    public static final OpenResourceLocation PLAYER_INVENTORY = ModTextures.res("textures/gui/player_inventory.png");
    public static final OpenResourceLocation CUBE = ModTextures.res("textures/armour/cube.png");
    public static final OpenResourceLocation LIGHTING_CUBE = ModTextures.res("textures/armour/glowcube.png");
    public static final OpenResourceLocation CIRCLE = ModTextures.res("textures/other/nanoha-circle.png");
    public static final OpenResourceLocation EARTH = ModTextures.res("textures/blockentity/global-skin-library.png");
    public static final OpenResourceLocation MANNEQUIN_DEFAULT = ModTextures.res("textures/entity/mannequin.png");
    public static final OpenResourceLocation MANNEQUIN_HIGHLIGHT = ModTextures.res("textures/entity/mannequin_h.png");
    public static final OpenResourceLocation HORSE_DEFAULT = ModTextures.res("textures/entity/horse.png");
    public static final OpenResourceLocation BOAT_DEFAULT = ModTextures.res("textures/entity/boat.png");
    public static final OpenResourceLocation MINECART_DEFAULT = ModTextures.res("textures/entity/minecart.png");
    public static final OpenResourceLocation GUI_PREVIEW = ModTextures.res("textures/gui/skin-preview.png");
    public static final OpenResourceLocation SKIN_PANEL = ModTextures.res("textures/gui/controls/skin-panel.png");
    public static final OpenResourceLocation SCROLLBAR = ModTextures.res("textures/gui/controls/scrollbar.png");
    public static final OpenResourceLocation MARKERS = ModTextures.res("textures/blockentity/markers.png");
    public static final OpenResourceLocation GUIDES = ModTextures.res("textures/block/guide.png");
    public static final OpenResourceLocation BLOCK_CUBE = ModTextures.res("textures/block/colourable/colourable.png");
    public static final OpenResourceLocation BLOCK_CUBE_GLASS = ModTextures.res("textures/block/colourable/colourable-glass.png");

    private static OpenResourceLocation res(String name) {
        return ModConstants.key(name);
    }

    public static UIImage defaultWindowImage() {
        return UIImage.of(COMMON).fixed(128.0f, 128.0f).clip(4.0f, 4.0f, 4.0f, 4.0f).build();
    }

    public static UIImage defaultButtonImage() {
        HashMap<Integer, CGPoint> offsets = new HashMap<Integer, CGPoint>();
        offsets.put(4, new CGPoint(0.0f, 0.0f));
        offsets.put(0, new CGPoint(0.0f, 1.0f));
        offsets.put(1, new CGPoint(0.0f, 2.0f));
        return UIImage.of(WIDGETS).uv(0.0f, 46.0f).fixed(200.0f, 20.0f).clip(4.0f, 4.0f, 4.0f, 4.0f).unzip(offsets::get).build();
    }

    public static UIImage defaultButtonImage(float u, float v) {
        return ModTextures.buttonImage(BUTTONS, u, v, 16.0f, 16.0f);
    }

    public static UIImage buttonImage(OpenResourceLocation texture, float u, float v, float width, float height) {
        HashMap<Integer, CGPoint> offsets = new HashMap<Integer, CGPoint>();
        offsets.put(0, new CGPoint(0.0f, 0.0f));
        offsets.put(1, new CGPoint(1.0f, 0.0f));
        offsets.put(2, new CGPoint(2.0f, 0.0f));
        offsets.put(3, new CGPoint(3.0f, 0.0f));
        offsets.put(4, new CGPoint(3.0f, 0.0f));
        return UIImage.of(texture).uv(u, v).fixed(width, height).unzip(offsets::get).build();
    }

    public static UIImage iconImage(float u, float v, float width, float height, OpenResourceLocation resource) {
        HashMap<Integer, CGPoint> offsets = new HashMap<Integer, CGPoint>();
        offsets.put(0, new CGPoint(0.0f, 0.0f));
        offsets.put(1, new CGPoint(1.0f, 0.0f));
        offsets.put(4, new CGPoint(2.0f, 0.0f));
        return UIImage.of(resource).uv(u, v).fixed(width, height).unzip(offsets::get).build();
    }

    public static UIImage helpButtonImage() {
        HashMap<Integer, CGPoint> offsets = new HashMap<Integer, CGPoint>();
        offsets.put(0, new CGPoint(0.0f, 0.0f));
        offsets.put(1, new CGPoint(1.0f, 0.0f));
        return UIImage.of(HELP).fixed(7.0f, 8.0f).unzip(offsets::get).build();
    }
}

