/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.platform.fabric.builder;

import com.mojang.authlib.GameProfile;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.api.permission.IPermissionContext;
import moe.plushie.armourers_workshop.api.permission.IPermissionNode;
import moe.plushie.armourers_workshop.api.registry.IPermissionNodeBuilder;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.network.chat.Component.TranslatableProvider;
import moe.plushie.armourers_workshop.compatibility.fabric.AbstractFabricPermissionManager;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.core.utils.OpenResourceLocation;
import moe.plushie.armourers_workshop.init.ModConstants;
import moe.plushie.armourers_workshop.init.ModLog;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;

public class PermissionNodeBuilderImpl<T extends IPermissionNode>
implements IPermissionNodeBuilder<T> {
    private int level = 0;

    @Override
    public IPermissionNodeBuilder<T> level(int level) {
        this.level = level;
        return this;
    }

    @Override
    public T build(String name) {
        OpenResourceLocation registryName = ModConstants.key(name);
        ModLog.debug("Registering Permission '{}'", registryName);
        return (T)((IPermissionNode)Objects.unsafeCast(PermissionNodeBuilderImpl.makeNode(registryName, this.level)));
    }

    private static IPermissionNode makeNode(OpenResourceLocation registryName, int level) {
        if (FabricLoader.getInstance().isModLoaded("fabric-permissions-api-v0")) {
            Supplier<Supplier> node = () -> () -> AbstractFabricPermissionManager.makeNode(registryName, level);
            return (IPermissionNode)node.get().get();
        }
        return new NodeImpl(registryName);
    }

    public static class NodeImpl
    implements IPermissionNode {
        private final String key;
        private final IResourceLocation registryName;

        public NodeImpl(IResourceLocation registryName) {
            this.registryName = registryName;
            this.key = registryName.toLanguageKey();
        }

        @Override
        public boolean resolve(GameProfile profile, IPermissionContext context) {
            return true;
        }

        public String key() {
            return this.key;
        }

        @Override
        public class_2561 name() {
            return TranslatableProvider.translatable(class_2561.class, "permission." + this.key, new Object[0]);
        }

        @Override
        public class_2561 description() {
            return TranslatableProvider.translatable(class_2561.class, "permission." + this.key + ".desc", new Object[0]);
        }

        @Override
        public IResourceLocation registryName() {
            return this.registryName;
        }
    }
}

