/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.platform.fabric.config;

import java.nio.file.Path;
import java.util.Locale;
import moe.plushie.armourers_workshop.init.platform.fabric.config.FabricConfigFileTypeHandler;
import moe.plushie.armourers_workshop.init.platform.fabric.config.FabricConfigSpec;
import moe.plushie.armourers_workshop.init.platform.fabric.config.FabricConfigTracker;
import moe.plushie.armourers_workshop.runtime.nightconfig.core.CommentedConfig;
import moe.plushie.armourers_workshop.runtime.nightconfig.core.file.CommentedFileConfig;
import net.fabricmc.loader.api.ModContainer;

public class FabricConfig {
    private final Type type;
    private final FabricConfigSpec spec;
    private final String fileName;
    private final ModContainer container;
    private final FabricConfigFileTypeHandler configHandler;
    private CommentedConfig configData;

    public FabricConfig(Type type, FabricConfigSpec spec, ModContainer container, String fileName) {
        this.type = type;
        this.spec = spec;
        this.fileName = fileName;
        this.container = container;
        this.configHandler = FabricConfigFileTypeHandler.TOML;
        FabricConfigTracker.INSTANCE.trackConfig(this);
    }

    public FabricConfig(Type type, FabricConfigSpec spec, ModContainer activeContainer) {
        this(type, spec, activeContainer, FabricConfig.defaultConfigName(type, activeContainer.getMetadata().getId()));
    }

    private static String defaultConfigName(Type type, String modId) {
        return String.format("%s-%s.toml", modId, type.extension());
    }

    public Type getType() {
        return this.type;
    }

    public String getFileName() {
        return this.fileName;
    }

    public FabricConfigFileTypeHandler getHandler() {
        return this.configHandler;
    }

    public FabricConfigSpec getSpec() {
        return this.spec;
    }

    public String getModId() {
        return this.container.getMetadata().getId();
    }

    public CommentedConfig getConfigData() {
        return this.configData;
    }

    void setConfigData(CommentedConfig configData) {
        this.configData = configData;
        this.spec.setConfig(this.configData);
    }

    public void save() {
        ((CommentedFileConfig)this.configData).save();
    }

    public Path getFullPath() {
        return ((CommentedFileConfig)this.configData).getNioPath();
    }

    public static enum Type {
        COMMON,
        CLIENT,
        SERVER;


        public String extension() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

