/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.platform.fabric.config;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Function;
import moe.plushie.armourers_workshop.core.utils.FileUtils;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.init.platform.fabric.config.FabricConfig;
import moe.plushie.armourers_workshop.init.platform.fabric.config.FabricConfigEvents;
import moe.plushie.armourers_workshop.runtime.nightconfig.core.ConfigFormat;
import moe.plushie.armourers_workshop.runtime.nightconfig.core.file.CommentedFileConfig;
import moe.plushie.armourers_workshop.runtime.nightconfig.core.file.FileWatcher;
import moe.plushie.armourers_workshop.runtime.nightconfig.core.io.ParsingException;
import moe.plushie.armourers_workshop.runtime.nightconfig.core.io.WritingMode;
import net.fabricmc.loader.api.FabricLoader;

public class FabricConfigFileTypeHandler {
    static FabricConfigFileTypeHandler TOML = new FabricConfigFileTypeHandler();
    private static final Path defaultConfigPath = FabricLoader.getInstance().getGameDir().resolve("defaultconfigs");

    public Function<FabricConfig, CommentedFileConfig> reader(Path configBasePath) {
        return c -> {
            Path configPath = configBasePath.resolve(c.getFileName());
            CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder(configPath).sync().preserveInsertionOrder().autosave().onFileNotFound((newFile, configFormat) -> this.setupConfigFile((FabricConfig)c, newFile, configFormat)).writingMode(WritingMode.REPLACE).build();
            ModLog.debug("Built TOML config for {}", configPath.toString());
            try {
                configData.load();
            }
            catch (ParsingException ex) {
                throw new ConfigLoadingException((FabricConfig)c, ex);
            }
            ModLog.debug("Loaded TOML config file {}", configPath.toString());
            try {
                FileWatcher.defaultInstance().addWatch(configPath, (Runnable)new ConfigWatcher((FabricConfig)c, configData, Thread.currentThread().getContextClassLoader()));
                ModLog.debug("Watching TOML config file {} for changes", configPath.toString());
            }
            catch (IOException e) {
                throw new RuntimeException("Couldn't watch config file", e);
            }
            return configData;
        };
    }

    public void unload(Path configBasePath, FabricConfig config) {
        Path configPath = configBasePath.resolve(config.getFileName());
        try {
            FileWatcher.defaultInstance().removeWatch(configBasePath.resolve(config.getFileName()));
        }
        catch (RuntimeException e) {
            ModLog.error("Failed to remove config {} from tracker!", configPath.toString(), e);
        }
    }

    private boolean setupConfigFile(FabricConfig FabricConfig2, Path file, ConfigFormat<?> conf) throws IOException {
        Files.createDirectories(file.getParent(), new FileAttribute[0]);
        Path p = defaultConfigPath.resolve(FabricConfig2.getFileName());
        if (Files.exists(p, new LinkOption[0])) {
            ModLog.info("Loading default config file from path {}", p);
            Files.copy(p, file, new CopyOption[0]);
        } else {
            Files.createFile(file, new FileAttribute[0]);
            conf.initEmptyFile(file);
        }
        return true;
    }

    public static void backUpConfig(CommentedFileConfig commentedFileConfig) {
        FabricConfigFileTypeHandler.backUpConfig(commentedFileConfig, 5);
    }

    public static void backUpConfig(CommentedFileConfig commentedFileConfig, int maxBackups) {
        Path bakFileLocation = commentedFileConfig.getNioPath().getParent();
        String bakFileName = FileUtils.removeExtension(commentedFileConfig.getFile().getName());
        String bakFileExtension = FileUtils.getExtension(commentedFileConfig.getFile().getName()) + ".bak";
        Path bakFile = bakFileLocation.resolve(bakFileName + "-1." + bakFileExtension);
        try {
            for (int i = maxBackups; i > 0; --i) {
                Path oldBak = bakFileLocation.resolve(bakFileName + "-" + i + "." + bakFileExtension);
                if (!Files.exists(oldBak, new LinkOption[0])) continue;
                if (i >= maxBackups) {
                    Files.delete(oldBak);
                    continue;
                }
                Files.move(oldBak, bakFileLocation.resolve(bakFileName + "-" + (i + 1) + "." + bakFileExtension), new CopyOption[0]);
            }
            Files.copy(commentedFileConfig.getNioPath(), bakFile, new CopyOption[0]);
        }
        catch (IOException exception) {
            ModLog.warn("Failed to back up config file {}", commentedFileConfig.getNioPath(), exception);
        }
    }

    private static class ConfigLoadingException
    extends RuntimeException {
        public ConfigLoadingException(FabricConfig config, Exception cause) {
            super("Failed loading config file " + config.getFileName() + " of type " + String.valueOf((Object)config.getType()) + " for modid " + config.getModId(), cause);
        }
    }

    private static class ConfigWatcher
    implements Runnable {
        private final FabricConfig modConfig;
        private final CommentedFileConfig commentedFileConfig;
        private final ClassLoader realClassLoader;

        ConfigWatcher(FabricConfig FabricConfig2, CommentedFileConfig commentedFileConfig, ClassLoader classLoader) {
            this.modConfig = FabricConfig2;
            this.commentedFileConfig = commentedFileConfig;
            this.realClassLoader = classLoader;
        }

        @Override
        public void run() {
            Thread.currentThread().setContextClassLoader(this.realClassLoader);
            if (!this.modConfig.getSpec().isCorrecting()) {
                try {
                    this.commentedFileConfig.load();
                    if (!this.modConfig.getSpec().isCorrect(this.commentedFileConfig)) {
                        ModLog.warn("Configuration file {} is not correct. Correcting", this.commentedFileConfig.getFile().getAbsolutePath());
                        FabricConfigFileTypeHandler.backUpConfig(this.commentedFileConfig);
                        this.modConfig.getSpec().correct(this.commentedFileConfig);
                        this.commentedFileConfig.save();
                    }
                }
                catch (ParsingException ex) {
                    throw new ConfigLoadingException(this.modConfig, ex);
                }
                ModLog.debug("Config file {} changed, sending notifies", this.modConfig.getFileName());
                this.modConfig.getSpec().afterReload();
                ((FabricConfigEvents.OnUpdate)FabricConfigEvents.RELOADING.invoker()).config(this.modConfig);
            }
        }
    }
}

