/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.proxy;

import java.util.stream.Stream;
import moe.plushie.armourers_workshop.api.common.IBlockTintColorProvider;
import moe.plushie.armourers_workshop.api.common.IItemModelProperty;
import moe.plushie.armourers_workshop.api.common.IItemPropertiesProvider;
import moe.plushie.armourers_workshop.api.common.IItemTintColorProvider;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.api.core.math.IPoseStack;
import moe.plushie.armourers_workshop.api.event.EventBus;
import moe.plushie.armourers_workshop.builder.client.render.PaintingHighlightPlacementRenderer;
import moe.plushie.armourers_workshop.compatibility.client.AbstractBufferSource;
import moe.plushie.armourers_workshop.compatibility.client.AbstractPoseStack;
import moe.plushie.armourers_workshop.core.client.bake.SkinBakery;
import moe.plushie.armourers_workshop.core.client.bake.SkinPreloadManager;
import moe.plushie.armourers_workshop.core.client.render.HighlightPlacementRenderer;
import moe.plushie.armourers_workshop.core.client.skinrender.SkinRendererManager;
import moe.plushie.armourers_workshop.core.client.sound.SmartSoundManager;
import moe.plushie.armourers_workshop.core.client.texture.EntityTextureLoader;
import moe.plushie.armourers_workshop.core.client.texture.SmartTextureManager;
import moe.plushie.armourers_workshop.core.data.DataPackLoader;
import moe.plushie.armourers_workshop.core.data.DataPackType;
import moe.plushie.armourers_workshop.core.data.cache.AutoreleasePool;
import moe.plushie.armourers_workshop.core.data.ticket.TicketManager;
import moe.plushie.armourers_workshop.core.entity.MannequinEntity;
import moe.plushie.armourers_workshop.core.menu.SkinSlotType;
import moe.plushie.armourers_workshop.core.skin.SkinLoader;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.OpenItemDisplayContext;
import moe.plushie.armourers_workshop.core.utils.Scheduler;
import moe.plushie.armourers_workshop.core.utils.SkinUtils;
import moe.plushie.armourers_workshop.core.utils.TickUtils;
import moe.plushie.armourers_workshop.core.utils.TypedRegistry;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.ModConfigSpec;
import moe.plushie.armourers_workshop.init.ModConstants;
import moe.plushie.armourers_workshop.init.ModContext;
import moe.plushie.armourers_workshop.init.ModDebugger;
import moe.plushie.armourers_workshop.init.ModEntityProfiles;
import moe.plushie.armourers_workshop.init.ModItems;
import moe.plushie.armourers_workshop.init.ModKeyBindings;
import moe.plushie.armourers_workshop.init.client.ClientWardrobeHandler;
import moe.plushie.armourers_workshop.init.environment.EnvironmentExecutor;
import moe.plushie.armourers_workshop.init.environment.EnvironmentType;
import moe.plushie.armourers_workshop.init.event.client.ClientPlayerEvent;
import moe.plushie.armourers_workshop.init.event.client.ItemTooltipEvent;
import moe.plushie.armourers_workshop.init.event.client.RegisterColorHandlersEvent;
import moe.plushie.armourers_workshop.init.event.client.RegisterItemPropertyEvent;
import moe.plushie.armourers_workshop.init.event.client.RegisterTextureEvent;
import moe.plushie.armourers_workshop.init.event.client.RenderFrameEvent;
import moe.plushie.armourers_workshop.init.event.client.RenderHighlightEvent;
import moe.plushie.armourers_workshop.init.event.client.RenderLivingEntityEvent;
import moe.plushie.armourers_workshop.init.event.client.RenderSpecificHandEvent;
import moe.plushie.armourers_workshop.init.platform.DataPackManager;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import moe.plushie.armourers_workshop.init.platform.ItemTooltipManager;
import moe.plushie.armourers_workshop.library.data.GlobalSkinLibrary;
import moe.plushie.armourers_workshop.library.data.SkinLibraryManager;
import moe.plushie.armourers_workshop.library.data.impl.MinecraftAuth;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2248;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3304;

@Environment(value=EnvType.CLIENT)
public class ClientProxy {
    public static void init() {
        ClientWardrobeHandler.init();
        SkinRendererManager.init();
        ModKeyBindings.init();
        ModDebugger.init();
        MinecraftAuth.init(new MinecraftAuth.UserProvider(){

            @Override
            public String id() {
                return EnvironmentManager.getClient().method_1548().method_1673();
            }

            @Override
            public String name() {
                return EnvironmentManager.getClient().method_1548().method_1676();
            }

            @Override
            public String accessToken() {
                return EnvironmentManager.getClient().method_1548().method_1674();
            }
        });
        EnvironmentExecutor.willSetup(EnvironmentType.CLIENT, () -> () -> {
            class_3300 resourceManager = EnvironmentManager.getClient().method_1478();
            DataPackLoader packLoader = DataPackManager.byType(DataPackType.CLIENT_RESOURCES);
            ((class_3304)resourceManager).method_14477((class_3302)packLoader);
        });
        ClientProxy.register();
    }

    private static void register() {
        EventBus.register(RegisterItemPropertyEvent.class, event -> TypedRegistry.findEntries(class_1792.class).forEach(it -> {
            class_1792 item = (class_1792)it.get();
            if (item instanceof IItemPropertiesProvider) {
                IItemPropertiesProvider provider = (IItemPropertiesProvider)item;
                provider.createModelProperties((key, property) -> event.register((IResourceLocation)key, item, (IItemModelProperty)property));
            }
            event.register(ModConstants.key("is_crossbow"), class_1802.field_8399, (itemStack, level, entity, id) -> 1.0f);
            event.register(ModConstants.key("is_skin"), (class_1792)ModItems.SKIN.get(), (itemStack, level, entity, id) -> {
                MannequinEntity mannequin;
                if (entity instanceof MannequinEntity && (itemStack == (mannequin = (MannequinEntity)entity).method_6047() || itemStack == mannequin.method_6079())) {
                    return 0.0f;
                }
                return 1.0f;
            });
        }));
        EventBus.register(RegisterColorHandlersEvent.Item.class, event -> TypedRegistry.findEntries(class_1792.class).forEach(it -> {
            class_1792 item = (class_1792)it.get();
            if (item instanceof IItemTintColorProvider) {
                IItemTintColorProvider provider = (IItemTintColorProvider)item;
                event.register(provider, item);
            }
        }));
        EventBus.register(RegisterColorHandlersEvent.Block.class, event -> TypedRegistry.findEntries(class_2248.class).forEach(it -> {
            class_2248 block = (class_2248)it.get();
            if (block instanceof IBlockTintColorProvider) {
                IBlockTintColorProvider provider = (IBlockTintColorProvider)block;
                event.register(provider, block);
            }
        }));
        EventBus.register(RegisterTextureEvent.class, event -> Stream.of(SkinSlotType.values()).forEach(slotType -> event.register(slotType.icon())));
        EventBus.register(ClientPlayerEvent.LoggingIn.class, event -> {
            class_1657 player = event.getPlayer();
            if (player == null || !player.equals((Object)EnvironmentManager.getPlayer())) {
                return;
            }
            SkinBakery.start();
            SkinPreloadManager.start();
            SmartSoundManager.getInstance().start();
            SmartTextureManager.getInstance().start();
            EntityTextureLoader.getInstance().start();
        });
        EventBus.register(ClientPlayerEvent.LoggingOut.class, event -> {
            class_1657 player = event.getPlayer();
            if (player == null || !player.equals((Object)EnvironmentManager.getPlayer())) {
                return;
            }
            SkinPreloadManager.stop();
            SkinBakery.stop();
            TicketManager.invalidateAll();
            EntityTextureLoader.getInstance().stop();
            SmartSoundManager.getInstance().stop();
            SmartTextureManager.getInstance().stop();
            SkinLoader.getInstance().stop();
            GlobalSkinLibrary.getInstance().disconnect();
            SkinLibraryManager.getClient().publicLibrary().reset();
            SkinLibraryManager.getClient().privateLibrary().reset();
            ModContext.reset();
            ModEntityProfiles.setCustomProfiles(Collections.emptyMap());
            ModConfigSpec.COMMON.apply(null);
        });
        EventBus.register(ClientPlayerEvent.Clone.class, event -> SkinUtils.copySkinWardrobe((class_1297)event.getOldPlayer(), (class_1297)event.getNewPlayer()));
        EventBus.register(RenderFrameEvent.Pre.class, event -> {
            Scheduler.CLIENT.begin();
            AutoreleasePool.begin();
            TickUtils.tick(event.getDeltaTracker().isPaused() || event.getDeltaTracker().isFrozen());
            SkinPreloadManager.tick(event.getDeltaTracker().isPaused());
        });
        EventBus.register(RenderFrameEvent.Post.class, event -> {
            AutoreleasePool.end();
            Scheduler.CLIENT.end();
        });
        EventBus.register(RenderHighlightEvent.Block.class, event -> {
            class_1657 player = EnvironmentManager.getPlayer();
            if (player == null) {
                return;
            }
            IPoseStack poseStack = AbstractPoseStack.wrap(event.getPoseStack());
            AbstractBufferSource buffers = AbstractBufferSource.wrap(event.getMultiBufferSource());
            class_1799 itemStack = player.method_6047();
            if (ModConfig.Client.enableEntityPlacementHighlight && itemStack.method_31574((class_1792)ModItems.MANNEQUIN.get())) {
                HighlightPlacementRenderer.renderEntity(player, event.getTarget(), event.getCamera(), poseStack, buffers);
            }
            if (ModConfig.Client.enableBlockPlacementHighlight && itemStack.method_31574((class_1792)ModItems.SKIN.get())) {
                HighlightPlacementRenderer.renderBlock(itemStack, player, event.getTarget(), event.getCamera(), poseStack, buffers);
            }
            if (ModConfig.Client.enablePaintToolPlacementHighlight && itemStack.method_31574((class_1792)ModItems.BLENDING_TOOL.get())) {
                PaintingHighlightPlacementRenderer.renderPaintTool(itemStack, player, event.getTarget(), event.getCamera(), poseStack, buffers);
            }
        });
        EventBus.register(RenderLivingEntityEvent.Pre.class, event -> ClientWardrobeHandler.onRenderLivingEntityPre(event.getEntity(), event.getPartialTicks(), event.getPackedLight(), event.getPoseStack(), event.getMultiBufferSource(), event.getRenderer()));
        EventBus.register(RenderLivingEntityEvent.Setup.class, event -> ClientWardrobeHandler.onRenderLivingEntity(event.getEntity(), event.getPartialTicks(), event.getPackedLight(), event.getPoseStack(), event.getMultiBufferSource(), event.getRenderer()));
        EventBus.register(RenderLivingEntityEvent.Post.class, event -> ClientWardrobeHandler.onRenderLivingEntityPost(event.getEntity(), event.getPartialTicks(), event.getPackedLight(), event.getPoseStack(), event.getMultiBufferSource(), event.getRenderer()));
        EventBus.register(RenderSpecificHandEvent.class, event -> {
            if (!ModConfig.enableFirstPersonSkinRenderer()) {
                return;
            }
            OpenItemDisplayContext itemDisplayContext = OpenItemDisplayContext.FIRST_PERSON_LEFT_HAND;
            if (event.getHand() == class_1268.field_5808) {
                itemDisplayContext = OpenItemDisplayContext.FIRST_PERSON_RIGHT_HAND;
            }
            ClientWardrobeHandler.onRenderSpecificHand((class_1309)event.getPlayer(), 0.0f, event.getPackedLight(), itemDisplayContext, event.getPoseStack(), event.getMultiBufferSource(), () -> event.setCancelled(true));
        });
        EventBus.register(ItemTooltipEvent.Gather.class, ItemTooltipManager::gatherSkinTooltip);
        EventBus.register(ItemTooltipEvent.Render.class, ItemTooltipManager::renderSkinTooltip);
    }
}

