/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.runtime.nightconfig.toml;

import java.time.temporal.Temporal;
import java.util.Iterator;
import java.util.List;
import moe.plushie.armourers_workshop.runtime.nightconfig.core.Config;
import moe.plushie.armourers_workshop.runtime.nightconfig.core.NullObject;
import moe.plushie.armourers_workshop.runtime.nightconfig.core.io.CharacterOutput;
import moe.plushie.armourers_workshop.runtime.nightconfig.core.io.WritingException;
import moe.plushie.armourers_workshop.runtime.nightconfig.toml.ArrayWriter;
import moe.plushie.armourers_workshop.runtime.nightconfig.toml.StringWriter;
import moe.plushie.armourers_workshop.runtime.nightconfig.toml.TableWriter;
import moe.plushie.armourers_workshop.runtime.nightconfig.toml.TemporalWriter;
import moe.plushie.armourers_workshop.runtime.nightconfig.toml.TomlWriter;

final class ValueWriter {
    private static void writeString(String string, CharacterOutput output, TomlWriter writer) {
        if (writer.writesLiteral(string)) {
            StringWriter.writeLiteral(string, output);
        } else {
            StringWriter.writeBasic(string, output);
        }
    }

    static void write(Object value, CharacterOutput output, TomlWriter writer) {
        if (value instanceof Config) {
            TableWriter.writeInline((Config)value, output, writer);
        } else if (value instanceof List) {
            List list = (List)value;
            if (!list.isEmpty() && list.get(0) instanceof Config) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Object table = iterator.next();
                    TableWriter.writeInline((Config)table, output, writer);
                    if (!iterator.hasNext()) continue;
                    output.write(ArrayWriter.ELEMENT_SEPARATOR);
                }
            } else {
                ArrayWriter.write((List)value, output, writer);
            }
        } else if (value instanceof CharSequence) {
            ValueWriter.writeString(value.toString(), output, writer);
        } else if (value instanceof Enum) {
            ValueWriter.writeString(((Enum)value).name(), output, writer);
        } else if (value instanceof Temporal) {
            TemporalWriter.write((Temporal)value, output);
        } else if (value instanceof Float || value instanceof Double) {
            double d = ((Number)value).doubleValue();
            if (Double.isNaN(d)) {
                output.write("nan");
            } else if (d == Double.POSITIVE_INFINITY) {
                output.write("+inf");
            } else if (d == Double.NEGATIVE_INFINITY) {
                output.write("-inf");
            } else {
                output.write(value.toString());
            }
        } else if (value instanceof Number || value instanceof Boolean) {
            output.write(value.toString());
        } else {
            if (value == null || value == NullObject.NULL_OBJECT) {
                throw new WritingException("TOML doesn't support null values");
            }
            throw new WritingException("Unsupported value type: " + value.getClass());
        }
    }

    private ValueWriter() {
    }
}

