/*
 * Decompiled with CFR 0.152.
 */
package com.apple.library.impl;

public class BezierPathImpl {
    static final int CUBIC_BEZIER_SPLINE_SAMPLES = 11;
    static final int kMaxNewtonIterations = 4;
    static final double kBezierEpsilon = 1.0E-7;
    double _ax;
    double _bx;
    double _cx;
    double _ay;
    double _by;
    double _cy;
    double _startGradient;
    double _endGradient;
    double _minRange;
    double _maxRange;
    final double[] _splineSamples = new double[11];

    public BezierPathImpl(double p1x, double p1y, double p2x, double p2y) {
        this._initCoefficients(p1x, p1y, p2x, p2y);
        this._initGradients(p1x, p1y, p2x, p2y);
        this._initRange(p1y, p2y);
        this._initSpline();
    }

    public double solve(double x) {
        return this.solveWithEpsilon(x, 1.0E-7);
    }

    public double solveWithEpsilon(double x, double epsilon) {
        if (x < 0.0) {
            return this._toFinite(0.0 + this._startGradient * x);
        }
        if (x > 1.0) {
            return this._toFinite(1.0 + this._endGradient * (x - 1.0));
        }
        return this._sampleCurveY(this._solveCurveX(x, epsilon));
    }

    public double slope(double x) {
        return this.slopeWithEpsilon(x, 1.0E-7);
    }

    public double slopeWithEpsilon(double x, double epsilon) {
        x = Math.min(Math.max(x, 0.0), 1.0);
        double t = this._solveCurveX(x, epsilon);
        double dx = this._sampleCurveDerivativeX(t);
        double dy = this._sampleCurveDerivativeY(t);
        if (dx == 0.0 && dy == 0.0) {
            return 0.0;
        }
        return this._toFinite(dy / dx);
    }

    public double getX1() {
        return this._cx / 3.0;
    }

    public double getY1() {
        return this._cy / 3.0;
    }

    public double getX2() {
        return (this._bx + this._cx) / 3.0 + this.getX1();
    }

    public double getY2() {
        return (this._by + this._cy) / 3.0 + this.getY1();
    }

    private void _initCoefficients(double p1x, double p1y, double p2x, double p2y) {
        this._cx = 3.0 * p1x;
        this._bx = 3.0 * (p2x - p1x) - this._cx;
        this._ax = 1.0 - this._cx - this._bx;
        this._cy = this._toFinite(3.0 * p1y);
        this._by = this._toFinite(3.0 * (p2y - p1y) - this._cy);
        this._ay = this._toFinite(1.0 - this._cy - this._by);
    }

    private void _initGradients(double p1x, double p1y, double p2x, double p2y) {
        this._startGradient = p1x > 0.0 ? p1y / p1x : (p1y == 0.0 && p2x > 0.0 ? p2y / p2x : (p1y == 0.0 && p2y == 0.0 ? 1.0 : 0.0));
        this._endGradient = p2x < 1.0 ? (p2y - 1.0) / (p2x - 1.0) : (p2y == 1.0 && p1x < 1.0 ? (p1y - 1.0) / (p1x - 1.0) : (p2y == 1.0 && p1y == 1.0 ? 1.0 : 0.0));
    }

    private void _initRange(double p1y, double p2y) {
        this._minRange = 0.0;
        this._maxRange = 1.0;
        if (0.0 <= p1y && p1y < 1.0 && 0.0 <= p2y && p2y <= 1.0) {
            return;
        }
        double epsilon = 1.0E-7;
        double a = 3.0 * this._ay;
        double b = 2.0 * this._by;
        double c = this._cy;
        if (Math.abs(a) < epsilon && Math.abs(b) < epsilon) {
            return;
        }
        double t1 = 0.0;
        double t2 = 0.0;
        if (Math.abs(a) < epsilon) {
            t1 = -c / b;
        } else {
            double discriminant = b * b - 4.0 * a * c;
            if (discriminant < 0.0) {
                return;
            }
            double ds = Math.sqrt(discriminant);
            t1 = (-b + ds) / (2.0 * a);
            t2 = (-b - ds) / (2.0 * a);
        }
        double sol1 = 0.0;
        double sol2 = 0.0;
        if (0.0 < t1 && t1 < 1.0) {
            sol1 = this._sampleCurveY(t1);
        }
        if (0.0 < t2 && t2 < 1.0) {
            sol2 = this._sampleCurveY(t2);
        }
        this._minRange = Math.min(Math.min(this._minRange, sol1), sol2);
        this._maxRange = Math.max(Math.max(this._maxRange, sol1), sol2);
    }

    private void _initSpline() {
        double delta_t = 0.1;
        for (int i = 0; i < 11; ++i) {
            this._splineSamples[i] = this._sampleCurveX((double)i * delta_t);
        }
    }

    private double _sampleCurveX(double t) {
        return ((this._ax * t + this._bx) * t + this._cx) * t;
    }

    private double _sampleCurveY(double t) {
        return this._toFinite(((this._ay * t + this._by) * t + this._cy) * t);
    }

    private double _sampleCurveDerivativeX(double t) {
        return (3.0 * this._ax * t + 2.0 * this._bx) * t + this._cx;
    }

    private double _sampleCurveDerivativeY(double t) {
        return this._toFinite(this._toFinite(this._toFinite(3.0 * this._ay) * t + this._toFinite(2.0 * this._by)) * t + this._cy);
    }

    private double _solveCurveX(double x, double epsilon) {
        double t0 = 0.0;
        double t1 = 0.0;
        double t2 = x;
        double x2 = 0.0;
        double d2 = 0.0;
        double delta_t = 0.1;
        for (int i = 1; i < 11; ++i) {
            if (!(x <= this._splineSamples[i])) continue;
            t1 = delta_t * (double)i;
            t0 = t1 - delta_t;
            t2 = t0 + (t1 - t0) * (x - this._splineSamples[i - 1]) / (this._splineSamples[i] - this._splineSamples[i - 1]);
            break;
        }
        double newton_epsilon = Math.min(1.0E-7, epsilon);
        for (int i = 0; i < 4; ++i) {
            x2 = this._sampleCurveX(t2) - x;
            if (Math.abs(x2) < newton_epsilon) {
                return t2;
            }
            d2 = this._sampleCurveDerivativeX(t2);
            if (Math.abs(d2) < 1.0E-7) break;
            t2 -= x2 / d2;
        }
        if (Math.abs(x2) < epsilon) {
            return t2;
        }
        while (t0 < t1) {
            x2 = this._sampleCurveX(t2);
            if (Math.abs(x2 - x) < epsilon) {
                return t2;
            }
            if (x > x2) {
                t0 = t2;
            } else {
                t1 = t2;
            }
            t2 = (t1 + t0) * 0.5;
        }
        return t2;
    }

    private double _toFinite(double value) {
        return value;
    }
}

