/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.blockentity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import moe.plushie.armourers_workshop.api.common.IWorldUpdateTask;
import moe.plushie.armourers_workshop.api.core.IDataCodec;
import moe.plushie.armourers_workshop.api.core.IDataSerializer;
import moe.plushie.armourers_workshop.api.core.IDataSerializerKey;
import moe.plushie.armourers_workshop.builder.block.ArmourerBlock;
import moe.plushie.armourers_workshop.builder.blockentity.BoundingBoxBlockEntity;
import moe.plushie.armourers_workshop.builder.data.BoundingBox;
import moe.plushie.armourers_workshop.builder.item.impl.IPaintToolSelector;
import moe.plushie.armourers_workshop.builder.other.BlockUtils;
import moe.plushie.armourers_workshop.builder.other.CubeChangesCollector;
import moe.plushie.armourers_workshop.builder.other.CubeReplacingEvent;
import moe.plushie.armourers_workshop.builder.other.CubeSelector;
import moe.plushie.armourers_workshop.builder.other.CubeTransform;
import moe.plushie.armourers_workshop.builder.other.WorldBlockUpdateTask;
import moe.plushie.armourers_workshop.builder.other.WorldUpdater;
import moe.plushie.armourers_workshop.builder.other.WorldUtils;
import moe.plushie.armourers_workshop.compatibility.core.AbstractDirection;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.level.block.state.BlockState.PropertyProvider;
import moe.plushie.armourers_workshop.core.blockentity.UpdatableBlockEntity;
import moe.plushie.armourers_workshop.core.math.OpenRectangle3i;
import moe.plushie.armourers_workshop.core.math.OpenVector2i;
import moe.plushie.armourers_workshop.core.math.OpenVector3i;
import moe.plushie.armourers_workshop.core.skin.SkinType;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartType;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.core.skin.texture.EntityTextureDescriptor;
import moe.plushie.armourers_workshop.core.skin.texture.EntityTextureModel;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintData;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.OpenDirection;
import moe.plushie.armourers_workshop.init.ModBlocks;
import moe.plushie.armourers_workshop.utils.DataSerializers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;

public class ArmourerBlockEntity
extends UpdatableBlockEntity
implements IPaintToolSelector.Provider {
    private static final Map<SkinPartType, SkinProperty<Boolean>> PART_TO_MODEL = Collections.immutableMap(it -> {
        it.put((Object)SkinPartTypes.BIPPED_HEAD, SkinProperty.OVERRIDE_MODEL_HEAD);
        it.put((Object)SkinPartTypes.BIPPED_CHEST, SkinProperty.OVERRIDE_MODEL_CHEST);
        it.put((Object)SkinPartTypes.BIPPED_LEFT_ARM, SkinProperty.OVERRIDE_MODEL_LEFT_ARM);
        it.put((Object)SkinPartTypes.BIPPED_RIGHT_ARM, SkinProperty.OVERRIDE_MODEL_RIGHT_ARM);
        it.put((Object)SkinPartTypes.BIPPED_LEFT_THIGH, SkinProperty.OVERRIDE_MODEL_LEFT_LEG);
        it.put((Object)SkinPartTypes.BIPPED_RIGHT_THIGH, SkinProperty.OVERRIDE_MODEL_RIGHT_LEG);
        it.put((Object)SkinPartTypes.BIPPED_LEFT_FOOT, SkinProperty.OVERRIDE_MODEL_LEFT_LEG);
        it.put((Object)SkinPartTypes.BIPPED_RIGHT_FOOT, SkinProperty.OVERRIDE_MODEL_RIGHT_LEG);
    });
    protected int flags = 0;
    protected int version = 0;
    protected SkinType skinType = SkinTypes.ARMOR_HEAD;
    protected SkinProperties skinProperties = SkinProperties.EMPTY;
    protected EntityTextureDescriptor textureDescriptor = EntityTextureDescriptor.EMPTY;
    protected EntityTextureDescriptor.Model textureModel = EntityTextureDescriptor.Model.STEVE;
    protected SkinPaintData paintData;
    protected AxisAlignedBB renderBoundingBox;

    public ArmourerBlockEntity(TileEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    @Override
    public void readAdditionalData(IDataSerializer serializer) {
        this.skinType = serializer.read(CodingKeys.SKIN_TYPE);
        this.skinProperties = serializer.read(CodingKeys.SKIN_PROPERTIES);
        this.textureDescriptor = serializer.read(CodingKeys.PLAYER_TEXTURE);
        this.textureModel = serializer.read(CodingKeys.PLAYER_TEXTURE_MODEL);
        this.flags = serializer.read(CodingKeys.FLAGS);
        this.version = serializer.read(CodingKeys.VERSION);
        this.paintData = serializer.read(CodingKeys.PAINT_DATA);
        if (this.skinType == SkinTypes.UNKNOWN) {
            this.skinType = SkinTypes.ARMOR_HEAD;
        }
    }

    @Override
    public void writeAdditionalData(IDataSerializer serializer) {
        serializer.write(CodingKeys.SKIN_TYPE, this.skinType);
        serializer.write(CodingKeys.SKIN_PROPERTIES, this.skinProperties);
        serializer.write(CodingKeys.PLAYER_TEXTURE, this.textureDescriptor);
        serializer.write(CodingKeys.PLAYER_TEXTURE_MODEL, this.textureModel);
        serializer.write(CodingKeys.FLAGS, this.flags);
        serializer.write(CodingKeys.VERSION, this.version);
        serializer.write(CodingKeys.PAINT_DATA, this.paintData);
    }

    public void onPlace(World level, BlockPos pos, BlockState state, @Nullable LivingEntity entity) {
        this.remakeBoundingBoxes(null, this.boundingBoxes(), true);
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            this.setTextureDescriptor(EntityTextureDescriptor.fromProfile(player.func_146103_bH()));
        }
    }

    public void onRemove(World level, BlockPos pos, BlockState state) {
        if (!this.func_195044_w().func_203425_a((Block)ModBlocks.ARMOURER.get())) {
            return;
        }
        this.remakeBoundingBoxes(this.boundingBoxes(), null, true);
    }

    public SkinType skinType() {
        return this.skinType;
    }

    public void setSkinType(SkinType newValue) {
        if (this.skinType == newValue) {
            return;
        }
        Collection<BoundingBox> boxes = this.boundingBoxes();
        this.skinType = newValue;
        this.setPaintData(null);
        this.remakeSkinProperties();
        this.remakeBoundingBoxes(boxes, this.boundingBoxes(), true);
        BlockUtils.combine(this, this::sendBlockUpdates);
    }

    public SkinProperties skinProperties() {
        return this.skinProperties;
    }

    public void setSkinProperties(SkinProperties newValue) {
        Collection<BoundingBox> boxes = this.boundingBoxes();
        this.skinProperties = newValue;
        this.remakeBoundingBoxes(boxes, this.boundingBoxes(), false);
        BlockUtils.combine(this, this::sendBlockUpdates);
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        Collection<BoundingBox> boxes = this.boundingBoxes();
        this.flags = flags;
        this.remakeBoundingBoxes(boxes, this.boundingBoxes(), false);
        BlockUtils.combine(this, this::sendBlockUpdates);
    }

    public EntityTextureDescriptor textureDescriptor() {
        return this.textureDescriptor;
    }

    public void setTextureDescriptor(EntityTextureDescriptor newValue) {
        this.textureDescriptor = newValue;
        BlockUtils.combine(this, this::sendBlockUpdates);
    }

    public EntityTextureDescriptor.Model textureModel() {
        return this.textureModel;
    }

    public void setTextureModel(EntityTextureDescriptor.Model newValue) {
        Collection<BoundingBox> boxes = this.boundingBoxes();
        this.textureModel = newValue;
        this.remakePaintData(newValue);
        this.remakeBoundingBoxes(boxes, this.boundingBoxes(), false);
        BlockUtils.combine(this, this::sendBlockUpdates);
    }

    public SkinPaintData paintData() {
        return this.paintData;
    }

    public void setPaintData(SkinPaintData paintData) {
        if (this.paintData == paintData) {
            return;
        }
        if (paintData != null) {
            this.paintData = this.createPaintData(this.textureModel);
            this.paintData.copyFrom(paintData);
        } else {
            this.paintData = null;
        }
        BlockUtils.combine(this, this::sendBlockUpdates);
    }

    public SkinPaintColor getPaintColor(OpenVector2i pos) {
        if (this.paintData != null) {
            return SkinPaintColor.of(this.paintData.getColor(pos));
        }
        return null;
    }

    public void setPaintColor(OpenVector2i pos, SkinPaintColor paintColor) {
        if (this.paintData == null) {
            this.paintData = this.createPaintData(this.textureModel);
        }
        this.paintData.setColor(pos, paintColor.rawValue());
        this.func_70296_d();
    }

    @Override
    public void func_70296_d() {
        super.func_70296_d();
        ++this.version;
    }

    public boolean isShowGuides() {
        return (this.flags & 1) == 0;
    }

    public void setShowGuides(boolean value) {
        this.flags = value ? (this.flags &= 0xFFFFFFFE) : (this.flags |= 1);
        this.func_70296_d();
    }

    public boolean isShowHelper() {
        return (this.flags & 2) == 0;
    }

    public void setShowHelper(boolean value) {
        this.flags = value ? (this.flags &= 0xFFFFFFFD) : (this.flags |= 2);
        this.func_70296_d();
    }

    public boolean isShowModelGuides() {
        return (this.flags & 4) == 0;
    }

    public void setShowModelGuides(boolean value) {
        this.flags = value ? (this.flags &= 0xFFFFFFFB) : (this.flags |= 4);
        this.func_70296_d();
    }

    public boolean isUseHelper() {
        if (this.skinType == SkinTypes.ARMOR_WINGS) {
            return true;
        }
        return this.skinType.isTool();
    }

    @Override
    public IPaintToolSelector createPaintToolSelector(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        if (player == null || !player.func_226563_dT_()) {
            return null;
        }
        ArrayList<OpenRectangle3i> rects = new ArrayList<OpenRectangle3i>();
        CubeTransform transform = this.transform();
        for (SkinPartType skinPartType : this.skinType().parts()) {
            OpenRectangle3i box = WorldUtils.getResolvedBuildingSpace(skinPartType);
            BlockPos p1 = transform.mul(box.minX(), box.minY(), box.minZ());
            BlockPos p2 = transform.mul(box.maxX(), box.maxY(), box.maxZ());
            int minX = Math.min(p1.func_177958_n(), p2.func_177958_n());
            int minY = Math.min(p1.func_177956_o(), p2.func_177956_o());
            int minZ = Math.min(p1.func_177952_p(), p2.func_177952_p());
            int maxX = Math.max(p1.func_177958_n(), p2.func_177958_n());
            int maxY = Math.max(p1.func_177956_o(), p2.func_177956_o());
            int maxZ = Math.max(p1.func_177952_p(), p2.func_177952_p());
            rects.add(new OpenRectangle3i(minX, minY, minZ, maxX - minX, maxY - minY, maxZ - minZ));
        }
        return CubeSelector.all(rects);
    }

    public void copyPaintData(CubeChangesCollector collector, SkinPartType srcPart, SkinPartType destPart, boolean mirror) {
        if (this.paintData == null) {
            return;
        }
        EntityTextureModel boundingModel = this.boundingModel();
        EntityTextureModel.Box srcBox = boundingModel.get(srcPart);
        EntityTextureModel.Box destBox = boundingModel.get(destPart);
        if (srcBox != null && destBox != null) {
            WorldUtils.copyPaintData(this.paintData, srcBox, this.paintData, destBox, mirror);
            BlockUtils.combine(this, this::sendBlockUpdates);
        }
    }

    public void clearPaintData(CubeChangesCollector collector, SkinPartType partType) {
        if (this.paintData == null) {
            return;
        }
        if (partType == SkinPartTypes.UNKNOWN) {
            this.setPaintData(null);
            return;
        }
        EntityTextureModel boundingModel = this.boundingModel();
        EntityTextureModel.Box srcBox = boundingModel.get(partType);
        if (srcBox != null) {
            WorldUtils.clearPaintData(this.paintData, srcBox);
            BlockUtils.combine(this, this::sendBlockUpdates);
        }
    }

    public void clearCubes(CubeChangesCollector collector, SkinPartType partType) {
        WorldUtils.clearCubes(collector, this.transform(), this.skinType(), this.skinProperties(), partType);
        if (partType != SkinPartTypes.UNKNOWN) {
            return;
        }
        Boolean isMultiBlock = this.skinProperties.get(SkinProperty.BLOCK_MULTIBLOCK);
        this.skinProperties = new SkinProperties();
        this.skinProperties.put(SkinProperty.BLOCK_MULTIBLOCK, isMultiBlock);
        BlockUtils.combine(this, this::sendBlockUpdates);
    }

    public void replaceCubes(CubeChangesCollector collector, SkinPartType partType, CubeReplacingEvent event) throws Exception {
        WorldUtils.replaceCubes(collector, this.transform(), this.skinType(), this.skinProperties(), event);
    }

    public void copyCubes(CubeChangesCollector collector, SkinPartType srcPart, SkinPartType destPart, boolean mirror) throws Exception {
        WorldUtils.copyCubes(collector, this.transform(), this.skinType(), this.skinProperties(), srcPart, destPart, mirror);
    }

    public void clearMarkers(CubeChangesCollector collector, SkinPartType partType) {
        WorldUtils.clearMarkers(collector, this.transform(), this.skinType(), this.skinProperties(), partType);
        this.func_70296_d();
    }

    public boolean isModelOverridden(SkinPartType partType) {
        SkinProperty<Boolean> property = PART_TO_MODEL.get(partType);
        if (property != null) {
            return this.skinProperties().get(property);
        }
        return false;
    }

    public int version() {
        return this.version;
    }

    @Override
    public AxisAlignedBB getVisibleBox(BlockState blockState) {
        if (this.renderBoundingBox == null) {
            this.renderBoundingBox = new AxisAlignedBB(-32.0, -32.0, -44.0, 64.0, 64.0, 64.0);
            this.renderBoundingBox = this.renderBoundingBox.func_186670_a(this.func_174877_v());
        }
        return this.renderBoundingBox;
    }

    private void remakeSkinProperties() {
        String name = this.skinProperties.get(SkinProperty.ALL_CUSTOM_NAME);
        String flavour = this.skinProperties.get(SkinProperty.ALL_FLAVOUR_TEXT);
        this.skinProperties = new SkinProperties();
        this.skinProperties.put(SkinProperty.ALL_CUSTOM_NAME, name);
        this.skinProperties.put(SkinProperty.ALL_FLAVOUR_TEXT, flavour);
    }

    private void remakePaintData(EntityTextureDescriptor.Model model) {
        if (this.paintData == null) {
            return;
        }
        SkinPaintData newPaintData = this.createPaintData(model);
        newPaintData.copyFrom(this.paintData);
        this.paintData = newPaintData;
    }

    private boolean shouldAddBoundingBoxes(SkinPartType partType) {
        if (this.isUseHelper()) {
            return this.isShowHelper();
        }
        return !this.isModelOverridden(partType);
    }

    private void remakeBoundingBoxes(Collection<BoundingBox> oldBoxes, Collection<BoundingBox> newBoxes, boolean forced) {
        World level = this.func_145831_w();
        if (level == null || level.func_201670_d()) {
            return;
        }
        if (!forced && Objects.equals(oldBoxes, newBoxes)) {
            return;
        }
        this.applyBoundingBoxes(oldBoxes, (partType, pos, offset) -> {
            WorldBlockUpdateTask task = new WorldBlockUpdateTask(level, pos, Blocks.field_150350_a.func_176223_P());
            task.setValidator(state -> state.func_203425_a((Block)ModBlocks.BOUNDING_BOX.get()));
            return task;
        });
        this.applyBoundingBoxes(newBoxes, (partType, pos, offset) -> {
            WorldBlockUpdateTask task = new WorldBlockUpdateTask(level, pos, ((Block)ModBlocks.BOUNDING_BOX.get()).func_176223_P());
            task.setValidator(state -> PropertyProvider.isReplaceable(state) || state.func_203425_a((Block)ModBlocks.BOUNDING_BOX.get()));
            task.setModifier(state -> this.setupBoundingBox(level, pos, offset, partType));
            return task;
        });
    }

    private void setupBoundingBox(World level, BlockPos pos, OpenVector3i offset, SkinPartType partType) {
        TileEntity tileEntity = level.func_175625_s(pos);
        if (tileEntity instanceof BoundingBoxBlockEntity) {
            BoundingBoxBlockEntity blockEntity = (BoundingBoxBlockEntity)tileEntity;
            blockEntity.setPartType(partType);
            blockEntity.setGuide(offset);
            blockEntity.setParent(pos.func_177973_b((Vector3i)this.func_174877_v()));
            BlockUtils.combine(blockEntity, blockEntity::sendBlockUpdates);
        }
    }

    private void applyBoundingBoxes(@Nullable Collection<BoundingBox> boxes, IUpdateTaskBuilder builder) {
        if (boxes == null || boxes.isEmpty()) {
            return;
        }
        CubeTransform transform = this.transform();
        boxes.forEach(box -> box.forEach((ix, iy, iz) -> {
            BlockPos target = transform.mul(ix + box.x(), iy + box.y(), iz + box.z());
            ix = box.width() - ix - 1;
            iy = box.height() - iy - 1;
            SkinPartType partType = box.partType();
            IWorldUpdateTask task = builder.build(partType, target, new OpenVector3i(ix, iy, iz));
            if (task != null) {
                WorldUpdater.getInstance().submit(task);
            }
        }));
    }

    public OpenVector2i getTexturePos(SkinPartType partType, OpenVector3i offset, OpenDirection dir) {
        EntityTextureModel boundingModel = this.boundingModel();
        EntityTextureModel.Box box = boundingModel.get(partType);
        if (box == null) {
            return null;
        }
        OpenRectangle3i rect = box.bounds();
        return box.get(rect.x() + offset.x(), rect.y() + offset.y(), rect.z() + offset.z(), dir);
    }

    private Collection<BoundingBox> boundingBoxes() {
        ArrayList<BoundingBox> boxes = new ArrayList<BoundingBox>();
        for (SkinPartType skinPartType : this.skinType.parts()) {
            if (!this.shouldAddBoundingBoxes(skinPartType)) continue;
            OpenVector3i offset = skinPartType.offset();
            OpenRectangle3i bounds = skinPartType.buildingSpace();
            OpenRectangle3i rect = skinPartType.guideSpace(this.textureModel);
            rect = rect.offset(-offset.x(), -offset.y() - bounds.minY(), offset.z());
            boxes.add(new BoundingBox(skinPartType, rect));
        }
        return boxes;
    }

    private Collection<BoundingBox> fullBoundingBoxes() {
        ArrayList<BoundingBox> boxes = new ArrayList<BoundingBox>();
        for (SkinPartType skinPartType : this.skinType.parts()) {
            if (!this.shouldAddBoundingBoxes(skinPartType)) continue;
            OpenVector3i origin = skinPartType.offset();
            OpenRectangle3i buildSpace = skinPartType.buildingSpace();
            int dx = -origin.x() + buildSpace.x();
            int dy = -origin.y();
            int dz = origin.z() + buildSpace.z();
            OpenRectangle3i rect = new OpenRectangle3i(dx, dy, dz, buildSpace.width(), buildSpace.height(), buildSpace.depth());
            boxes.add(new BoundingBox(skinPartType, rect));
        }
        return boxes;
    }

    private EntityTextureModel boundingModel() {
        if (this.textureModel == EntityTextureDescriptor.Model.ALEX) {
            return BoundingBox.SLIM_MODEL;
        }
        return BoundingBox.MODEL;
    }

    private SkinPaintData createPaintData(EntityTextureDescriptor.Model model) {
        boolean slim = model == EntityTextureDescriptor.Model.ALEX;
        return SkinPaintData.v2(slim);
    }

    public OpenDirection facing() {
        return this.func_195044_w().func_235903_d_((Property)ArmourerBlock.field_185512_D).map(AbstractDirection::wrap).orElse(OpenDirection.NORTH);
    }

    public CubeTransform transform() {
        BlockPos pos = this.func_174877_v().func_177982_a(0, 1, 0);
        return new CubeTransform(this.func_145831_w(), pos, this.facing());
    }

    private static class CodingKeys {
        public static final IDataSerializerKey<SkinType> SKIN_TYPE = IDataSerializerKey.create("SkinType", SkinTypes.CODEC, SkinTypes.UNKNOWN);
        public static final IDataSerializerKey<SkinProperties> SKIN_PROPERTIES = IDataSerializerKey.create("SkinProperties", SkinProperties.CODEC, SkinProperties.EMPTY, SkinProperties.EMPTY::copy);
        public static final IDataSerializerKey<EntityTextureDescriptor> PLAYER_TEXTURE = IDataSerializerKey.create("Texture", EntityTextureDescriptor.CODEC, EntityTextureDescriptor.EMPTY);
        public static final IDataSerializerKey<EntityTextureDescriptor.Model> PLAYER_TEXTURE_MODEL = IDataSerializerKey.create("TextureModel", DataSerializers.ENTITY_TEXTURE_MODEL, EntityTextureDescriptor.Model.STEVE);
        public static final IDataSerializerKey<SkinPaintData> PAINT_DATA = IDataSerializerKey.create("PaintData", DataSerializers.COMPRESSED_PAINT_DATA, null);
        public static final IDataSerializerKey<Integer> FLAGS = IDataSerializerKey.create("Flags", IDataCodec.INT, 0);
        public static final IDataSerializerKey<Integer> VERSION = IDataSerializerKey.create("DataVersion", IDataCodec.INT, 0);

        private CodingKeys() {
        }
    }

    public static interface IUpdateTaskBuilder {
        public IWorldUpdateTask build(SkinPartType var1, BlockPos var2, OpenVector3i var3);
    }
}

