/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.gui.armourer.dialog;

import com.apple.library.coregraphics.CGRect;
import com.apple.library.foundation.NSString;
import com.apple.library.uikit.UICheckBox;
import com.apple.library.uikit.UIComboBox;
import com.apple.library.uikit.UIComboItem;
import com.apple.library.uikit.UILabel;
import java.util.ArrayList;
import moe.plushie.armourers_workshop.core.client.gui.widget.ConfirmDialog;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartType;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.core.utils.TranslateUtils;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ArmourerCopyDialog
extends ConfirmDialog {
    final ArrayList<SkinPartType> partTypes;
    private final UICheckBox mirrorCheckBox = new UICheckBox(CGRect.ZERO);
    private final UICheckBox paintCheckBox = new UICheckBox(CGRect.ZERO);
    private final UIComboBox sourcePartComboBox = new UIComboBox(new CGRect(0.0f, 0.0f, 100.0f, 14.0f));
    private final UIComboBox destinationPartComboBox = new UIComboBox(new CGRect(0.0f, 0.0f, 100.0f, 14.0f));

    public ArmourerCopyDialog(ArrayList<SkinPartType> partTypes) {
        this.setFrame(new CGRect(0.0f, 0.0f, 240.0f, 140.0f));
        this.partTypes = partTypes;
        this.setup();
    }

    private void setup() {
        this.layoutIfNeeded();
        float width = this.bounds().width - 30.0f;
        float left = this.confirmButton.frame().x() + 1.0f;
        float right = this.cancelButton.frame().maxX() - 1.0f;
        float bottom = this.confirmButton.frame().y() - 4.0f;
        this.mirrorCheckBox.setFrame(new CGRect(left, bottom - 22.0f, width, 9.0f));
        this.mirrorCheckBox.setTitle(NSString.localizedString("armourer.dialog.copy.mirror", new Object[0]));
        this.mirrorCheckBox.setSelected(false);
        this.addSubview(this.mirrorCheckBox);
        this.paintCheckBox.setFrame(new CGRect(left, bottom - 11.0f, width, 9.0f));
        this.paintCheckBox.setTitle(NSString.localizedString("armourer.dialog.copy.copyPaint", new Object[0]));
        this.paintCheckBox.setSelected(false);
        this.addSubview(this.paintCheckBox);
        this.sourcePartComboBox.setFrame(new CGRect(left, 35.0f, 100.0f, 14.0f));
        this.sourcePartComboBox.setSelectedIndex(0);
        this.sourcePartComboBox.reloadData(this.getItems(this.partTypes));
        this.addSubview(this.sourcePartComboBox);
        this.destinationPartComboBox.setFrame(new CGRect(right - 100.0f, 35.0f, 100.0f, 14.0f));
        this.destinationPartComboBox.setSelectedIndex(0);
        this.destinationPartComboBox.reloadData(this.getItems(this.partTypes));
        this.addSubview(this.destinationPartComboBox);
        UILabel label1 = new UILabel(new CGRect(this.sourcePartComboBox.frame().x(), this.sourcePartComboBox.frame().y() - 10.0f, 100.0f, 9.0f));
        UILabel label2 = new UILabel(new CGRect(this.destinationPartComboBox.frame().x(), this.destinationPartComboBox.frame().y() - 10.0f, 100.0f, 9.0f));
        label1.setText(NSString.localizedString("armourer.dialog.copy.srcPart", new Object[0]));
        label2.setText(NSString.localizedString("armourer.dialog.copy.desPart", new Object[0]));
        this.addSubview(label1);
        this.addSubview(label2);
    }

    public SkinPartType sourcePartType() {
        if (this.partTypes != null && this.sourcePartComboBox != null && this.sourcePartComboBox.selectedIndex() < this.partTypes.size()) {
            return this.partTypes.get(this.sourcePartComboBox.selectedIndex());
        }
        return SkinPartTypes.UNKNOWN;
    }

    public SkinPartType destinationPartType() {
        if (this.partTypes != null && this.destinationPartComboBox != null && this.destinationPartComboBox.selectedIndex() < this.partTypes.size()) {
            return this.partTypes.get(this.destinationPartComboBox.selectedIndex());
        }
        return SkinPartTypes.UNKNOWN;
    }

    public boolean isMirror() {
        return this.mirrorCheckBox == null || this.mirrorCheckBox.isSelected();
    }

    public boolean isCopyPaintData() {
        return this.paintCheckBox == null || this.paintCheckBox.isSelected();
    }

    private ArrayList<UIComboItem> getItems(ArrayList<SkinPartType> partTypes) {
        ArrayList<UIComboItem> items = new ArrayList<UIComboItem>();
        for (SkinPartType partType : partTypes) {
            NSString title = new NSString((ITextComponent)TranslateUtils.Name.of(partType));
            items.add(new UIComboItem(title));
        }
        return items;
    }
}

