/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.render;

import com.apple.library.uikit.UIColor;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import moe.plushie.armourers_workshop.api.armature.IJointTransform;
import moe.plushie.armourers_workshop.api.client.IBufferSource;
import moe.plushie.armourers_workshop.api.core.math.IPoseStack;
import moe.plushie.armourers_workshop.builder.blockentity.AdvancedBuilderBlockEntity;
import moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.guide.AdvancedAbstractGuideRenderer;
import moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.guide.AdvancedBackpackGuideRenderer;
import moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.guide.AdvancedBlockGuideRenderer;
import moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.guide.AdvancedBoatGuideRenderer;
import moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.guide.AdvancedHorseGuideRenderer;
import moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.guide.AdvancedHumanGuideRenderer;
import moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.guide.AdvancedItemGuideRenderer;
import moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.guide.AdvancedMinecartGuideRenderer;
import moe.plushie.armourers_workshop.compatibility.client.AbstractBlockEntityRendererProviderImpl;
import moe.plushie.armourers_workshop.compatibility.client.AbstractModelViewStack;
import moe.plushie.armourers_workshop.compatibility.client.renderer.AbstractBlockEntityRenderer;
import moe.plushie.armourers_workshop.core.client.bake.BakedArmature;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkinPart;
import moe.plushie.armourers_workshop.core.client.model.SkinItemModel;
import moe.plushie.armourers_workshop.core.client.model.SkinItemModelManager;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderTesselator;
import moe.plushie.armourers_workshop.core.data.ticket.TicketManager;
import moe.plushie.armourers_workshop.core.math.OpenTransform3f;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.SkinType;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.core.skin.serializer.document.SkinDocument;
import moe.plushie.armourers_workshop.core.skin.serializer.document.SkinDocumentNode;
import moe.plushie.armourers_workshop.core.skin.serializer.document.SkinDocumentSettings;
import moe.plushie.armourers_workshop.core.skin.serializer.document.SkinDocumentType;
import moe.plushie.armourers_workshop.core.skin.serializer.document.SkinDocumentTypes;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.OpenItemDisplayContext;
import moe.plushie.armourers_workshop.core.utils.OpenItemTransforms;
import moe.plushie.armourers_workshop.init.ModDebugger;
import moe.plushie.armourers_workshop.utils.ShapeTesselator;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AdvancedBuilderBlockRenderer<T extends AdvancedBuilderBlockEntity>
extends AbstractBlockEntityRenderer<T> {
    public static final float SCALE = 0.0625f;
    private static final Map<SkinDocumentType, AdvancedAbstractGuideRenderer> GUIDES = Collections.immutableMap(it -> {
        it.put((Object)SkinDocumentTypes.GENERAL_ARMOR_HEAD, (Object)new AdvancedHumanGuideRenderer());
        it.put((Object)SkinDocumentTypes.GENERAL_ARMOR_CHEST, (Object)new AdvancedHumanGuideRenderer());
        it.put((Object)SkinDocumentTypes.GENERAL_ARMOR_FEET, (Object)new AdvancedHumanGuideRenderer());
        it.put((Object)SkinDocumentTypes.GENERAL_ARMOR_LEGS, (Object)new AdvancedHumanGuideRenderer());
        it.put((Object)SkinDocumentTypes.GENERAL_ARMOR_WINGS, (Object)new AdvancedHumanGuideRenderer());
        it.put((Object)SkinDocumentTypes.GENERAL_ARMOR_OUTFIT, (Object)new AdvancedHumanGuideRenderer());
        it.put((Object)SkinDocumentTypes.ITEM, (Object)new AdvancedItemGuideRenderer());
        it.put((Object)SkinDocumentTypes.ITEM_AXE, (Object)new AdvancedItemGuideRenderer());
        it.put((Object)SkinDocumentTypes.ITEM_HOE, (Object)new AdvancedItemGuideRenderer());
        it.put((Object)SkinDocumentTypes.ITEM_SHOVEL, (Object)new AdvancedItemGuideRenderer());
        it.put((Object)SkinDocumentTypes.ITEM_PICKAXE, (Object)new AdvancedItemGuideRenderer());
        it.put((Object)SkinDocumentTypes.ITEM_SWORD, (Object)new AdvancedItemGuideRenderer());
        it.put((Object)SkinDocumentTypes.ITEM_SHIELD, (Object)new AdvancedItemGuideRenderer());
        it.put((Object)SkinDocumentTypes.ITEM_BOW, (Object)new AdvancedItemGuideRenderer());
        it.put((Object)SkinDocumentTypes.ITEM_TRIDENT, (Object)new AdvancedItemGuideRenderer());
        it.put((Object)SkinDocumentTypes.ITEM_BACKPACK, (Object)new AdvancedBackpackGuideRenderer());
        it.put((Object)SkinDocumentTypes.ENTITY_BOAT, (Object)new AdvancedBoatGuideRenderer());
        it.put((Object)SkinDocumentTypes.ENTITY_MINECART, (Object)new AdvancedMinecartGuideRenderer());
        it.put((Object)SkinDocumentTypes.ENTITY_HORSE, (Object)new AdvancedHorseGuideRenderer());
        it.put((Object)SkinDocumentTypes.BLOCK, (Object)new AdvancedBlockGuideRenderer());
    });
    private static final Set<SkinType> USE_ITEM_TRANSFORMERS = Collections.immutableSet(it -> {
        it.add((Object)SkinTypes.ITEM);
        it.add((Object)SkinTypes.ITEM_AXE);
        it.add((Object)SkinTypes.ITEM_HOE);
        it.add((Object)SkinTypes.ITEM_SHOVEL);
        it.add((Object)SkinTypes.ITEM_PICKAXE);
        it.add((Object)SkinTypes.ITEM_SWORD);
        it.add((Object)SkinTypes.ITEM_SHIELD);
        it.add((Object)SkinTypes.ITEM_BOW);
        it.add((Object)SkinTypes.ITEM_TRIDENT);
    });
    public static ArrayList<OpenVector3f> OUTPUTS = new ArrayList();
    public static HashSet<BakedSkinPart> RESULTS = new HashSet();

    public static void setOutput(int i, OpenVector3f pt) {
        while (i >= OUTPUTS.size()) {
            OUTPUTS.add(OpenVector3f.ZERO);
        }
        OUTPUTS.set(i, pt);
    }

    public static void setResult(Collection<BakedSkinPart> results) {
        RESULTS.clear();
        RESULTS.addAll(results);
    }

    public AdvancedBuilderBlockRenderer(AbstractBlockEntityRendererProviderImpl.Context context) {
        super(context);
    }

    @Override
    public void render(T entity, float partialTicks, IPoseStack poseStack, IBufferSource bufferSource, int light, int overlay) {
        AdvancedAbstractGuideRenderer guideRenderer;
        poseStack.pushPose();
        poseStack.translate(((AdvancedBuilderBlockEntity)entity).offset.x(), ((AdvancedBuilderBlockEntity)entity).offset.y(), ((AdvancedBuilderBlockEntity)entity).offset.z());
        poseStack.translate(0.5f, 0.5f, 0.5f);
        poseStack.scale(((AdvancedBuilderBlockEntity)entity).carmeScale.x(), ((AdvancedBuilderBlockEntity)entity).carmeScale.y(), ((AdvancedBuilderBlockEntity)entity).carmeScale.z());
        poseStack.scale(-0.0625f, -0.0625f, 0.0625f);
        SkinDocument document = ((AdvancedBuilderBlockEntity)entity).document();
        SkinDocumentSettings settings = document.settings();
        if (settings.showsOrigin()) {
            poseStack.scale(-1.0f, -1.0f, 1.0f);
            ShapeTesselator.vector(OpenVector3f.ZERO, 16.0f, poseStack, bufferSource);
            poseStack.scale(-1.0f, -1.0f, 1.0f);
        }
        if (settings.showsHelperModel() && (guideRenderer = GUIDES.get(document.type())) != null) {
            guideRenderer.render(document, poseStack, light, overlay, bufferSource);
        }
        if (settings.showsHelperModel() && document.get(SkinProperty.OVERRIDE_ENTITY_SIZE).booleanValue()) {
            float width = (float)(document.get(SkinProperty.OVERRIDE_ENTITY_SIZE_WIDTH) * 16.0);
            float height = (float)(document.get(SkinProperty.OVERRIDE_ENTITY_SIZE_HEIGHT) * 16.0);
            float eyeHeight = (float)(document.get(SkinProperty.OVERRIDE_ENTITY_SIZE_EYE_HEIGHT) * 16.0);
            float radius = width / 2.0f;
            ShapeTesselator.stroke(-radius, 24.0f - height, -radius, radius, 24.0f, radius, UIColor.WHITE, poseStack, bufferSource);
            ShapeTesselator.stroke(-radius, 24.0f - eyeHeight, -radius, radius, 24.0f - eyeHeight, radius, UIColor.RED, poseStack, bufferSource);
        }
        if (USE_ITEM_TRANSFORMERS.contains(document.type().skinType())) {
            this.applyTransform(poseStack, document.type().skinType(), document.itemTransforms());
        }
        BakedArmature armature = BakedArmature.defaultBy(document.type().skinType());
        this.renderNode(document, document.root(), armature, 0.0f, poseStack, bufferSource, light, overlay);
        poseStack.popPose();
        if (ModDebugger.advancedBuilder) {
            BlockState blockState = entity.func_195044_w();
            BlockPos pos = entity.func_174877_v();
            poseStack.pushPose();
            poseStack.translate(-pos.func_177958_n(), -pos.func_177956_o(), -pos.func_177952_p());
            ShapeTesselator.stroke(((AdvancedBuilderBlockEntity)entity).getVisibleBox(blockState), UIColor.RED, poseStack, bufferSource);
            OpenVector3f origin = ((AdvancedBuilderBlockEntity)entity).getRenderOrigin();
            poseStack.translate(origin.x(), origin.y(), origin.z());
            ShapeTesselator.vector(OpenVector3f.ZERO, 1.0f, poseStack, bufferSource);
            poseStack.translate(((AdvancedBuilderBlockEntity)entity).carmeOffset.x(), ((AdvancedBuilderBlockEntity)entity).carmeOffset.y(), ((AdvancedBuilderBlockEntity)entity).carmeOffset.z());
            ShapeTesselator.vector(OpenVector3f.ZERO, 1.0f, poseStack, bufferSource);
            poseStack.popPose();
        }
    }

    protected void renderNode(SkinDocument document, SkinDocumentNode node, BakedArmature armature, float partialTicks, IPoseStack poseStack, IBufferSource bufferSource, int light, int overlay) {
        SkinDescriptor descriptor;
        SkinRenderTesselator tesselator;
        IJointTransform transform;
        if (!node.isEnabled()) {
            return;
        }
        poseStack.pushPose();
        if (armature != null && node.isLocked() && (transform = armature.transformByType(node.type())) != null) {
            transform.apply(poseStack);
        }
        node.transform().apply(poseStack);
        if (node.isLocator()) {
            poseStack.scale(-1.0f, -1.0f, 1.0f);
            ShapeTesselator.vector(OpenVector3f.ZERO, 16.0f, poseStack, bufferSource);
            poseStack.scale(-1.0f, -1.0f, 1.0f);
        }
        if ((tesselator = SkinRenderTesselator.create(TicketManager.RENDERER.get(descriptor = node.skin()))) != null) {
            tesselator.setLightmap(0xF000F0);
            tesselator.setPartialTicks(partialTicks);
            tesselator.setAnimationTicks(0.0);
            tesselator.setPoseStack(poseStack);
            tesselator.setBufferSource(bufferSource);
            tesselator.setModelViewStack(AbstractModelViewStack.getInstance());
            tesselator.draw();
        }
        for (SkinDocumentNode child : node.children()) {
            this.renderNode(document, child, armature, partialTicks, poseStack, bufferSource, light, overlay);
        }
        poseStack.popPose();
    }

    public void renderOutput(T entity, float partialTicks, MatrixStack poseStack, IRenderTypeBuffer buffers, int light, int overlay) {
        BlockPos pos = entity.func_174877_v();
        poseStack.func_227860_a_();
        poseStack.func_227861_a_((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-pos.func_177952_p()));
        if (OUTPUTS.size() >= 2) {
            // empty if block
        }
        poseStack.func_227865_b_();
    }

    protected void applyTransform(IPoseStack poseStack, SkinType skinType, OpenItemTransforms itemTransforms) {
        OpenItemDisplayContext displayContext = OpenItemDisplayContext.THIRD_PERSON_RIGHT_HAND;
        if (itemTransforms != null) {
            OpenTransform3f itemTransform = itemTransforms.get(displayContext);
            if (itemTransform != null) {
                poseStack.translate(0.0f, -2.0f, -2.0f);
                itemTransform.apply(poseStack);
            }
        } else {
            poseStack.translate(0.0f, -2.0f, -2.0f);
            SkinItemModel model = SkinItemModelManager.getInstance().getModel(skinType);
            model.getTransform(displayContext).apply(false, poseStack);
        }
    }

    @Override
    public int getViewDistance() {
        return 272;
    }

    public boolean shouldRenderOffScreen(T entity) {
        return true;
    }
}

