/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.data.properties;

import java.util.function.BiConsumer;
import java.util.function.Function;
import moe.plushie.armourers_workshop.builder.data.properties.DataProperty;
import moe.plushie.armourers_workshop.core.math.OpenVector3d;

public class Vector3dProperty
extends DataProperty<OpenVector3d> {
    private final DataProperty<Double> x = this.field(OpenVector3d::setX, OpenVector3d::x);
    private final DataProperty<Double> y = this.field(OpenVector3d::setY, OpenVector3d::y);
    private final DataProperty<Double> z = this.field(OpenVector3d::setZ, OpenVector3d::z);

    public Vector3dProperty() {
    }

    public Vector3dProperty(double x, double y, double z) {
        super(new OpenVector3d(x, y, z));
    }

    @Override
    public void set(OpenVector3d value) {
        super.set(value);
        this.x.set(value.x());
        this.y.set(value.y());
        this.z.set(value.z());
    }

    public DataProperty<Double> x() {
        return this.x;
    }

    public DataProperty<Double> y() {
        return this.y;
    }

    public DataProperty<Double> z() {
        return this.z;
    }

    private DataProperty<Double> field(final BiConsumer<OpenVector3d, Double> setter, final Function<OpenVector3d, Double> getter) {
        return new DataProperty<Double>(){

            @Override
            public void beginEditing() {
                super.beginEditing();
                Vector3dProperty.super.beginEditing();
            }

            @Override
            public void endEditing() {
                super.endEditing();
                Vector3dProperty.super.endEditing();
            }

            @Override
            public void set(Double value) {
                super.set(value);
                OpenVector3d newValue = ((OpenVector3d)Vector3dProperty.this.value).copy();
                setter.accept(newValue, value);
                Vector3dProperty.super.set(newValue);
            }

            @Override
            public Double get() {
                if (Vector3dProperty.this.value != null) {
                    return (Double)getter.apply((OpenVector3d)Vector3dProperty.this.value);
                }
                return 0.0;
            }
        };
    }
}

