/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.item;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.api.common.IBlockPaintViewer;
import moe.plushie.armourers_workshop.api.common.IConfigurableToolProperty;
import moe.plushie.armourers_workshop.api.common.IItemModelProperty;
import moe.plushie.armourers_workshop.api.common.IItemPropertiesProvider;
import moe.plushie.armourers_workshop.api.common.IItemTintColorProvider;
import moe.plushie.armourers_workshop.api.core.IDataComponentType;
import moe.plushie.armourers_workshop.api.core.IRegistryHolder;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.builder.client.gui.PaletteToolWindow;
import moe.plushie.armourers_workshop.builder.item.AbstractColoredToolItem;
import moe.plushie.armourers_workshop.builder.item.impl.IPaintToolAction;
import moe.plushie.armourers_workshop.builder.item.option.PaintingToolOptions;
import moe.plushie.armourers_workshop.builder.other.CubePaintingEvent;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.ComponentAPI;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.ToolAPI;
import moe.plushie.armourers_workshop.core.data.paint.IItemPaintable;
import moe.plushie.armourers_workshop.core.data.paint.IPaintProvider;
import moe.plushie.armourers_workshop.core.data.paint.IPaintToolPicker;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintTypes;
import moe.plushie.armourers_workshop.core.utils.ColorUtils;
import moe.plushie.armourers_workshop.core.utils.OpenDirection;
import moe.plushie.armourers_workshop.init.ModConstants;
import moe.plushie.armourers_workshop.init.ModDataComponents;
import moe.plushie.armourers_workshop.init.ModSounds;
import moe.plushie.armourers_workshop.init.environment.EnvironmentExecutorIO;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PaintbrushItem
extends AbstractColoredToolItem
implements IItemTintColorProvider,
IItemPropertiesProvider,
IItemPaintable,
IBlockPaintViewer,
IPaintToolPicker {
    public PaintbrushItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public ActionResultType func_195939_a(ItemUseContext context) {
        ActionResultType resultType = this.usePickTool(context);
        if (resultType.func_226246_a_()) {
            return resultType;
        }
        return super.func_195939_a(context);
    }

    @Override
    public ActionResultType usePickTool(World level, BlockPos pos, OpenDirection dir, TileEntity blockEntity, ItemUseContext context) {
        if (blockEntity instanceof IPaintProvider) {
            IPaintProvider provider = (IPaintProvider)blockEntity;
            this.setItemColor(context.func_195996_i(), provider.color());
            return ActionResultType.func_233537_a_((boolean)level.func_201670_d());
        }
        return ActionResultType.PASS;
    }

    @Override
    public void createToolProperties(Consumer<IConfigurableToolProperty<?>> builder) {
        builder.accept(PaintingToolOptions.FULL_BLOCK_MODE);
        builder.accept(PaintingToolOptions.CHANGE_PAINT_COLOR);
        builder.accept(PaintingToolOptions.CHANGE_PAINT_TYPE);
    }

    @Override
    public IPaintToolAction createPaintToolAction(ItemUseContext context) {
        ItemStack itemStack = context.func_195996_i();
        SkinPaintColor paintColor = this.getItemColor(itemStack, SkinPaintColor.WHITE);
        Boolean usePaintColor = ToolAPI.get(itemStack, PaintingToolOptions.CHANGE_PAINT_COLOR);
        Boolean usePaintType = ToolAPI.get(itemStack, PaintingToolOptions.CHANGE_PAINT_TYPE);
        return new CubePaintingEvent.SetAction(paintColor, usePaintColor, usePaintType);
    }

    @Override
    public void createModelProperties(BiConsumer<IResourceLocation, IItemModelProperty> builder) {
        builder.accept(ModConstants.key("small"), (itemStack, level, entity, id) -> ToolAPI.get(itemStack, PaintingToolOptions.FULL_BLOCK_MODE) != false ? 0.0f : 1.0f);
    }

    @Override
    public void appendColorHoverText(ItemStack itemStack, List<ITextComponent> tooltips) {
        SkinPaintColor paintColor = this.getItemColor(itemStack, SkinPaintColor.WHITE);
        tooltips.addAll(ColorUtils.getColorTooltips(paintColor, true));
    }

    @Override
    public boolean openContainer(World level, PlayerEntity player, Hand hand, ItemStack itemStack) {
        if (level.func_201670_d() && EnvironmentExecutorIO.hasControlDown()) {
            this.openPaletteGUI(level, player, hand, itemStack);
            return true;
        }
        return super.openContainer(level, player, hand, itemStack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void openPaletteGUI(World level, PlayerEntity player, Hand hand, ItemStack itemStack) {
        PaletteToolWindow window = new PaletteToolWindow(itemStack.func_200301_q(), itemStack, hand);
        EnvironmentManager.getClient().func_147108_a(window.asScreen());
    }

    @Override
    public void setItemColor(ItemStack itemStack, SkinPaintColor paintColor) {
        ComponentAPI.set(itemStack, (IDataComponentType)ModDataComponents.TOOL_COLOR.get(), paintColor);
    }

    @Override
    public SkinPaintColor getItemColor(ItemStack itemStack) {
        return (SkinPaintColor)ComponentAPI.get(itemStack, (IDataComponentType)ModDataComponents.TOOL_COLOR.get());
    }

    @Override
    public int getTintColor(ItemStack itemStack, int index) {
        if (index == 1) {
            return ColorUtils.getDisplayRGB(itemStack);
        }
        return -1;
    }

    @Override
    public IRegistryHolder<SoundEvent> getItemSoundEvent(ItemUseContext context) {
        return ModSounds.PAINT;
    }

    public boolean func_77636_d(ItemStack itemStack) {
        SkinPaintColor paintColor = this.getItemColor(itemStack, SkinPaintColor.WHITE);
        return paintColor.paintType() != SkinPaintTypes.NORMAL;
    }
}

